/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProviderWithBase;
import com.jetbrains.cidr.xcode.plist.Plist;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePackageType
implements BuildSettingValuesProvider {
    @NotNull
    private final ApplePlatform myPlatform;
    @NotNull
    private final String myId;
    @Nullable
    private final String myBasedOn;
    @Nullable
    private final String myName;
    @Nullable
    private final String myDescription;
    @Nullable
    private final String myProductReferenceName;
    @Nullable
    private final String myProductReferenceFileType;
    @NotNull
    private final Dictionary myBuildSettings;
    @NotNull
    private final BuildSettingValuesProvider mySettingValuesProvider;

    ApplePackageType(@NotNull Plist plist, @NotNull ApplePlatform platform) {
        if (plist == null) {
            ApplePackageType.$$$reportNull$$$0(0);
        }
        if (platform == null) {
            ApplePackageType.$$$reportNull$$$0(1);
        }
        this.myPlatform = platform;
        this.myId = plist.getNotNullString("Identifier");
        this.myBasedOn = plist.getString("BasedOn");
        this.myName = plist.getString("Name");
        this.myDescription = plist.getString("Description");
        Dictionary productReference = plist.getDictionary("ProductReference", Dictionary.EMPTY_DICTIONARY);
        this.myProductReferenceName = productReference.getString("Name");
        this.myProductReferenceFileType = productReference.getString("FileType");
        this.myBuildSettings = plist.getDictionary("DefaultBuildSettings", Dictionary.EMPTY_DICTIONARY);
        this.mySettingValuesProvider = new BuildSettingValuesProviderWithBase(){

            @Override
            protected BuildSettingValuesProvider getBase() {
                return ApplePackageType.this.getBaseType();
            }

            @Override
            @NotNull
            protected Dictionary getSettings() {
                Dictionary dictionary = ApplePackageType.this.myBuildSettings;
                if (dictionary == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/ApplePackageType$1", "getSettings"));
            }
        };
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            ApplePackageType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public ApplePackageType getBaseType() {
        return this.myPlatform.findPackageType(this.myBasedOn);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getProductReferenceName() {
        return this.myProductReferenceName;
    }

    @Nullable
    public String getProductReferenceFileType() {
        return this.myProductReferenceFileType;
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.mySettingValuesProvider.getDeclaredBuildSettingValues();
        if (dictionary == null) {
            ApplePackageType.$$$reportNull$$$0(3);
        }
        return dictionary;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.myId);
        if (this.myBasedOn != null) {
            result.append("(").append(this.myBasedOn).append(")");
        }
        result.append(": ").append(this.myName);
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/ApplePackageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/ApplePackageType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

