/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.SpecListHelper;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class AppleFileTypeManager {
    @NotNull
    private final Map<String, AppleFileType> myIdToFileTypeMap;
    @NotNull
    private final Map<String, AppleFileType> myExtensionToFileTypeMap;
    @NotNull
    private final Map<String, AppleFileType> myLowerCaseExtensionToFileTypeMap;
    @NotNull
    private final Map<Pattern, AppleFileType> myPatternToFileTypeMap;

    @NotNull
    public static AppleFileTypeManager getInstance() {
        AppleFileTypeManager appleFileTypeManager = (AppleFileTypeManager)ApplicationManager.getApplication().getService(AppleFileTypeManager.class);
        if (appleFileTypeManager == null) {
            AppleFileTypeManager.$$$reportNull$$$0(0);
        }
        return appleFileTypeManager;
    }

    public AppleFileTypeManager() {
        ArrayList<AppleFileType> types = new ArrayList<AppleFileType>();
        this.collectBuiltinTypes(types);
        for (Path eachSpecFolder : AppleSdkManager.getSpecsFolders()) {
            AppleFileTypeManager.processSpecs(eachSpecFolder, types, plist -> new AppleFileType(plist, this));
        }
        for (XCSpecFile file : XcodeExtensionsManager.getInstance().getXCSpecFileList("default")) {
            AppleFileTypeManager.processSpecFile(file.getPath(), types, plist -> new AppleFileType(plist, this));
        }
        HashMap<String, AppleFileType> idToFileTypeMap = new HashMap<String, AppleFileType>();
        HashMap<String, AppleFileType> extensionToFileTypeMap = new HashMap<String, AppleFileType>();
        HashMap<String, AppleFileType> lowerCaseExtensionToFileTypeMap = new HashMap<String, AppleFileType>();
        HashMap<Pattern, AppleFileType> patternToFileTypeMap = new HashMap<Pattern, AppleFileType>();
        for (AppleFileType eachType : types) {
            idToFileTypeMap.put(eachType.getId(), eachType);
            for (String eachExtension : eachType.getExtensions()) {
                extensionToFileTypeMap.put(eachExtension, eachType);
                lowerCaseExtensionToFileTypeMap.put(StringUtil.toLowerCase((String)eachExtension), eachType);
            }
            for (Pattern eachPattern : eachType.getFilenamePatterns()) {
                patternToFileTypeMap.put(eachPattern, eachType);
            }
        }
        this.myIdToFileTypeMap = Collections.unmodifiableMap(idToFileTypeMap);
        this.myExtensionToFileTypeMap = Collections.unmodifiableMap(extensionToFileTypeMap);
        this.myLowerCaseExtensionToFileTypeMap = Collections.unmodifiableMap(lowerCaseExtensionToFileTypeMap);
        this.myPatternToFileTypeMap = Collections.unmodifiableMap(patternToFileTypeMap);
    }

    private void collectBuiltinTypes(List<AppleFileType> result) {
        try (InputStream stream = this.getClass().getResourceAsStream("FileTypes.xml");){
            Plist plist;
            if (stream != null && (plist = PlistDriver.readAnyFormatSafe((InputStream)stream)) != null) {
                result.addAll(SpecListHelper.readSpecs(plist, null, plist1 -> new AppleFileType(plist1, this)));
            }
        }
        catch (IOException e) {
            Logger.getInstance(AppleFileTypeManager.class).error((Throwable)e);
        }
    }

    public static <T> void processSpecs(Path dir, List<T> result, SpecListHelper.Factory<T> factory) {
        try (DirectoryStream<Path> resources = Files.newDirectoryStream(dir);){
            for (Path each : resources) {
                AppleFileTypeManager.processSpecFile(each, result, factory);
            }
        }
        catch (IOException e) {
            XCLog.LOG.warn((Throwable)e);
        }
    }

    private static <T> void processSpecFile(Path each, List<T> result, SpecListHelper.Factory<T> factory) {
        boolean isFileTypes = StringUtil.endsWithIgnoreCase((String)each.getFileName().toString(), (String)".pbfilespec");
        if (isFileTypes || StringUtil.endsWithIgnoreCase((String)each.getFileName().toString(), (String)".xcspec")) {
            result.addAll(SpecListHelper.readSpecs(each, isFileTypes ? null : "FileType", factory));
        }
    }

    @Nullable
    public AppleFileType findFileTypeById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.myIdToFileTypeMap.get(id);
    }

    @Nullable
    public AppleFileType findFileTypeByExtension(@Nullable String extension) {
        if (extension == null) {
            return null;
        }
        AppleFileType result = this.myExtensionToFileTypeMap.get(extension);
        return result != null ? result : this.myLowerCaseExtensionToFileTypeMap.get(StringUtil.toLowerCase((String)extension));
    }

    @Nullable
    public AppleFileType findFileTypeByFilename(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        for (Map.Entry<Pattern, AppleFileType> each : this.myPatternToFileTypeMap.entrySet()) {
            if (!each.getKey().matcher(fileName).matches()) continue;
            return each.getValue();
        }
        AppleFileType result = this.findFileTypeByExtension(FileUtilRt.getExtension((String)fileName));
        if (result != null) {
            return result;
        }
        return null;
    }

    @NotNull
    public String getSuitableFileTypeIdByFile(@Nullable Path file) {
        String string = this.getSuitableFileTypeIdByFilename(file != null ? file.getFileName().toString() : null, file != null && Files.isDirectory(file, new LinkOption[0]));
        if (string == null) {
            AppleFileTypeManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getSuitableFileTypeIdByFilename(@Nullable String fileName, boolean isDirectory) {
        if (fileName != null) {
            for (Map.Entry<Pattern, AppleFileType> each : this.myPatternToFileTypeMap.entrySet()) {
                if (!each.getKey().matcher(fileName).matches()) continue;
                String string = each.getValue().getId();
                if (string == null) {
                    AppleFileTypeManager.$$$reportNull$$$0(2);
                }
                return string;
            }
            String extension = FileUtilRt.getExtension((String)fileName);
            if (extension.isEmpty() && isDirectory) {
                return "folder";
            }
            AppleFileType result = this.findFileTypeByExtension(extension);
            if (result != null) {
                String string = result.getId();
                if (string == null) {
                    AppleFileTypeManager.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (isDirectory) {
                return "folder";
            }
            if (!StringUtil.isEmptyOrSpaces((String)extension)) {
                String string = "file." + extension;
                if (string == null) {
                    AppleFileTypeManager.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return "text";
    }

    public boolean isTextFile(@Nullable String fileName) {
        AppleFileType type = this.findFileTypeByFilename(fileName);
        return type != null && type.isTextFile();
    }

    public boolean isSourceCodeFile(@Nullable String fileName) {
        AppleFileType type = this.findFileTypeByFilename(fileName);
        return type != null && type.isSourceCode();
    }

    public boolean isHeaderFile(@Nullable String fileName) {
        AppleFileType type = this.findFileTypeByFilename(fileName);
        return type != null && type.isHeader();
    }

    public boolean isFramework(@Nullable VirtualFile file) {
        AppleFileType type;
        return file != null && file.isDirectory() && (type = this.findFileTypeByFilename(file.getName())) != null && type.isFrameworkWrapper();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/xcode/frameworks/AppleFileTypeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypeIdByFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypeIdByFilename";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

