/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleFileType {
    @Deprecated
    @ApiStatus.Internal
    @NonNls
    public static final String XCDATAMODELD = "wrapper.xcdatamodeld";
    @NonNls
    public static final String TEXT = "text";
    @NonNls
    public static final String FOLDER = "folder";
    @NonNls
    public static final String ASSET_CATALOG = "folder.assetcatalog";
    @NonNls
    public static final String SOURCECODE_OBJCPP = "sourcecode.cpp.objcpp";
    @NonNls
    public static final String SOURCECODE_CPP = "sourcecode.cpp.cpp";
    @NonNls
    public static final String SOURCECODE_C = "sourcecode.c.c";
    @NonNls
    public static final String SOURCECODE_SWIFT = "sourcecode.swift";
    @NonNls
    public static final String SOURCECODE_OBJC = "sourcecode.c.objc";
    @NonNls
    public static final String SOURCECODE_GLSL = "sourcecode.glsl";
    @NotNull
    private final AppleFileTypeManager myManager;
    @NotNull
    private final String myId;
    @Nullable
    private final String myBasedOn;
    @Nullable
    private final Boolean myIsTextFile;
    @Nullable
    private final Boolean myIsSourceCode;
    @Nullable
    private final Boolean myIsPlist;
    @Nullable
    private final Boolean myIncludeInIndex;
    @Nullable
    private final Boolean myIsFrameworkWrapper;
    @Nullable
    private final Boolean myIsProjectWrapper;
    @Nullable
    private final Boolean myIsFolder;
    @Nullable
    private final Boolean myIsLibrary;
    @Nullable
    private final Boolean myIsApplication;
    @Nullable
    private final boolean myIsApplicationExtension;
    @Nullable
    private final Boolean myIsExecutable;
    @Nullable
    private final Boolean myIsWrapperFolder;
    @Nullable
    private final Boolean myCodeSignOnCopy;
    @Nullable
    private final Boolean myRemoveHeadersOnCopy;
    @Nullable
    private final Boolean myValidateOnCopy;
    @Nullable
    private final String myLanguage;
    @NotNull
    private final List<String> myExtensions;
    @NotNull
    private final List<Pattern> myFilenamePatterns;
    @NotNull
    private final List<String> myMimeTypes;
    @NotNull
    private final List<Dictionary> myBuildPhaseInjectionsWhenEmbedding;
    private volatile Boolean myIsTextCache;

    AppleFileType(@NotNull Plist plist, @NotNull AppleFileTypeManager manager) {
        if (plist == null) {
            AppleFileType.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AppleFileType.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
        this.myId = plist.getNotNullString("Identifier");
        this.myBasedOn = plist.getString("BasedOn");
        this.myIsTextFile = plist.getBoolean("IsTextFile");
        this.myIsSourceCode = plist.getBoolean("IsSourceCode");
        this.myIncludeInIndex = plist.getBoolean("IncludeInIndex");
        this.myIsFrameworkWrapper = plist.getBoolean("IsFrameworkWrapper");
        this.myIsProjectWrapper = plist.getBoolean("IsProjectWrapper");
        this.myIsFolder = plist.getBoolean("IsFolder");
        this.myIsWrapperFolder = plist.getBoolean("IsWrapperFolder");
        this.myIsApplication = plist.getBoolean("IsApplication");
        this.myIsApplicationExtension = "wrapper.app-extension".equals(this.myId);
        this.myIsExecutable = plist.getBoolean("IsExecutable");
        this.myIsLibrary = plist.getBoolean("IsLibrary");
        this.myCodeSignOnCopy = plist.getBoolean("CodeSignOnCopy");
        this.myRemoveHeadersOnCopy = plist.getBoolean("RemoveHeadersOnCopy");
        this.myValidateOnCopy = plist.getBoolean("ValidateOnCopy");
        this.myLanguage = plist.getString("Language");
        this.myIsPlist = "xcode.lang.plist".equals(this.myLanguage) ? Boolean.valueOf(true) : null;
        this.myExtensions = Collections.unmodifiableList(plist.getAttributeList("Extensions", String.class, Collections.emptyList()));
        this.myBuildPhaseInjectionsWhenEmbedding = Collections.unmodifiableList(plist.getAttributeList("BuildPhaseInjectionsWhenEmbedding", Dictionary.class, Collections.emptyList()));
        List patterns = plist.getAttributeList("FilenamePatterns", String.class, Collections.emptyList());
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        for (String each : patterns) {
            try {
                compiled.add(Pattern.compile(each));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                compiled.add(Pattern.compile(FileUtil.convertAntToRegexp((String)each)));
            }
            catch (Exception exception) {}
        }
        compiled.trimToSize();
        this.myFilenamePatterns = compiled.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(compiled);
        this.myMimeTypes = Collections.unmodifiableList(plist.getAttributeList("MIMETypes", String.class, Collections.emptyList()));
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AppleFileType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public AppleFileType getBaseType() {
        return this.myManager.findFileTypeById(this.myBasedOn);
    }

    public boolean isSourceCode() {
        if (this.myIsSourceCode != null) {
            return this.myIsSourceCode;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isSourceCode();
    }

    public boolean isPlist() {
        if (this.myIsPlist != null) {
            return this.myIsPlist;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isPlist();
    }

    public boolean isTextFile() {
        if (this.myIsTextCache == null) {
            this.myIsTextCache = this.calcIsText();
        }
        return this.myIsTextCache;
    }

    private boolean calcIsText() {
        if (this.myIsTextFile != null) {
            return this.myIsTextFile;
        }
        if (!this.myMimeTypes.isEmpty()) {
            for (String each : this.myMimeTypes) {
                if (!each.startsWith("text/") && !"application/json".equals(each)) continue;
                return true;
            }
            return false;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isTextFile();
    }

    public boolean isHeader() {
        return this.isSourceCode() && !this.isIncludeInIndex();
    }

    private boolean isIncludeInIndex() {
        if (this.myIncludeInIndex != null) {
            return this.myIncludeInIndex;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isIncludeInIndex();
    }

    public boolean isFrameworkWrapper() {
        if (this.myIsFrameworkWrapper != null) {
            return this.myIsFrameworkWrapper;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isFrameworkWrapper();
    }

    public boolean isLibrary() {
        if (this.myIsLibrary != null) {
            return this.myIsLibrary;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isLibrary();
    }

    public boolean isApplication() {
        if (this.myIsApplication != null) {
            return this.myIsApplication;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isApplication();
    }

    public boolean isApplicationExtension() {
        return this.myIsApplicationExtension;
    }

    public boolean isExecutable() {
        if (this.myIsExecutable != null) {
            return this.myIsExecutable;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isExecutable();
    }

    public boolean isFolder() {
        if (this.myIsFolder != null) {
            return this.myIsFolder;
        }
        AppleFileType baseType = this.getBaseType();
        return baseType != null && baseType.isFolder();
    }

    public boolean isWrapperFolder() {
        if (this.myIsWrapperFolder != null) {
            return this.myIsWrapperFolder;
        }
        AppleFileType baseType = this.getBaseType();
        return baseType != null && baseType.isWrapperFolder();
    }

    public boolean isProjectWrapper() {
        if (this.myIsProjectWrapper != null) {
            return this.myIsProjectWrapper;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.isProjectWrapper();
    }

    public boolean getCodeSignOnCopy() {
        if (this.myCodeSignOnCopy != null) {
            return this.myCodeSignOnCopy;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.getCodeSignOnCopy();
    }

    public boolean getRemoveHeadersOnCopy() {
        if (this.myRemoveHeadersOnCopy != null) {
            return this.myRemoveHeadersOnCopy;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.getRemoveHeadersOnCopy();
    }

    public boolean getValidateOnCopy() {
        if (this.myValidateOnCopy != null) {
            return this.myValidateOnCopy;
        }
        AppleFileType base = this.getBaseType();
        return base != null && base.getValidateOnCopy();
    }

    @Nullable
    public String getLanguage() {
        return this.myLanguage;
    }

    @NotNull
    public List<String> getExtensions() {
        List<String> list = this.myExtensions;
        if (list == null) {
            AppleFileType.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<Pattern> getFilenamePatterns() {
        List<Pattern> list = this.myFilenamePatterns;
        if (list == null) {
            AppleFileType.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Dictionary> getBuildPhaseInjectionsWhenEmbedding() {
        List<Dictionary> list = this.myBuildPhaseInjectionsWhenEmbedding;
        if (list == null) {
            AppleFileType.$$$reportNull$$$0(5);
        }
        return list;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.myId);
        if (this.myBasedOn != null) {
            result.append("(").append(this.myBasedOn).append(")");
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilenamePatterns";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPhaseInjectionsWhenEmbedding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

