/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.XcodeCoreBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XcodeVersionUtil {
    public static final Version MinOS = new Version(15, 6);
    public static final Version MinXcode = new Version(16, 4);
    public static final Version UnsupportedOS = new Version(26, 2);
    public static final Version UnsupportedXcode = new Version(26, 2);
    public static final String RecommendedOS = "26.1";
    public static final String RecommendedXcode = "26.1";

    private XcodeVersionUtil() {
    }

    @Nullable
    public static HtmlBuilder isSupportedVersion(@NotNull Version currentOS, @NotNull ToolVersion currentXcode) {
        if (currentOS == null) {
            XcodeVersionUtil.$$$reportNull$$$0(0);
        }
        if (currentXcode == null) {
            XcodeVersionUtil.$$$reportNull$$$0(1);
        }
        if (currentOS.compareTo(MinOS) < 0 || currentOS.compareTo(UnsupportedOS) >= 0) {
            return new HtmlBuilder().append(XcodeCoreBundle.message("settings.macos.notSupported.0", currentOS.toCompactString(), currentXcode.toString())).br().append(XcodeCoreBundle.message("settings.macos.notSupported.1", new Object[0])).br().append(XcodeCoreBundle.message("settings.macos.notSupported.2", "26.1", "26.1"));
        }
        if (currentXcode.versionNumber.compareTo(UnsupportedXcode) >= 0) {
            return new HtmlBuilder().append(XcodeCoreBundle.message("settings.xcode.using", currentXcode.toString())).br().append(XcodeCoreBundle.message("settings.xcode.version.too.new", new Object[0])).br().append(XcodeCoreBundle.message("settings.xcode.version.too.new.tip", "26.1"));
        }
        if (currentXcode.versionNumber.compareTo(MinXcode) < 0) {
            return new HtmlBuilder().append(XcodeCoreBundle.message("settings.xcode.using", currentXcode.toString())).br().append(XcodeCoreBundle.message("settings.xcode.version.too.old", MinXcode.toString())).br().append(XcodeCoreBundle.message("settings.xcode.version.too.old.tip", "26.1"));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "currentOS";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "currentXcode";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/xcode/XcodeVersionUtil";
        objectArray[2] = "isSupportedVersion";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

