/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.OCCorePathManager;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeVersionUtil;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XcodeInstallation {
    @NotNull
    private final File myBaseFile;
    private final AtomicNotNullLazyValue<File> myAppFileCache;
    private final AtomicNotNullLazyValue<ToolVersion> myVersionCache;
    private final AtomicNotNullLazyValue<Plist> mySettingsCache;
    private final AtomicNotNullLazyValue<Plist> myPlistCache;
    private final AtomicNotNullLazyValue<Plist> myVersionPlistCache;

    public XcodeInstallation(@NotNull File baseFile) {
        if (baseFile == null) {
            XcodeInstallation.$$$reportNull$$$0(0);
        }
        this.myAppFileCache = AtomicNotNullLazyValue.createValue(() -> XcodeInstallation.discoverApplicationFile(this.getBaseFile()));
        this.myVersionCache = AtomicNotNullLazyValue.createValue(() -> {
            String versionString = this.getVersionString();
            List parts = StringUtil.split((String)versionString, (String)".");
            int major = XcodeInstallation.getVersionPart(parts, 0);
            int minor = XcodeInstallation.getVersionPart(parts, 1);
            int bugfix = XcodeInstallation.getVersionPart(parts, 2);
            return major == 0 ? ToolVersion.createUnknown((String)versionString) : new ToolVersion(versionString, major, minor, bugfix);
        });
        this.mySettingsCache = AtomicNotNullLazyValue.createValue(() -> {
            File file = OCCorePathManager.getUserPreferencesDirSubFile(this.getBundleID() + ".plist");
            return XcodeInstallation.doReadPlist(file);
        });
        this.myPlistCache = AtomicNotNullLazyValue.createValue(() -> {
            File file = this.getApplicationContentsSubFile("Info.plist");
            return XcodeInstallation.doReadPlist(file);
        });
        this.myVersionPlistCache = AtomicNotNullLazyValue.createValue(() -> {
            File file = this.getSubFile("Library/version.plist");
            if (!file.exists()) {
                file = this.getApplicationContentsSubFile("version.plist");
            }
            return XcodeInstallation.doReadPlist(file);
        });
        if (!baseFile.getName().equals("Developer")) {
            XCLog.LOG.warn("Specify Developer dir, not Xcode app dir: " + baseFile.getPath());
        }
        this.myBaseFile = XcodeInstallation.canonicalSafe(baseFile);
    }

    @NotNull
    private static File canonicalSafe(@NotNull File file) {
        File file2;
        if (file == null) {
            XcodeInstallation.$$$reportNull$$$0(1);
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException e) {
            XCLog.LOG.warn((Throwable)e);
            File file3 = file;
            if (file3 == null) {
                XcodeInstallation.$$$reportNull$$$0(3);
            }
            return file3;
        }
        if (file2 == null) {
            XcodeInstallation.$$$reportNull$$$0(2);
        }
        return file2;
    }

    public boolean isValid() {
        return this.isInstalled() && this.isSupportedVersion() == null;
    }

    public boolean isInstalled() {
        return !this.getVersion().isUnknown() && "Xcode".equals(this.getBundleName());
    }

    @Nullable
    public HtmlBuilder isSupportedVersion() {
        return XcodeVersionUtil.isSupportedVersion(OS.CURRENT.parsedVersion(), this.getVersion());
    }

    @NotNull
    @NlsSafe
    public String getBasePath() {
        String string = this.getBaseFile().getPath();
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public File getBaseFile() {
        File file = this.myBaseFile;
        if (file == null) {
            XcodeInstallation.$$$reportNull$$$0(5);
        }
        return file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XcodeInstallation that = (XcodeInstallation)o;
        return FileUtil.filesEqual((File)this.myBaseFile, (File)that.myBaseFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myBaseFile);
    }

    @NotNull
    public File getSubFile(@Nullable @NonNls String relativePath) {
        return relativePath == null ? this.getBaseFile() : new File(this.getBaseFile(), relativePath);
    }

    @NotNull
    public String getSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getSubFile(relativePath).getPath();
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public File getApplicationFile() {
        File file = (File)this.myAppFileCache.getValue();
        if (file == null) {
            XcodeInstallation.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public String getApplicationFilePath() {
        String string = this.getApplicationFile().getPath();
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public File getApplicationContentsSubFile(@Nullable @NonNls String relativePath) {
        File contents = new File(this.getApplicationFile(), "Contents");
        File file = relativePath != null ? new File(contents, relativePath) : contents;
        if (file == null) {
            XcodeInstallation.$$$reportNull$$$0(9);
        }
        return file;
    }

    @NotNull
    public String getApplicationContentsSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getApplicationContentsSubFile(relativePath).getPath();
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public File getApplicationsSubFile(@Nullable @NonNls String relativePath) {
        File result = this.getApplicationContentsSubFile("Applications");
        if (!result.exists()) {
            result = this.getSubFile("Applications");
        }
        return relativePath == null ? result : new File(result, relativePath);
    }

    @NotNull
    public String getApplicationsSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getApplicationsSubFile(relativePath).getPath();
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public List<File> getXcodeFrameworksFolders() {
        List<File> list = Arrays.asList(this.getApplicationContentsSubFile("Frameworks"), this.getApplicationContentsSubFile("OtherFrameworks"), this.getApplicationContentsSubFile("SharedFrameworks"), this.getSubFile("/Library/PrivateFrameworks"));
        if (list == null) {
            XcodeInstallation.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<File> getXcodePluginsFolders() {
        ArrayList<File> result = new ArrayList<File>();
        result.add(this.getApplicationContentsSubFile("SharedFrameworks/XCBuild.framework/Versions/A/PlugIns/XCBBuildService.bundle/Contents/PlugIns"));
        result.add(this.getSubFile("Library/Xcode/Plug-Ins"));
        result.add(this.getApplicationContentsSubFile("PlugIns"));
        File[] platforms = this.getSubFile("Platforms").listFiles(FileFilters.withExtension((String)"platform"));
        if (platforms != null) {
            for (File platform : platforms) {
                result.add(new File(platform, "Developer/Library/Xcode/PrivatePlugIns"));
            }
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            XcodeInstallation.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public String getBundleName() {
        return this.getXcodeAppPlist().getString("CFBundleName");
    }

    @NotNull
    public String getVersionString() {
        String string = this.getXcodeAppPlist().getString("CFBundleShortVersionString", "unknown");
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getBuildVersionString() {
        String string = ((Plist)this.myVersionPlistCache.getValue()).getString("ProductBuildVersion", "unknown");
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getDisplayVersion() {
        String string = this.getVersionString() + " (" + this.getBuildVersionString() + ")";
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public ToolVersion getVersion() {
        ToolVersion toolVersion = (ToolVersion)this.myVersionCache.getValue();
        if (toolVersion == null) {
            XcodeInstallation.$$$reportNull$$$0(17);
        }
        return toolVersion;
    }

    private static int getVersionPart(List<String> parts, int index) {
        if (index > parts.size() - 1) {
            return 0;
        }
        try {
            return Integer.parseInt(parts.get(index));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @NotNull
    public String getBundleID() {
        String string = this.getXcodeAppPlist().getString("CFBundleIdentifier", "com.apple.Xcode");
        if (string == null) {
            XcodeInstallation.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public Plist getSettings() {
        Plist plist = (Plist)this.mySettingsCache.getValue();
        if (plist == null) {
            XcodeInstallation.$$$reportNull$$$0(19);
        }
        return plist;
    }

    @NotNull
    private Plist getXcodeAppPlist() {
        Plist plist = (Plist)this.myPlistCache.getValue();
        if (plist == null) {
            XcodeInstallation.$$$reportNull$$$0(20);
        }
        return plist;
    }

    @NotNull
    public Dictionary getBuildSettings() {
        Dictionary dictionary = this.getSettings().getDictionary(this.getBuildSettingsKey(), Dictionary.EMPTY_DICTIONARY);
        if (dictionary == null) {
            XcodeInstallation.$$$reportNull$$$0(21);
        }
        return dictionary;
    }

    @NotNull
    @NonNls
    public String getBuildSettingsKey() {
        return this.getVersion().versionNumber.is(Integer.valueOf(3)) ? "PBXApplicationwideBuildSettings" : "IDEApplicationwideBuildSettings";
    }

    @NotNull
    private static Plist doReadPlist(@NotNull File file) {
        if (file == null) {
            XcodeInstallation.$$$reportNull$$$0(22);
        }
        Plist result = null;
        if (file.exists()) {
            result = PlistDriver.readAnyFormatSafe((File)file);
        }
        Plist plist = result == null ? new Plist() : result;
        if (plist == null) {
            XcodeInstallation.$$$reportNull$$$0(23);
        }
        return plist;
    }

    @NotNull
    private static File discoverApplicationFile(@NotNull File xcodeBase) {
        String path;
        if (xcodeBase == null) {
            XcodeInstallation.$$$reportNull$$$0(24);
        }
        if ((path = FileUtil.toCanonicalPath((String)xcodeBase.getPath())).endsWith(".app/Contents/Developer")) {
            File file = xcodeBase.getParentFile().getParentFile();
            if (file == null) {
                XcodeInstallation.$$$reportNull$$$0(25);
            }
            return file;
        }
        return new File(xcodeBase, "/Applications/Xcode.app");
    }

    @NonNls
    public String toString() {
        return "Xcode@" + String.valueOf(this.myBaseFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XcodeInstallation";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xcodeBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XcodeInstallation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalSafe";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContentsSubFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContentsSubFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationsSubFilePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeFrameworksFolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodePluginsFolders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersionString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleID";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeAppPlist";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadPlist";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverApplicationFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canonicalSafe";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doReadPlist";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "discoverApplicationFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 25 -> new IllegalStateException(string);
        };
    }
}

