/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XCConfigParser {
    @NotNull
    public static Dictionary parseFile(@NotNull PBXProjectFile file, @Nullable VirtualFile xconfigFile) {
        if (file == null) {
            XCConfigParser.$$$reportNull$$$0(0);
        }
        return XCConfigParser.parseFile(file.getBaseDir(), xconfigFile);
    }

    @NotNull
    public static Dictionary parseFile(@NotNull VirtualFile baseDir, @Nullable VirtualFile xconfigFile) {
        if (baseDir == null) {
            XCConfigParser.$$$reportNull$$$0(1);
        }
        return XCConfigParser.doParseFile(baseDir, xconfigFile, new HashSet<VirtualFile>());
    }

    @NotNull
    private static Dictionary doParseFile(@NotNull VirtualFile baseDir, @Nullable VirtualFile xconfigFile, @NotNull Set<VirtualFile> recursionGuard) {
        if (baseDir == null) {
            XCConfigParser.$$$reportNull$$$0(2);
        }
        if (recursionGuard == null) {
            XCConfigParser.$$$reportNull$$$0(3);
        }
        if (xconfigFile == null || xconfigFile.isDirectory() || xconfigFile.getFileType().isBinary()) {
            Dictionary dictionary = Dictionary.EMPTY_DICTIONARY;
            if (dictionary == null) {
                XCConfigParser.$$$reportNull$$$0(4);
            }
            return dictionary;
        }
        if (!recursionGuard.add(xconfigFile)) {
            Dictionary dictionary = Dictionary.EMPTY_DICTIONARY;
            if (dictionary == null) {
                XCConfigParser.$$$reportNull$$$0(5);
            }
            return dictionary;
        }
        Dictionary answer = new Dictionary();
        String text = XCConfigParser.loadText(xconfigFile);
        for (String line : StringUtil.split((String)text, (String)"\n")) {
            int commentPos = line.indexOf("//");
            if (commentPos != -1) {
                line = line.substring(0, commentPos);
            }
            line = line.trim();
            if ((line = StringUtil.trimEnd((String)line, (String)";")).startsWith("#include")) {
                VirtualFile includee;
                String includedPath = StringUtil.trimStart((String)StringUtil.trimStart((String)line, (String)"#include"), (String)"?").trim();
                if (includedPath.startsWith("\"") || includedPath.startsWith("<")) {
                    includedPath = includedPath.substring(1);
                }
                if (includedPath.endsWith("\"") || includedPath.endsWith(">")) {
                    includedPath = includedPath.substring(0, includedPath.length() - 1);
                }
                if ((includee = xconfigFile.getParent().findFileByRelativePath(includedPath)) == null) {
                    includee = baseDir.findFileByRelativePath(includedPath);
                }
                answer.putAll((Map)XCConfigParser.doParseFile(baseDir, includee, recursionGuard));
                continue;
            }
            int eqidx = -1;
            int insideBrackets = 0;
            boolean insideQuotes = false;
            for (int i = 0; i < line.length(); ++i) {
                char ch = line.charAt(i);
                if (ch == '\"' && (i == 0 || line.charAt(i - 1) != '\\')) {
                    insideQuotes = !insideQuotes;
                    continue;
                }
                if (insideQuotes) continue;
                if (insideBrackets == 0 && ch == '=') {
                    eqidx = i;
                    break;
                }
                if (ch == '[' || ch == '(' || ch == '{' || ch == '<') {
                    ++insideBrackets;
                    continue;
                }
                if (ch != ']' && ch != ')' && ch != '}' && ch != '>') continue;
                --insideBrackets;
            }
            if (eqidx <= 0) continue;
            String key = line.substring(0, eqidx).trim();
            String value = line.substring(eqidx + 1).trim();
            answer.put(key, (Object)value);
        }
        Dictionary dictionary = answer;
        if (dictionary == null) {
            XCConfigParser.$$$reportNull$$$0(6);
        }
        return dictionary;
    }

    @NotNull
    private static String loadText(@NotNull VirtualFile xconfigFile) {
        String string;
        if (xconfigFile == null) {
            XCConfigParser.$$$reportNull$$$0(7);
        }
        try {
            xconfigFile.setCharset(StandardCharsets.UTF_8);
            string = LoadTextUtil.getTextByBinaryPresentation((byte[])xconfigFile.contentsToByteArray(), (Charset)StandardCharsets.UTF_8).toString();
        }
        catch (IOException e) {
            return "";
        }
        if (string == null) {
            XCConfigParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursionGuard";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XCConfigParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xconfigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XCConfigParser";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doParseFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

