/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RWASupport {
    private static final ThreadLocal<Boolean> ourIsParsing = ThreadLocal.withInitial(() -> false);
    @NotNull
    protected final Checker myChecker;

    public static <T> T parsingScope(ThrowableComputable<T, ? extends IOException> action) throws IOException {
        try {
            ourIsParsing.set(true);
            Object object = action.compute();
            return (T)object;
        }
        finally {
            ourIsParsing.set(false);
        }
    }

    public static <T> void parsingScope(ThrowableRunnable<? extends IOException> action) throws IOException {
        try {
            ourIsParsing.set(true);
            action.run();
        }
        finally {
            ourIsParsing.set(false);
        }
    }

    public RWASupport() {
        this(new SimpleChecker());
    }

    public RWASupport(@NotNull Checker checker) {
        if (checker == null) {
            RWASupport.$$$reportNull$$$0(0);
        }
        this.myChecker = checker;
    }

    protected void checkRead() {
        this.myChecker.checkRead();
    }

    protected void checkWrite() {
        this.myChecker.checkWrite();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/jetbrains/cidr/xcode/RWASupport", "<init>"));
    }

    public static class SimpleChecker
    implements Checker {
        @Override
        public void checkRead() {
            if (!ourIsParsing.get().booleanValue() && !ApplicationManager.getApplication().isUnitTestMode()) {
                ThreadingAssertions.assertReadAccess();
            }
        }

        @Override
        public void checkWrite() {
            if (!ourIsParsing.get().booleanValue()) {
                ThreadingAssertions.assertWriteAccess();
            }
        }
    }

    public static interface Checker {
        public void checkRead();

        public void checkWrite();
    }

    public static class NullChecker
    implements Checker {
        @Override
        public void checkRead() {
        }

        @Override
        public void checkWrite() {
        }
    }
}

