/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.lpp.util;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.PathKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0004J\b\u0010\u0019\u001a\u00020\u0013H\u0004J\b\u0010\u001a\u001a\u00020\u0007H\u0004J\b\u0010\u001b\u001a\u00020\u0013H\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/lpp/util/PortRegistrar;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getServerPort", "", "registerPort", "", "port", "unregisterPort", "doCleanup", "fileContent", "", "Lcom/jetbrains/rider/lpp/util/PortRegistrar$FileEntry;", "readAndParseFile", "", "portsFile", "Ljava/nio/file/Path;", "createLockFile", "", "file", "shouldWait", "getPortsFilePath", "getLockFilePath", "getMyProcessId", "getPortsDirectory", "getRiderPids", "", "Companion", "FileEntry", "intellij.rider.plugins.livePlusPlus"})
@SourceDebugExtension(value={"SMAP\nPortRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortRegistrar.kt\ncom/jetbrains/rider/lpp/util/PortRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,143:1\n1563#2:144\n1634#2,3:145\n1563#2:148\n1634#2,3:149\n1563#2:152\n1634#2,3:153\n1222#2,2:159\n1252#2,4:161\n3919#3:156\n4434#3,2:157\n536#4:165\n521#4,6:166\n126#5:172\n153#5,3:173\n13#6:176\n*S KotlinDebug\n*F\n+ 1 PortRegistrar.kt\ncom/jetbrains/rider/lpp/util/PortRegistrar\n*L\n30#1:144\n30#1:145,3\n46#1:148\n46#1:149,3\n62#1:152\n62#1:153,3\n122#1:159,2\n122#1:161,4\n118#1:156\n118#1:157,2\n124#1:165\n124#1:166,6\n124#1:172\n124#1:173,3\n14#1:176\n*E\n"})
public class PortRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private static final Logger LOG;

    public PortRegistrar(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
    }

    public final int getServerPort() {
        return this.getMyProcessId() % 15000 + 50000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void registerPort(int port) {
        Path lockFile = this.getLockFilePath();
        boolean createLockResult = this.createLockFile(lockFile, true);
        LOG.assertTrue(createLockResult);
        try {
            void $this$mapTo$iv$iv;
            Path portsFile = this.getPortsFilePath();
            List fileContent = CollectionsKt.toMutableList((Collection)this.readAndParseFile(portsFile));
            this.doCleanup(fileContent);
            fileContent.add(new FileEntry(port, this.getMyProcessId()));
            Path path = lockFile;
            OpenOption[] $this$map$iv = (OpenOption[])fileContent;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileEntry fileEntry = (FileEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toStr());
            }
            Iterable iterable = (List)destination$iv$iv;
            objectArray = new OpenOption[]{};
            CopyOption[] copyOptionArray = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, (Charset)copyOptionArray, Arrays.copyOf(objectArray, objectArray.length)), (String)"write(...)");
            path = lockFile;
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            objectArray = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, portsFile, (CopyOption[])Arrays.copyOf(objectArray, objectArray.length)), (String)"move(...)");
        }
        finally {
            Files.deleteIfExists(lockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void unregisterPort(int port) {
        Path lockFile = this.getLockFilePath();
        boolean createLockResult = this.createLockFile(lockFile, false);
        if (createLockResult) {
            try {
                void $this$mapTo$iv$iv;
                Path portsFile = this.getPortsFilePath();
                List fileContent = CollectionsKt.toMutableList((Collection)this.readAndParseFile(portsFile));
                fileContent.removeIf(arg_0 -> PortRegistrar.unregisterPort$lambda$1(arg_0 -> PortRegistrar.unregisterPort$lambda$0(port, arg_0), arg_0));
                Path path = lockFile;
                OpenOption[] $this$map$iv = (OpenOption[])fileContent;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FileEntry fileEntry = (FileEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toStr());
                }
                Iterable iterable = (List)destination$iv$iv;
                objectArray = new OpenOption[]{};
                CopyOption[] copyOptionArray = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, (Charset)copyOptionArray, Arrays.copyOf(objectArray, objectArray.length)), (String)"write(...)");
                path = lockFile;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                objectArray = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, portsFile, (CopyOption[])Arrays.copyOf(objectArray, objectArray.length)), (String)"move(...)");
            }
            finally {
                Files.deleteIfExists(lockFile);
            }
        }
    }

    private final void doCleanup(List<FileEntry> fileContent) {
        Set<Integer> riderPids = this.getRiderPids();
        fileContent.removeIf(arg_0 -> PortRegistrar.doCleanup$lambda$1(arg_0 -> PortRegistrar.doCleanup$lambda$0(riderPids, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<FileEntry> readAndParseFile(@NotNull Path portsFile) {
        Intrinsics.checkNotNullParameter((Object)portsFile, (String)"portsFile");
        try {
            void $this$mapTo$iv$iv;
            Path path = portsFile;
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileEntry.Companion.parse((String)it));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to parse file: will ignore its content. " + e.getMessage());
            return CollectionsKt.emptyList();
        }
    }

    private final boolean createLockFile(Path file, boolean shouldWait) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.createParentDirectories((Path)file);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            return true;
        }
        if (!shouldWait) {
            return false;
        }
        ThreadingAssertions.assertBackgroundThread();
        for (int i = 1; i < 7; ++i) {
            Thread.sleep(50L);
            RLifetimeKt.throwIfNotAlive((Lifetime)this.lifetime);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            return true;
        }
        LOG.warn("Lock file still exists after 300ms. That should not happen. Deleting it.");
        Files.deleteIfExists(file);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        return true;
    }

    @NotNull
    protected final Path getPortsFilePath() {
        Path path = this.getPortsDirectory().resolve("ports.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    protected final Path getLockFilePath() {
        Path path = this.getPortsDirectory().resolve("ports.lock");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    protected final int getMyProcessId() {
        return OSProcessUtil.getCurrentProcessId();
    }

    @NotNull
    protected Path getPortsDirectory() {
        Path path;
        String homeDirectory = System.getProperty("user.home");
        if (SystemInfo.isWindows) {
            Path path2 = Paths.get(homeDirectory + "/AppData/Local/JetBrains/Rider/LivePP/", new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else if (SystemInfo.isMac) {
            Path path3 = Paths.get(homeDirectory + "/Library/Application Support/JetBrains/Rider/LivePP/", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else if (SystemInfo.isLinux) {
            Path path4 = Paths.get(homeDirectory + "/.config/JetBrains/Rider/LivePP/", new String[0]);
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<Integer> getRiderPids() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Object $this$filterTo$iv$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        ProcessInfo it2;
        void $this$filterTo$iv$iv2;
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Object $this$filter$iv = processInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getExecutableName(), (Object)"rider64.exe")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it2 = (ProcessInfo)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            it2 = (ProcessInfo)element$iv$iv;
            Integer n = it2.getPid();
            boolean bl2 = false;
            Integer n2 = it2.getParentPid();
            object.put(n, n2);
        }
        Map riderPidToPpid = destination$iv$iv2;
        $this$filter$iv = riderPidToPpid;
        $i$f$filter = false;
        Object capacity$iv22 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!riderPidToPpid.containsKey(it.getValue()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)it.getKey()).intValue());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final boolean unregisterPort$lambda$0(int $port, FileEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPort() == $port;
    }

    private static final boolean unregisterPort$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean doCleanup$lambda$0(Set $riderPids, FileEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$riderPids.contains(it.getPid());
    }

    private static final boolean doCleanup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PortRegistrar.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/lpp/util/PortRegistrar$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.livePlusPlus"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/lpp/util/PortRegistrar$FileEntry;", "", "port", "", "pid", "<init>", "(II)V", "getPort", "()I", "getPid", "toStr", "", "Companion", "intellij.rider.plugins.livePlusPlus"})
    protected static final class FileEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int port;
        private final int pid;

        public FileEntry(int port, int pid) {
            this.port = port;
            this.pid = pid;
        }

        public final int getPort() {
            return this.port;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final String toStr() {
            return this.port + " " + this.pid;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/lpp/util/PortRegistrar$FileEntry$Companion;", "", "<init>", "()V", "parse", "Lcom/jetbrains/rider/lpp/util/PortRegistrar$FileEntry;", "str", "", "intellij.rider.plugins.livePlusPlus"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FileEntry parse(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                char[] cArray = new char[]{' '};
                List parts = StringsKt.split$default((CharSequence)str, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (parts.size() != 2) {
                    throw new IllegalArgumentException("Invalid file format: '" + str + "'");
                }
                return new FileEntry(Integer.parseInt((String)parts.get(0)), Integer.parseInt((String)parts.get(1)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

