/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.lpp.msg;

import com.jetbrains.rider.lpp.msg.MessageType;
import com.jetbrains.rider.lpp.util.LivePPException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.ULong;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\t2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0014J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/lpp/msg/Message;", "", "messageType", "Lcom/jetbrains/rider/lpp/msg/MessageType;", "<init>", "(Lcom/jetbrains/rider/lpp/msg/MessageType;)V", "getMessageType", "()Lcom/jetbrains/rider/lpp/msg/MessageType;", "send", "", "writer", "Ljava/io/OutputStream;", "receive", "reader", "Ljava/io/InputStream;", "buildDebugString", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toDebugString", "", "Companion", "intellij.rider.plugins.livePlusPlus"})
public abstract class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageType messageType;

    public Message(@NotNull MessageType messageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)messageType), (String)"messageType");
        this.messageType = messageType;
    }

    @NotNull
    public final MessageType getMessageType() {
        return this.messageType;
    }

    public void send(@NotNull OutputStream writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Companion.sendInt16(writer, this.messageType.toInt16());
    }

    public void receive(@NotNull InputStream reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
    }

    protected void buildDebugString(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.append(this.messageType.name() + " {");
    }

    @NotNull
    public final String toDebugString() {
        StringBuilder builder = new StringBuilder();
        this.buildDebugString(builder);
        builder.append("}");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    public static final void sendBool(@NotNull OutputStream writer, boolean bool) {
        Companion.sendBool(writer, bool);
    }

    @JvmStatic
    public static final void sendInt16(@NotNull OutputStream writer, short int16) {
        Companion.sendInt16(writer, int16);
    }

    @JvmStatic
    public static final void sendInt32(@NotNull OutputStream writer, int int32) {
        Companion.sendInt32(writer, int32);
    }

    @JvmStatic
    public static final void sendInt64(@NotNull OutputStream writer, long int64) {
        Companion.sendInt64(writer, int64);
    }

    @JvmStatic
    public static final void sendUInt64-2TYgG_w(@NotNull OutputStream writer, long l) {
        Companion.sendUInt64-2TYgG_w(writer, l);
    }

    @JvmStatic
    public static final void sendArrayInt32(@NotNull OutputStream writer, @NotNull Integer[] array) {
        Companion.sendArrayInt32(writer, array);
    }

    @JvmStatic
    public static final void sendString(@NotNull OutputStream writer, @NotNull String string) {
        Companion.sendString(writer, string);
    }

    @JvmStatic
    public static final boolean receiveBool(@NotNull InputStream reader) {
        return Companion.receiveBool(reader);
    }

    @JvmStatic
    public static final byte receiveUInt8-Wa3L5BU(@NotNull InputStream reader) {
        return Companion.receiveUInt8-Wa3L5BU(reader);
    }

    @JvmStatic
    public static final short receiveInt16(@NotNull InputStream reader) {
        return Companion.receiveInt16(reader);
    }

    @JvmStatic
    public static final int receiveInt32(@NotNull InputStream reader) {
        return Companion.receiveInt32(reader);
    }

    @JvmStatic
    public static final long receiveInt64(@NotNull InputStream reader) {
        return Companion.receiveInt64(reader);
    }

    @JvmStatic
    public static final long receiveUInt64-I7RO_PI(@NotNull InputStream reader) {
        return Companion.receiveUInt64-I7RO_PI(reader);
    }

    @JvmStatic
    @NotNull
    public static final UByte[] receiveArrayUInt8(@NotNull InputStream reader) {
        return Companion.receiveArrayUInt8(reader);
    }

    @JvmStatic
    @NotNull
    public static final ULong[] receiveArrayUInt64(@NotNull InputStream reader) {
        return Companion.receiveArrayUInt64(reader);
    }

    @JvmStatic
    @NotNull
    public static final String receiveString(@NotNull InputStream reader) {
        return Companion.receiveString(reader);
    }

    @JvmStatic
    @NotNull
    public static final byte[] receiveNBytes(@NotNull InputStream reader, int n) {
        return Companion.receiveNBytes(reader, n);
    }

    @JvmStatic
    private static final int bitCastToInt(short $this$bitCastToInt) {
        return Message.Companion.bitCastToInt($this$bitCastToInt);
    }

    @JvmStatic
    private static final long bitCastToLong(int $this$bitCastToLong) {
        return Message.Companion.bitCastToLong($this$bitCastToLong);
    }

    @JvmStatic
    private static final long bitCastToULong-I7RO_PI(int $this$bitCastToULong_u2dI7RO_PI) {
        return Message.Companion.bitCastToULong-I7RO_PI($this$bitCastToULong_u2dI7RO_PI);
    }

    @JvmStatic
    private static final int bitCastToInt(long $this$bitCastToInt) {
        return Message.Companion.bitCastToInt($this$bitCastToInt);
    }

    @JvmStatic
    private static final int bitCastToInt-VKZWuLQ(long $this$bitCastToInt_u2dVKZWuLQ) {
        return Message.Companion.bitCastToInt-VKZWuLQ($this$bitCastToInt_u2dVKZWuLQ);
    }

    @JvmStatic
    private static final short bitCastToShort(int $this$bitCastToShort) {
        return Message.Companion.bitCastToShort($this$bitCastToShort);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001f\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0007J\u0017\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0007\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0007J\u0017\u0010)\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0007\u00a2\u0006\u0004\b*\u0010+J\u001b\u0010,\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\u0006\u0010 \u001a\u00020!H\u0007\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010 \u001a\u00020!H\u0007\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u00020\u000fH\u0007J\f\u00104\u001a\u00020\u000f*\u00020\fH\u0003J\f\u00105\u001a\u00020\u0012*\u00020\u000fH\u0003J\u0013\u00106\u001a\u00020\u0015*\u00020\u000fH\u0003\u00a2\u0006\u0004\b7\u00108J\f\u00104\u001a\u00020\u000f*\u00020\u0012H\u0003J\u0013\u00104\u001a\u00020\u000f*\u00020\u0015H\u0003\u00a2\u0006\u0004\b9\u0010:J\f\u0010;\u001a\u00020\f*\u00020\u000fH\u0003\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/lpp/msg/Message$Companion;", "", "<init>", "()V", "sendBool", "", "writer", "Ljava/io/OutputStream;", "bool", "", "sendInt16", "int16", "", "sendInt32", "int32", "", "sendInt64", "int64", "", "sendUInt64", "uint64", "Lkotlin/ULong;", "sendUInt64-2TYgG_w", "(Ljava/io/OutputStream;J)V", "sendArrayInt32", "array", "", "(Ljava/io/OutputStream;[Ljava/lang/Integer;)V", "sendString", "string", "", "receiveBool", "reader", "Ljava/io/InputStream;", "receiveUInt8", "Lkotlin/UByte;", "receiveUInt8-Wa3L5BU", "(Ljava/io/InputStream;)B", "receiveInt16", "receiveInt32", "receiveInt64", "receiveUInt64", "receiveUInt64-I7RO_PI", "(Ljava/io/InputStream;)J", "receiveArrayUInt8", "(Ljava/io/InputStream;)[Lkotlin/UByte;", "receiveArrayUInt64", "(Ljava/io/InputStream;)[Lkotlin/ULong;", "receiveString", "receiveNBytes", "", "n", "bitCastToInt", "bitCastToLong", "bitCastToULong", "bitCastToULong-I7RO_PI", "(I)J", "bitCastToInt-VKZWuLQ", "(J)I", "bitCastToShort", "intellij.rider.plugins.livePlusPlus"})
    @SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\ncom/jetbrains/rider/lpp/msg/Message$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,191:1\n13805#2,2:192\n*S KotlinDebug\n*F\n+ 1 Message.kt\ncom/jetbrains/rider/lpp/msg/Message$Companion\n*L\n69#1:192,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void sendBool(@NotNull OutputStream writer, boolean bool) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            int value = bool ? 1 : 0;
            writer.write(value);
        }

        @JvmStatic
        public final void sendInt16(@NotNull OutputStream writer, short int16) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            int value = this.bitCastToInt(int16);
            int byte1 = value >>> 0 & 0xFF;
            int byte2 = value >>> 8 & 0xFF;
            writer.write(byte1);
            writer.write(byte2);
        }

        @JvmStatic
        public final void sendInt32(@NotNull OutputStream writer, int int32) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            int short1 = int32 >>> 0 & 0xFFFF;
            int short2 = int32 >>> 16 & 0xFFFF;
            this.sendInt16(writer, this.bitCastToShort(short1));
            this.sendInt16(writer, this.bitCastToShort(short2));
        }

        @JvmStatic
        public final void sendInt64(@NotNull OutputStream writer, long int64) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            long int1 = int64 >>> 0 & 0xFFFFFFFFL;
            long int2 = int64 >>> 32 & 0xFFFFFFFFL;
            this.sendInt32(writer, this.bitCastToInt(int1));
            this.sendInt32(writer, this.bitCastToInt(int2));
        }

        @JvmStatic
        public final void sendUInt64-2TYgG_w(@NotNull OutputStream writer, long l) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            long int1 = ULong.constructor-impl((long)(ULong.constructor-impl((long)(l >>> 0)) & 0xFFFFFFFFL));
            long int2 = ULong.constructor-impl((long)(ULong.constructor-impl((long)(l >>> 32)) & 0xFFFFFFFFL));
            this.sendInt32(writer, this.bitCastToInt-VKZWuLQ(int1));
            this.sendInt32(writer, this.bitCastToInt-VKZWuLQ(int2));
        }

        @JvmStatic
        public final void sendArrayInt32(@NotNull OutputStream writer, @NotNull Integer[] array) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.sendInt16(writer, (short)array.length);
            Integer[] $this$forEach$iv = array;
            boolean $i$f$forEach = false;
            for (Integer element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                Companion.sendInt32(writer, it);
            }
        }

        @JvmStatic
        public final void sendString(@NotNull OutputStream writer, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byteArray = byArray;
            this.sendInt16(writer, (short)byteArray.length);
            writer.write(byteArray);
        }

        @JvmStatic
        public final boolean receiveBool(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int bool = reader.read();
            if (bool == -1) {
                throw new LivePPException("No data available");
            }
            return bool != 0;
        }

        @JvmStatic
        public final byte receiveUInt8-Wa3L5BU(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int n = reader.read();
            if (n == -1) {
                throw new LivePPException("No data available");
            }
            return UByte.constructor-impl((byte)((byte)n));
        }

        @JvmStatic
        public final short receiveInt16(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int byte1 = reader.read();
            int byte2 = reader.read();
            if (byte1 == -1 || byte2 == -1) {
                throw new LivePPException("No data available");
            }
            return this.bitCastToShort(byte2 << 8 | byte1 << 0);
        }

        @JvmStatic
        public final int receiveInt32(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int short1 = this.bitCastToInt(this.receiveInt16(reader));
            int short2 = this.bitCastToInt(this.receiveInt16(reader));
            return short2 << 16 | short1 << 0;
        }

        @JvmStatic
        public final long receiveInt64(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            long int1 = this.bitCastToLong(this.receiveInt32(reader));
            long int2 = this.bitCastToLong(this.receiveInt32(reader));
            return int2 << 32 | int1 << 0;
        }

        @JvmStatic
        public final long receiveUInt64-I7RO_PI(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            long int1 = this.bitCastToULong-I7RO_PI(this.receiveInt32(reader));
            long int2 = this.bitCastToULong-I7RO_PI(this.receiveInt32(reader));
            return ULong.constructor-impl((long)(ULong.constructor-impl((long)(int2 << 32)) | ULong.constructor-impl((long)(int1 << 0))));
        }

        @JvmStatic
        @NotNull
        public final UByte[] receiveArrayUInt8(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int len = this.receiveInt16(reader);
            int n = 0;
            UByte[] uByteArray = new UByte[len];
            while (n < len) {
                int n2 = n++;
                uByteArray[n2] = UByte.box-impl((byte)Companion.receiveUInt8-Wa3L5BU(reader));
            }
            return uByteArray;
        }

        @JvmStatic
        @NotNull
        public final ULong[] receiveArrayUInt64(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int len = this.receiveInt16(reader);
            int n = 0;
            ULong[] uLongArray = new ULong[len];
            while (n < len) {
                int n2 = n++;
                uLongArray[n2] = ULong.box-impl((long)Companion.receiveUInt64-I7RO_PI(reader));
            }
            return uLongArray;
        }

        @JvmStatic
        @NotNull
        public final String receiveString(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            short len = this.receiveInt16(reader);
            byte[] content = this.receiveNBytes(reader, len);
            return new String(content, Charsets.UTF_8);
        }

        @JvmStatic
        @NotNull
        public final byte[] receiveNBytes(@NotNull InputStream reader, int n) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            byte[] bytes = new byte[n];
            int result = reader.readNBytes(bytes, 0, n);
            if (result != n) {
                throw new LivePPException("Received only " + result + " bytes while expected " + n + " bytes");
            }
            return bytes;
        }

        @JvmStatic
        private final int bitCastToInt(short $this$bitCastToInt) {
            return $this$bitCastToInt & 0xFFFF;
        }

        @JvmStatic
        private final long bitCastToLong(int $this$bitCastToLong) {
            return (long)$this$bitCastToLong & 0xFFFFFFFFL;
        }

        @JvmStatic
        private final long bitCastToULong-I7RO_PI(int $this$bitCastToULong_u2dI7RO_PI) {
            return ULong.constructor-impl((long)this.bitCastToLong($this$bitCastToULong_u2dI7RO_PI));
        }

        @JvmStatic
        private final int bitCastToInt(long $this$bitCastToInt) {
            return (int)$this$bitCastToInt;
        }

        @JvmStatic
        private final int bitCastToInt-VKZWuLQ(long l) {
            return (int)l;
        }

        @JvmStatic
        private final short bitCastToShort(int $this$bitCastToShort) {
            return (short)$this$bitCastToShort;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

