/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.macos;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.xcode.Xcode;
import com.jetbrains.cidr.xcode.XcodeSettings;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.XamarinSettingsHostModel;
import com.jetbrains.rider.run.devices.ActiveDeviceManager;
import com.jetbrains.rider.utils.StringUtilKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/macos/XamarinSettingsHostModelListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rider/model/XamarinSettingsHostModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "updateXcodePathIfNeeded", "xcodeAppPath", "", "getXcodeDeveloperPath", "updateXcodeSettings", "xcodeDeveloperPath", "checkXcode", "Companion", "intellij.rider.macos"})
@SourceDebugExtension(value={"SMAP\nXamarinSettingsHostModelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XamarinSettingsHostModelListener.kt\ncom/jetbrains/rider/macos/XamarinSettingsHostModelListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n1869#2,2:79\n13#3:81\n13#4:82\n*S KotlinDebug\n*F\n+ 1 XamarinSettingsHostModelListener.kt\ncom/jetbrains/rider/macos/XamarinSettingsHostModelListener\n*L\n57#1:79,2\n23#1:81\n23#1:82\n*E\n"})
public final class XamarinSettingsHostModelListener
implements RootExtListener<XamarinSettingsHostModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull XamarinSettingsHostModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (!SystemInfo.isMac || session.isDisposed()) {
            return;
        }
        SourceExKt.adviseNotNull((ISource)((ISource)model.getXcodeCustomPath()), (Lifetime)lifetime, arg_0 -> XamarinSettingsHostModelListener.extensionCreated$lambda$0(this, session, arg_0));
    }

    private final void updateXcodePathIfNeeded(String xcodeAppPath, ClientAppSession session) {
        String currentXcodeAppPath = XcodeSettings.getInstance().getSelectedXcodeBasePath();
        if (Intrinsics.areEqual((Object)xcodeAppPath, (Object)currentXcodeAppPath)) {
            return;
        }
        String xcodeDeveloperPath = this.getXcodeDeveloperPath(xcodeAppPath);
        CharSequence charSequence = xcodeDeveloperPath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !Files.isDirectory(Paths.get(xcodeDeveloperPath, new String[0]), new LinkOption[0])) {
            return;
        }
        this.updateXcodeSettings(xcodeDeveloperPath, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getXcodeDeveloperPath(String xcodeAppPath) {
        if (xcodeAppPath == null) return null;
        String string = StringUtilKt.toUnixPath((String)xcodeAppPath);
        if (string == null) return null;
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (string2 == null) return null;
        char[] cArray = new char[]{'/'};
        String string3 = StringsKt.trimEnd((String)string2, (char[])cArray);
        if (string3 == null) return null;
        String string4 = string3 + "/Contents/Developer";
        return string4;
    }

    private final void updateXcodeSettings(String xcodeDeveloperPath, ClientAppSession session) {
        logger.info("Switch to Xcode at " + xcodeDeveloperPath);
        XcodeSettings.getInstance().setSelectedXcodeBasePath(xcodeDeveloperPath);
        Xcode.getInstance().updateInstallation();
        Iterable $this$forEach$iv = session.getProjectSessions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientProjectSession projectSession = (ClientProjectSession)element$iv;
            boolean bl = false;
            ActiveDeviceManager.Companion.getInstance(projectSession.getProject()).startRefreshingDevices();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> XamarinSettingsHostModelListener.updateXcodeSettings$lambda$1(this));
    }

    private final void checkXcode() {
        Xcode xcode = Xcode.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xcode, (String)"getInstance(...)");
        Xcode xcode2 = xcode;
        if (!xcode2.isInstalled()) {
            return;
        }
        String[] stringArray = new String[]{xcode2.getSimctlPath(), "list", "runtimes"};
        ProcessOutput runtimes = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray), (int)5000);
        if (runtimes.getExitCode() == 0) {
            logger.info("Xcode installed runtimes: " + runtimes.getStdout());
        }
    }

    private static final Unit extensionCreated$lambda$0(XamarinSettingsHostModelListener this$0, ClientAppSession $session, String xcodeAppPath) {
        Intrinsics.checkNotNullParameter((Object)xcodeAppPath, (String)"xcodeAppPath");
        this$0.updateXcodePathIfNeeded(xcodeAppPath, $session);
        return Unit.INSTANCE;
    }

    private static final void updateXcodeSettings$lambda$1(XamarinSettingsHostModelListener this$0) {
        this$0.checkXcode();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(XamarinSettingsHostModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        XamarinSettingsHostModelListener.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/macos/XamarinSettingsHostModelListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.macos"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

