/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.macos;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.xcode.Xcode;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.rider.macos.RiderPlistXcodeActionsKt;
import intellij.cidr.cocoaPlistEditor.plistEditor.PlistXcodeActions;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/macos/RiderPlistXcodeActions;", "Lintellij/cidr/cocoaPlistEditor/plistEditor/PlistXcodeActions;", "<init>", "()V", "getXcodeSchemeOfSchemesFile", "Ljava/io/File;", "isOpenFileInXcodeAvailable", "", "openFileInXcode", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.macos"})
public final class RiderPlistXcodeActions
extends PlistXcodeActions {
    @Nullable
    public File getXcodeSchemeOfSchemesFile() {
        if (OS.CURRENT != OS.macOS) {
            return null;
        }
        try {
            XcodeInstallation xcodeInstallation = Xcode.getInstance().getInstallation();
            Intrinsics.checkNotNullExpressionValue((Object)xcodeInstallation, (String)"getInstallation(...)");
            XcodeInstallation xcode = xcodeInstallation;
            File file = xcode.getSubFile("../PlugIns/DVTCorePlistStructDefs.dvtplugin/Contents/Resources/DVTCorePlistStructDefs.xcplugindata");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSubFile(...)");
            File keysFile = file;
            if (keysFile.exists() && keysFile.isFile()) {
                return keysFile;
            }
        }
        catch (Exception e) {
            RiderPlistXcodeActionsKt.access$getLogger$p().error((Throwable)e);
        }
        return null;
    }

    public boolean isOpenFileInXcodeAvailable() {
        return OS.CURRENT == OS.macOS;
    }

    public void openFileInXcode(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Xcode.getInstance().openFileInXcode(file.getPath());
    }
}

