/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.XcodeUtil;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class XcodeDiscoverer {
    public static XcodeDiscoverer getInstance() {
        return (XcodeDiscoverer)ApplicationManager.getApplication().getService(XcodeDiscoverer.class);
    }

    @NotNull
    public List<XcodeInstallation> discoverXcodeInstallations() {
        String xcodeSelectParentDir;
        Map added = FileCollectionFactory.createCanonicalFileMap();
        SmartList possibleInstallations = new SmartList();
        XcodeInstallation xcodeSelect = XcodeDiscoverer.addUniqueInstallation(XcodeUtil.getXcodeSelect(), (List<XcodeInstallation>)possibleInstallations, added);
        for (File each : XcodeDiscoverer.getXcodesAt("/Applications")) {
            XcodeDiscoverer.addUniqueInstallation(this.getXcodeAppBaseFile(each), (List<XcodeInstallation>)possibleInstallations, added);
        }
        if (xcodeSelect != null && !FileUtil.pathsEqual((String)(xcodeSelectParentDir = xcodeSelect.getApplicationFile().getParent()), (String)"/Applications")) {
            for (File file : XcodeDiscoverer.getXcodesAt(xcodeSelectParentDir)) {
                XcodeDiscoverer.addUniqueInstallation(this.getXcodeAppBaseFile(file), (List<XcodeInstallation>)possibleInstallations, added);
            }
        }
        ArrayList<XcodeInstallation> discoveredInstallations = new ArrayList<XcodeInstallation>(possibleInstallations.size());
        for (XcodeInstallation xcodeInstallation : possibleInstallations) {
            if (!xcodeInstallation.isInstalled()) continue;
            XCLog.LOG.info("Xcode found in '" + String.valueOf(xcodeInstallation) + "'");
            discoveredInstallations.add(xcodeInstallation);
        }
        if (discoveredInstallations.isEmpty()) {
            List<XcodeInstallation> list = Collections.singletonList(new XcodeInstallation(new File("/Applications/Xcode.app/Contents/Developer")));
            if (list == null) {
                XcodeDiscoverer.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<XcodeInstallation> list = Collections.unmodifiableList(discoveredInstallations);
        if (list == null) {
            XcodeDiscoverer.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public File getXcodeAppBaseFile(@NotNull File appPath) {
        if (appPath == null) {
            XcodeDiscoverer.$$$reportNull$$$0(2);
        }
        return new File(appPath, "/Contents/Developer");
    }

    @NotNull
    private static List<File> getXcodesAt(@NonNls String pathname) {
        Pattern pattern = Pattern.compile("xcode.*\\.app", 2);
        File[] result = new File(pathname).listFiles((dir, name) -> pattern.matcher(name).matches());
        List<Object> list = result == null ? Collections.emptyList() : Arrays.asList(result);
        if (list == null) {
            XcodeDiscoverer.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Contract(value="null,_,_-> null; !null,_,_-> !null")
    private static XcodeInstallation addUniqueInstallation(@Nullable File path, List<XcodeInstallation> possibleInstallations, Map<File, XcodeInstallation> added) {
        if (path == null) {
            return null;
        }
        XcodeInstallation result = added.get(path);
        if (result == null) {
            result = new XcodeInstallation(path);
            possibleInstallations.add(result);
            added.put(path, result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XcodeDiscoverer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverXcodeInstallations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XcodeDiscoverer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodesAt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getXcodeAppBaseFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

