/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.jetbrains.cidr.AppleScript;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.xcode.SwiftToolchain;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.XcodeProjectFileProvider;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xcode
extends XcodeBase {
    private final Supplier<SwiftToolchain> mySwiftToolchain = new SynchronizedClearableLazy(() -> Xcode.setupSwiftToolchain(this.getInstallation()));
    public static final String SWIFT_MODULE_CACHE_DONT_REQUIRE_DEFAULT_TOOLCHAIN = "swift.module.cache.dont.require.default.toolchain";

    @NotNull
    public static Xcode getInstance() {
        Xcode xcode = (Xcode)XcodeBase.getInstance();
        if (xcode == null) {
            Xcode.$$$reportNull$$$0(0);
        }
        return xcode;
    }

    @Nullable
    private static SwiftToolchain setupSwiftToolchain(@NotNull XcodeInstallation xcodeInstallation) {
        Application application;
        if (xcodeInstallation == null) {
            Xcode.$$$reportNull$$$0(1);
        }
        if (xcodeInstallation.isInstalled()) {
            SwiftToolchain toolchain = SwiftToolchain.getXcodeSelectedToolchain(xcodeInstallation);
            XCLog.LOG.info("Using swift toolchain at " + toolchain.getPath());
            return toolchain;
        }
        if (PluginUtils.hasAppCode() && (!(application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
            XCLog.LOG.warn("No swift toolchain selected");
        }
        return null;
    }

    @Nullable
    public String getToolchainBundleId() {
        return this.getSwiftToolchainField((Function<SwiftToolchain, String>)((Function)SwiftToolchain::getBundleId));
    }

    @Nullable
    public String getToolchainDisplayName() {
        return this.getSwiftToolchainField((Function<SwiftToolchain, String>)((Function)SwiftToolchain::getDisplayName));
    }

    @Nullable
    public String getSwiftToolchainPath() {
        return this.getSwiftToolchainField((Function<SwiftToolchain, String>)((Function)SwiftToolchain::getPath));
    }

    @Nullable
    private String getSwiftToolchainField(@NotNull Function<SwiftToolchain, String> toolchainFieldGetter) {
        SwiftToolchain toolchain;
        if (toolchainFieldGetter == null) {
            Xcode.$$$reportNull$$$0(2);
        }
        return (toolchain = this.getSwiftToolchain()) != null ? (String)toolchainFieldGetter.fun((Object)toolchain) : null;
    }

    @Nullable
    public SwiftToolchain getSwiftToolchain() {
        return this.mySwiftToolchain.get();
    }

    public boolean isUsingProperSwiftToolchain() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is((String)SWIFT_MODULE_CACHE_DONT_REQUIRE_DEFAULT_TOOLCHAIN) || this.isUsingDefaultSwiftToolchain();
    }

    public boolean isUsingDefaultSwiftToolchain() {
        SwiftToolchain toolchain = this.getSwiftToolchain();
        return toolchain != null && toolchain.isXcodeDefault();
    }

    public boolean openFileInXcodeWithProjectOpened(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            Xcode.$$$reportNull$$$0(3);
        }
        if (file == null) {
            Xcode.$$$reportNull$$$0(4);
        }
        XcodeProjectFileProvider provider = XcodeProjectFileProvider.getInstance(project);
        Supplier<Boolean> open = () -> {
            File xcodeProjFile = provider.findXcodeProjFile(project, file);
            if (xcodeProjFile == null) {
                return false;
            }
            return this.openFileWithinProjectInXcode(file.getPath(), xcodeProjFile);
        };
        if (provider.isImmediate()) {
            return open.get();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> (Boolean)open.get());
        return true;
    }

    public boolean openFileInXcode(@NotNull String path) {
        if (path == null) {
            Xcode.$$$reportNull$$$0(5);
        }
        return this.openFileWithinProjectInXcode(path, null);
    }

    public boolean openFileWithinProjectInXcode(@NotNull String filePathToOpen, @Nullable File projectFile) {
        if (filePathToOpen == null) {
            Xcode.$$$reportNull$$$0(6);
        }
        try {
            AppleScript.openFileInXcode(filePathToOpen, projectFile);
        }
        catch (IdeScriptException | IOException e) {
            XCLog.LOG.warn("Cannot open file in Xcode: " + e.getMessage());
            return false;
        }
        return true;
    }

    public void applySystemVersionCompat(GeneralCommandLine gcl) {
        if (SystemInfo.isMacOSBigSur) {
            String compatValue = this.getVersion().isOrGreaterThan(Integer.valueOf(12), Integer.valueOf(5)) ? "0" : "1";
            EnvironmentUtil.appendSearchPath((Map)gcl.getEnvironment(), (String)"SYSTEM_VERSION_COMPAT", (String)compatValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/Xcode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xcodeInstallation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainFieldGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathToOpen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/Xcode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupSwiftToolchain";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSwiftToolchainField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openFileInXcodeWithProjectOpened";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openFileInXcode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithinProjectInXcode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

