/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.apple.sdk.ObjCHelper;
import com.jetbrains.cidr.OCPathManager;
import com.jetbrains.cidr.xcode.BoolMapper;
import com.jetbrains.cidr.xcode.LongMapper;
import com.jetbrains.cidr.xcode.Mapper;
import com.jetbrains.cidr.xcode.ObjMapper1;
import com.jetbrains.cidr.xcode.ObjMapper2;
import com.jetbrains.cidr.xcode.ObjMapper3;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XPCServiceConnection;
import com.jetbrains.cidr.xcode.XPCServiceConnectionDelegate;
import com.jetbrains.cidr.xcode.XPCServiceConnectionError;
import com.jetbrains.cidr.xcode.XPCServiceConnectionKt;
import com.jetbrains.cidr.xcode.Xcode;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.plist.XMLPlistDriver;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001PB7\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020\nH\u0002J\b\u0010+\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020\u0007H\u0002J\b\u0010-\u001a\u00020\nH\u0002J\u0010\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u000eH\u0002J\u0010\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\u000eH\u0002J$\u00102\u001a\u00020\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000304H\u0002J0\u00106\u001a\u00020\u00152\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\u000e\b\u0002\u00105\u001a\b\u0012\u0004\u0012\u00020\u0003042\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u0003J\u000e\u00108\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0003H\u0002J\u001c\u0010<\u001a\u00020\u0015\"\u0004\b\u0000\u0010=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H=0\tH\u0002J6\u0010?\u001a\u0002H=\"\u0004\b\u0000\u0010=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\u00170@2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H=0CH\u0086@\u00a2\u0006\u0002\u0010DJB\u0010?\u001a\u0002H=\"\u0004\b\u0000\u0010=2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H=0C2\b\b\u0001\u0010E\u001a\u00020\u00032\u0014\u0010F\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010G0\tH\u0086@\u00a2\u0006\u0002\u0010HJ,\u0010I\u001a\u00020\u00172\b\b\u0001\u0010E\u001a\u00020\u00032\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010G\"\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010JJ)\u0010K\u001a\u00020\u00172\b\b\u0001\u0010E\u001a\u00020\u00032\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010G\"\u00020\u0001\u00a2\u0006\u0002\u0010LJ\u0006\u0010M\u001a\u00020\u0015J\u001c\u0010N\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00030\u00122\b\b\u0001\u0010O\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00038\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010 \u001aB\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"\u0012\f\u0012\n #*\u0004\u0018\u00010\n0\n #* \u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"\u0012\f\u0012\n #*\u0004\u0018\u00010\n0\n\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&\u00a8\u0006Q"}, d2={"Lcom/jetbrains/cidr/xcode/XPCServiceConnection;", "", "servicePath", "", "delegate", "Lcom/jetbrains/cidr/xcode/XPCServiceConnectionDelegate;", "restartLimit", "", "enableTracing", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Lcom/jetbrains/cidr/xcode/XPCServiceConnectionDelegate;ILkotlin/jvm/functions/Function0;)V", "BRIDGE_SERVICE_PLIST_FILE", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "BRIDGE_SERVICE_LABEL", "traceLogger", "Ljava/util/Queue;", "connectLatch", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "connection", "Lcom/intellij/ui/mac/foundation/ID;", "value", "service", "getService", "()Lcom/intellij/ui/mac/foundation/ID;", "serviceProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "serviceTerminationCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "callbackHolder", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/sun/jna/Callback;", "kotlin.jvm.PlatformType", "currentServiceFile", "getCurrentServiceFile", "()Ljava/io/File;", "currentServiceFile$delegate", "Lkotlin/Lazy;", "bridgeServiceInstalled", "ensureBridgeServiceInstalledAndEnabled", "enableBridgeService", "disableBridgeService", "isBridgeServiceEnabled", "ensureServiceExecutable", "serviceFile", "ensureBridgeServicePListIsWriteable", "plistFile", "launchService", "extraSearchPaths", "", "extraArguments", "establishConnection", "uuidOverride", "awaitForConnection", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connect", "uuid", "withPool", "T", "function", "getValue", "Lkotlin/Function1;", "Lcom/sun/jna/Pointer;", "mapper", "Lcom/jetbrains/cidr/xcode/Mapper;", "(Lkotlin/jvm/functions/Function1;Lcom/jetbrains/cidr/xcode/Mapper;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selector", "args", "", "(Lcom/jetbrains/cidr/xcode/Mapper;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitForConnectionAndInvokeService", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeServiceWithAvailableConnection", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/intellij/ui/mac/foundation/ID;", "dumpTraceLogs", "log", "e", "UnavailableException", "intellij.cidr.cocoaCommon"})
@SourceDebugExtension(value={"SMAP\nXPCServiceConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XPCServiceConnection.kt\ncom/jetbrains/cidr/xcode/XPCServiceConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n1#2:432\n1869#3,2:433\n*S KotlinDebug\n*F\n+ 1 XPCServiceConnection.kt\ncom/jetbrains/cidr/xcode/XPCServiceConnection\n*L\n180#1:433,2\n*E\n"})
public final class XPCServiceConnection {
    @NotNull
    private final String servicePath;
    @NotNull
    private final XPCServiceConnectionDelegate delegate;
    private final int restartLimit;
    @Nullable
    private final Function0<Boolean> enableTracing;
    @NotNull
    private final File BRIDGE_SERVICE_PLIST_FILE;
    @NonNls
    @NotNull
    private final String BRIDGE_SERVICE_LABEL;
    @NotNull
    private final Queue<String> traceLogger;
    @Nullable
    private volatile MutableSharedFlow<Unit> connectLatch;
    @Nullable
    private ID connection;
    @Nullable
    private ID service;
    @Nullable
    private ProcessHandler serviceProcessHandler;
    @NotNull
    private final AtomicInteger serviceTerminationCount;
    private final ConcurrentHashMap.KeySetView<Callback, Boolean> callbackHolder;
    @NotNull
    private final Lazy currentServiceFile$delegate;

    @JvmOverloads
    public XPCServiceConnection(@NonNls @NotNull String servicePath, @NotNull XPCServiceConnectionDelegate delegate, int restartLimit, @Nullable Function0<Boolean> enableTracing) {
        Queue queue;
        Intrinsics.checkNotNullParameter((Object)servicePath, (String)"servicePath");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.servicePath = servicePath;
        this.delegate = delegate;
        this.restartLimit = restartLimit;
        this.enableTracing = enableTracing;
        File file = OCPathManager.getUserLibrarySubFile((String)"LaunchAgents/com.jetbrains.AppCode.BridgeService.plist");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getUserLibrarySubFile(...)");
        this.BRIDGE_SERVICE_PLIST_FILE = file;
        this.BRIDGE_SERVICE_LABEL = "com.jetbrains.AppCode.BridgeService";
        if (this.enableTracing == null) {
            queue = new ArrayDeque(0);
        } else {
            Queue queue2 = Queues.synchronizedQueue((Queue)((Queue)EvictingQueue.create((int)500)));
            queue = queue2;
            Intrinsics.checkNotNullExpressionValue((Object)queue2, (String)"synchronizedQueue(...)");
        }
        this.traceLogger = queue;
        this.serviceTerminationCount = new AtomicInteger();
        this.callbackHolder = ConcurrentHashMap.newKeySet();
        this.currentServiceFile$delegate = LazyKt.lazy(() -> XPCServiceConnection.currentServiceFile_delegate$lambda$0(this));
    }

    public /* synthetic */ XPCServiceConnection(String string, XPCServiceConnectionDelegate xPCServiceConnectionDelegate, int n, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            function0 = null;
        }
        this(string, xPCServiceConnectionDelegate, n, (Function0<Boolean>)function0);
    }

    @Nullable
    public final ID getService() {
        return this.service;
    }

    private final File getCurrentServiceFile() {
        Lazy lazy = this.currentServiceFile$delegate;
        return (File)lazy.getValue();
    }

    private final boolean bridgeServiceInstalled() {
        String servicePath;
        if (this.BRIDGE_SERVICE_PLIST_FILE.exists() && !this.BRIDGE_SERVICE_PLIST_FILE.canRead()) {
            this.BRIDGE_SERVICE_PLIST_FILE.setReadable(true, false);
        }
        Plist plist = PlistDriver.readAnyFormatSafe((File)this.BRIDGE_SERVICE_PLIST_FILE);
        String string = servicePath = plist != null ? plist.getString("Program") : null;
        if (servicePath != null) {
            return new File(servicePath).canExecute();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean ensureBridgeServiceInstalledAndEnabled() {
        if (!this.bridgeServiceInstalled()) {
            void $this$ensureBridgeServiceInstalledAndEnabled_u24lambda_u240;
            Plist plist;
            File file = OCPathManager.getBinFile("Bridge.framework/Versions/A/Resources/BridgeService");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBinFile(...)");
            File bridgeServiceFile = file;
            if (!this.ensureServiceExecutable(bridgeServiceFile)) {
                return false;
            }
            Plist plist2 = new Plist();
            plist2.setAttribute("Label", (Object)this.BRIDGE_SERVICE_LABEL);
            Plist plist3 = plist = new Plist();
            String string = "MachServices";
            Plist plist4 = plist2;
            boolean bl = false;
            $this$ensureBridgeServiceInstalledAndEnabled_u24lambda_u240.put("com.jetbrains.AppCode.BridgeService", (Object)true);
            Unit unit = Unit.INSTANCE;
            plist4.setAttribute(string, (Object)plist);
            plist2.setAttribute("Program", (Object)bridgeServiceFile.getAbsolutePath());
            plist2.setAttribute("RunAtLoad", (Object)false);
            this.withPool(() -> XPCServiceConnection.ensureBridgeServiceInstalledAndEnabled$lambda$1(plist2));
            try {
                if (!this.ensureBridgeServicePListIsWriteable(this.BRIDGE_SERVICE_PLIST_FILE)) {
                    return false;
                }
                new XMLPlistDriver().write(plist2, this.BRIDGE_SERVICE_PLIST_FILE);
            }
            catch (IOException e) {
                XCLog.LOG.warn((Throwable)e);
                this.delegate.onError(XPCServiceConnectionError.BRIDGE_SERVICE_PLIST_FILE_ERROR);
                return false;
            }
            this.disableBridgeService();
        }
        if (!this.isBridgeServiceEnabled()) {
            this.enableBridgeService();
            if (!this.isBridgeServiceEnabled()) {
                XCLog.LOG.warn("Unable to load plist file to enable the bridge service: " + this.BRIDGE_SERVICE_PLIST_FILE);
                this.delegate.onError(XPCServiceConnectionError.BRIDGE_SERVICE_PLIST_FILE_ERROR);
                return false;
            }
        }
        return true;
    }

    private final int enableBridgeService() {
        String[] stringArray = new String[]{"launchctl", "load", this.BRIDGE_SERVICE_PLIST_FILE.getAbsolutePath()};
        return new GeneralCommandLine(stringArray).createProcess().waitFor();
    }

    private final int disableBridgeService() {
        String[] stringArray = new String[]{"launchctl", "unload", this.BRIDGE_SERVICE_PLIST_FILE.getAbsolutePath()};
        return new GeneralCommandLine(stringArray).createProcess().waitFor();
    }

    private final boolean isBridgeServiceEnabled() {
        String[] stringArray = new String[]{"launchctl", "list", this.BRIDGE_SERVICE_LABEL};
        return new GeneralCommandLine(stringArray).createProcess().waitFor() == 0;
    }

    private final boolean ensureServiceExecutable(File serviceFile) {
        if (!serviceFile.exists()) {
            XCLog.LOG.warn("The service file does not exist: " + serviceFile);
            return false;
        }
        if (!serviceFile.canExecute() && !serviceFile.setExecutable(true, false)) {
            XCLog.LOG.warn("Failed to set executable bit for " + serviceFile);
            return false;
        }
        return true;
    }

    private final boolean ensureBridgeServicePListIsWriteable(File plistFile) {
        if (plistFile.exists()) {
            if (!plistFile.canWrite() && !plistFile.setWritable(true, true)) {
                XCLog.LOG.warn("Unable to set the plist file for Bridge service writeable: " + plistFile);
                this.delegate.onError(XPCServiceConnectionError.BRIDGE_SERVICE_PLIST_FILE_ERROR);
                return false;
            }
        } else {
            File plistFolder = plistFile.getParentFile();
            if (plistFolder.exists() && !plistFolder.canWrite() && !plistFolder.setWritable(true, false)) {
                XCLog.LOG.warn("Unable to set the folder (" + plistFolder + ") for launch agents writeable to write new plist file for Bridge service");
                this.delegate.onError(XPCServiceConnectionError.BRIDGE_SERVICE_PLIST_FILE_ERROR);
                return false;
            }
        }
        return true;
    }

    private final String launchService(List<String> extraSearchPaths, List<String> extraArguments) {
        String uuid;
        block2: {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            uuid = string;
            String[] stringArray = new String[]{OCPathManager.getBinFile(this.servicePath).getAbsolutePath(), uuid};
            GeneralCommandLine cl = new GeneralCommandLine(stringArray);
            cl.addParameters(extraArguments);
            Xcode xcode = Xcode.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)xcode), (String)"getInstance(...)");
            Xcode xcode2 = xcode;
            EnvironmentUtil.appendSearchPath((Map)cl.getEnvironment(), (String)"DYLD_FRAMEWORK_PATH", (String)xcode2.getApplicationContentsSubFilePath("SharedFrameworks"));
            Iterable $this$forEach$iv = extraSearchPaths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                EnvironmentUtil.appendSearchPath((Map)cl.getEnvironment(), (String)"DYLD_FRAMEWORK_PATH", (String)it);
            }
            xcode2.applySystemVersionCompat(cl);
            ProcessHandler processHandler = this.serviceProcessHandler = (ProcessHandler)new OSProcessHandler.Silent(cl);
            if (processHandler != null) {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(this, extraSearchPaths, extraArguments){
                    final /* synthetic */ XPCServiceConnection this$0;
                    final /* synthetic */ List<String> $extraSearchPaths;
                    final /* synthetic */ List<String> $extraArguments;
                    {
                        this.this$0 = $receiver;
                        this.$extraSearchPaths = $extraSearchPaths;
                        this.$extraArguments = $extraArguments;
                    }

                    public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        if (ProcessOutputType.isStdout(outputType)) {
                            String string = event.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            XCLog.LOG.debug(((Object)StringsKt.trim((CharSequence)string)).toString());
                        } else if (ProcessOutputType.isStderr(outputType)) {
                            String string = event.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            XCLog.LOG.info(((Object)StringsKt.trim((CharSequence)string)).toString());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        ID[] iDArray = new ID[]{this.this$0.getService()};
                        Foundation.cfRelease((ID[])iDArray);
                        XPCServiceConnection.access$setService$p(this.this$0, null);
                        Foundation.invoke((ID)XPCServiceConnection.access$getConnection$p(this.this$0), (String)"invalidate", (Object[])new Object[0]);
                        iDArray = new ID[]{XPCServiceConnection.access$getConnection$p(this.this$0)};
                        Foundation.cfRelease((ID[])iDArray);
                        XPCServiceConnection.access$setConnection$p(this.this$0, null);
                        XPCServiceConnection.access$getDelegate$p(this.this$0).onDisconnect();
                        XPCServiceConnection.access$setServiceProcessHandler$p(this.this$0, null);
                        XPCServiceConnection.access$setConnectLatch$p(this.this$0, null);
                        if (ApplicationManager.getApplication().isUnitTestMode() || XPCServiceConnection.access$getRestartLimit$p(this.this$0) == 0 || XPCServiceConnection.access$getServiceTerminationCount$p(this.this$0).incrementAndGet() < XPCServiceConnection.access$getRestartLimit$p(this.this$0)) {
                            XPCServiceConnection.establishConnection$default(this.this$0, this.$extraSearchPaths, this.$extraArguments, null, 4, null);
                        }
                    }
                });
            }
            ProcessHandler processHandler2 = this.serviceProcessHandler;
            if (processHandler2 == null) break block2;
            processHandler2.startNotify();
        }
        return uuid;
    }

    public final void establishConnection(@NotNull List<String> extraSearchPaths, @NotNull List<String> extraArguments, @Nullable String uuidOverride) {
        MutableSharedFlow latch;
        Intrinsics.checkNotNullParameter(extraSearchPaths, (String)"extraSearchPaths");
        Intrinsics.checkNotNullParameter(extraArguments, (String)"extraArguments");
        this.connectLatch = latch = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> XPCServiceConnection.establishConnection$lambda$0(this, uuidOverride, extraSearchPaths, extraArguments, latch));
    }

    public static /* synthetic */ void establishConnection$default(XPCServiceConnection xPCServiceConnection, List list, List list2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            string = null;
        }
        xPCServiceConnection.establishConnection(list, list2, string);
    }

    /*
     * Unable to fully structure code
     */
    private final Object awaitForConnection(Continuation<? super Unit> $completion) throws UnavailableException {
        if (!($completion instanceof awaitForConnection.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ XPCServiceConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return XPCServiceConnection.access$awaitForConnection(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.connectLatch;
                if (v0 == null) {
                    throw new UnavailableException("Cannot await the connection as not started establishing it");
                }
                latch = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(latch);
                $continuation.label = 1;
                v1 = TimeoutKt.withTimeout-KLykuaI((long)XPCServiceConnectionKt.access$getESTABLISH_CONNECTION_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(latch, null){
                    int label;
                    final /* synthetic */ MutableSharedFlow<Unit> $latch;
                    {
                        this.$latch = $latch;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = FlowKt.first((Flow)((Flow)this.$latch), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var6_4) goto lbl23
lbl22:
                // 1 sources

                return var6_4;
lbl23:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                latch = (MutableSharedFlow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (TimeoutCancellationException <unused var>) {
                    throw new UnavailableException("Failed waiting too long for the connection to be established");
                }
lbl33:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean connect(String uuid) {
        ID bridge = Foundation.invoke((String)"BridgeClient", (String)"new", (Object[])new Object[0]);
        Object[] objectArray = new Object[]{Foundation.nsString((String)uuid)};
        ID iD = Foundation.invoke((ID)bridge, (String)"retrieveEndpointForKey:", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"invoke(...)");
        ID endpoint = iD;
        Foundation.invoke((ID)bridge, (String)"release", (Object[])new Object[0]);
        if (Intrinsics.areEqual((Object)endpoint, (Object)ID.NIL)) {
            XCLog.LOG.warn("Could not retrieve service endpoint for " + this.servicePath);
            ProcessHandler processHandler = this.serviceProcessHandler;
            if (processHandler != null) {
                processHandler.destroyProcess();
            }
            return false;
        }
        Object[] objectArray2 = new Object[]{endpoint};
        this.connection = Foundation.invoke((ID)Foundation.invoke((String)"NSXPCConnection", (String)"alloc", (Object[])new Object[0]), (String)"initWithListenerEndpoint:", (Object[])objectArray2);
        objectArray2 = new Object[]{this.delegate.getRemoteObjectInterface()};
        Foundation.invoke((ID)this.connection, (String)"setRemoteObjectInterface:", (Object[])objectArray2);
        Foundation.invoke((ID)this.connection, (String)"resume", (Object[])new Object[0]);
        ObjCHelper.MyCallback invalidationHandler = arg_0 -> XPCServiceConnection.connect$lambda$0(this, arg_0);
        this.callbackHolder.add((Callback)invalidationHandler);
        ObjCHelper.performWithCallback((long)ObjCHelper.getNextCallbackID(), (Callback)((Callback)invalidationHandler), arg_0 -> XPCServiceConnection.connect$lambda$1(this, arg_0));
        this.service = Foundation.invoke((ID)this.connection, (String)"remoteObjectProxy", (Object[])new Object[0]);
        Foundation.cfRetain((ID)this.service);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void withPool(Function0<? extends T> function) {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            function.invoke();
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object getValue(@NotNull Function1<? super Pointer, ID> function, @NotNull Mapper<T> mapper, @NotNull Continuation<? super T> $completion) throws UnavailableException {
        if (!($completion instanceof getValue.1)) ** GOTO lbl-1000
        var12_4 = $completion;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ XPCServiceConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getValue(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = function;
                $continuation.L$1 = mapper;
                $continuation.label = 1;
                v0 = this.awaitForConnection((Continuation<? super Unit>)$continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                mapper = (Mapper)$continuation.L$1;
                function = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                result = new CompletableFuture<T>();
                callback = Intrinsics.areEqual(mapper.getClass(), BoolMapper.class) != false ? (Callback)(ObjCHelper.MyBoolCallback)LambdaMetafactory.metafactory(null, null, null, (Z)V, getValue$lambda$0(java.util.concurrent.CompletableFuture boolean ), (Z)V)(result) : (Intrinsics.areEqual(mapper.getClass(), LongMapper.class) != false ? (Callback)(ObjCHelper.MyLongCallback)LambdaMetafactory.metafactory(null, null, null, (J)V, getValue$lambda$1(java.util.concurrent.CompletableFuture long ), (J)V)(result) : (ObjMapper1.class.isAssignableFrom(mapper.getClass()) != false ? (Callback)(ObjCHelper.MyIDCallback)LambdaMetafactory.metafactory(null, null, null, (Lcom/intellij/ui/mac/foundation/ID;)V, getValue$lambda$2(com.jetbrains.cidr.xcode.XPCServiceConnection java.util.concurrent.CompletableFuture com.jetbrains.cidr.xcode.Mapper com.intellij.ui.mac.foundation.ID ), (Lcom/intellij/ui/mac/foundation/ID;)V)((XPCServiceConnection)this, result, (Mapper)mapper) : (ObjMapper2.class.isAssignableFrom(mapper.getClass()) != false ? (Callback)(ObjCHelper.MyIDCallback2)LambdaMetafactory.metafactory(null, null, null, (Lcom/intellij/ui/mac/foundation/ID;Lcom/intellij/ui/mac/foundation/ID;)V, getValue$lambda$3(com.jetbrains.cidr.xcode.XPCServiceConnection java.util.concurrent.CompletableFuture com.jetbrains.cidr.xcode.Mapper com.intellij.ui.mac.foundation.ID com.intellij.ui.mac.foundation.ID ), (Lcom/intellij/ui/mac/foundation/ID;Lcom/intellij/ui/mac/foundation/ID;)V)((XPCServiceConnection)this, result, (Mapper)mapper) : (ObjMapper3.class.isAssignableFrom(mapper.getClass()) != false ? (Callback)(ObjCHelper.MyIDCallback3)LambdaMetafactory.metafactory(null, null, null, (Lcom/intellij/ui/mac/foundation/ID;Lcom/intellij/ui/mac/foundation/ID;Lcom/intellij/ui/mac/foundation/ID;)V, getValue$lambda$4(com.jetbrains.cidr.xcode.XPCServiceConnection java.util.concurrent.CompletableFuture com.jetbrains.cidr.xcode.Mapper com.intellij.ui.mac.foundation.ID com.intellij.ui.mac.foundation.ID com.intellij.ui.mac.foundation.ID ), (Lcom/intellij/ui/mac/foundation/ID;Lcom/intellij/ui/mac/foundation/ID;Lcom/intellij/ui/mac/foundation/ID;)V)((XPCServiceConnection)this, result, (Mapper)mapper) : null))));
                XCLog.LOG.assertTrue(callback != null);
                v1 = callback;
                Intrinsics.checkNotNull((Object)v1);
                this.callbackHolder.add(v1);
                id = ObjCHelper.getNextCallbackID();
                pool = new Foundation.NSAutoreleasePool();
                try {
                    (ID)ObjCHelper.performWithCallback((long)id, (Callback)callback, (Function<Pointer, ID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue$lambda$5(kotlin.jvm.functions.Function1 com.sun.jna.Pointer ), (Lcom/sun/jna/Pointer;)Lcom/intellij/ui/mac/foundation/ID;)((Function1)function));
                }
                finally {
                    pool.drain();
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)function);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)mapper);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(result);
                $continuation.L$3 = callback;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)pool);
                $continuation.J$0 = id;
                $continuation.label = 2;
                v2 = FutureKt.await((CompletionStage)result, $continuation);
                ** if (v2 != var13_6) goto lbl55
lbl54:
                // 1 sources

                return var13_6;
lbl55:
                // 1 sources

                ** GOTO lbl67
            }
            case 2: {
                id = $continuation.J$0;
                pool = (Foundation.NSAutoreleasePool)$continuation.L$4;
                callback = (Callback)$continuation.L$3;
                result = (CompletableFuture<T>)$continuation.L$2;
                mapper = (Mapper)$continuation.L$1;
                function = (Function1)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl67:
                    // 2 sources

                    resultValue = v2;
                    this.log(this.traceLogger, "Result: " + resultValue);
                    var10_12 = resultValue;
                    return var10_12;
                }
                catch (CancellationException e) {
                    ObjCHelper.cancel_callback((long)id);
                    throw e;
                }
            }
            catch (Throwable var9_15) {
                throw var9_15;
            }
            {
                finally {
                    this.callbackHolder.remove(callback);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final <T> Object getValue(@NotNull Mapper<T> mapper, @NonNls @NotNull String selector, @NotNull Function0<? extends Object[]> args, @NotNull Continuation<? super T> $completion) throws UnavailableException {
        return this.getValue((Function1<? super Pointer, ID>)((Function1)arg_0 -> XPCServiceConnection.getValue$lambda$6(this, selector, args, arg_0)), mapper, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object awaitForConnectionAndInvokeService(@NonNls @NotNull String selector, @NotNull Object[] args, @NotNull Continuation<? super ID> $completion) throws UnavailableException {
        if (!($completion instanceof awaitForConnectionAndInvokeService.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ XPCServiceConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitForConnectionAndInvokeService(null, null, (Continuation<? super ID>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = selector;
                $continuation.L$1 = args;
                $continuation.label = 1;
                v0 = this.awaitForConnection((Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                args = (Object[])$continuation.L$1;
                selector = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                return this.invokeServiceWithAvailableConnection(selector, Arrays.copyOf(args, args.length));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final ID invokeServiceWithAvailableConnection(@NonNls @NotNull String selector, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ID service = this.service;
        XCLog.LOG.assertTrue(service != null, (Object)"Attempted to use an uninitialized connection");
        this.log(this.traceLogger, "Invoking selector: " + selector);
        Function0<Boolean> function0 = this.enableTracing;
        boolean bl = function0 != null ? ((Boolean)function0.invoke()).booleanValue() : false;
        if (bl) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                Object arg = args[i];
                Object argDesc = arg instanceof ID ? Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)((ID)arg), (String)"description", (Object[])new Object[0])) : arg;
                this.log(this.traceLogger, "\t- " + argDesc);
            }
        }
        ID iD = Foundation.invoke((ID)service, (String)selector, (Object[])Arrays.copyOf(args, args.length));
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"invoke(...)");
        return iD;
    }

    public final void dumpTraceLogs() {
        if (!((Collection)this.traceLogger).isEmpty()) {
            XCLog.LOG.info("Collected tracing:\n" + CollectionsKt.joinToString$default((Iterable)this.traceLogger, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            this.traceLogger.clear();
        }
    }

    private final void log(Queue<String> $this$log, @NonNls String e) {
        Function0<Boolean> function0 = this.enableTracing;
        if (!(function0 != null ? ((Boolean)function0.invoke()).booleanValue() : false)) {
            return;
        }
        $this$log.add(System.currentTimeMillis() + " " + e);
    }

    @JvmOverloads
    public XPCServiceConnection(@NonNls @NotNull String servicePath, @NotNull XPCServiceConnectionDelegate delegate, int restartLimit) {
        Intrinsics.checkNotNullParameter((Object)servicePath, (String)"servicePath");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this(servicePath, delegate, restartLimit, null, 8, null);
    }

    @JvmOverloads
    public XPCServiceConnection(@NonNls @NotNull String servicePath, @NotNull XPCServiceConnectionDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)servicePath, (String)"servicePath");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this(servicePath, delegate, 0, null, 12, null);
    }

    private static final File currentServiceFile_delegate$lambda$0(XPCServiceConnection this$0) {
        return OCPathManager.getBinFile(this$0.servicePath);
    }

    private static final Unit ensureBridgeServiceInstalledAndEnabled$lambda$1(Plist $plist) {
        String bundleIdentifier = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]), (String)"bundleIdentifier", (Object[])new Object[0]));
        if (bundleIdentifier != null && !StringsKt.startsWith$default((String)bundleIdentifier, (String)"com.jetbrains.jbr", (boolean)false, (int)2, null) && PlatformUtils.isJetBrainsProduct()) {
            $plist.setAttribute("AssociatedBundleIdentifiers", (Object)CollectionsKt.listOf((Object)bundleIdentifier));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void establishConnection$lambda$0(XPCServiceConnection this$0, String $uuidOverride, List $extraSearchPaths, List $extraArguments, MutableSharedFlow $latch) {
        Class<XPCServiceConnection> clazz = XPCServiceConnection.class;
        synchronized (clazz) {
            boolean bl = false;
            if (this$0.ensureBridgeServiceInstalledAndEnabled() && this$0.ensureServiceExecutable(this$0.getCurrentServiceFile())) {
                String uuid;
                boolean success;
                String string = $uuidOverride;
                if (string == null) {
                    string = this$0.launchService($extraSearchPaths, $extraArguments);
                }
                if (success = this$0.connect(uuid = string)) {
                    $latch.tryEmit((Object)Unit.INSTANCE);
                }
                this$0.delegate.afterConnectAttempt(success);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void connect$lambda$0(XPCServiceConnection this$0, Pointer it) {
        block0: {
            XCLog.LOG.warn(this$0.servicePath + " XPC connection invalidated");
            ProcessHandler processHandler = this$0.serviceProcessHandler;
            if (processHandler == null) break block0;
            processHandler.destroyProcess();
        }
    }

    private static final ID connect$lambda$1(XPCServiceConnection this$0, Pointer it) {
        Object[] objectArray = new Object[]{it};
        return Foundation.invoke((ID)this$0.connection, (String)"setInvalidationHandler:", (Object[])objectArray);
    }

    private static final void getValue$lambda$0(CompletableFuture $result, boolean it) {
        $result.complete(it);
    }

    private static final void getValue$lambda$1(CompletableFuture $result, long it) {
        $result.complete(it);
    }

    private static final void getValue$lambda$2(XPCServiceConnection this$0, CompletableFuture $result, Mapper $mapper, ID arg0) {
        this$0.withPool(() -> XPCServiceConnection.getValue$lambda$2$0($result, $mapper, arg0));
    }

    private static final boolean getValue$lambda$2$0(CompletableFuture $result, Mapper $mapper, ID $arg0) {
        Intrinsics.checkNotNull((Object)$mapper, (String)"null cannot be cast to non-null type com.jetbrains.cidr.xcode.ObjMapper1<T of com.jetbrains.cidr.xcode.XPCServiceConnection.getValue>");
        ObjMapper1 objMapper1 = (ObjMapper1)$mapper;
        Intrinsics.checkNotNull((Object)$arg0);
        return $result.complete(objMapper1.map($arg0));
    }

    private static final void getValue$lambda$3(XPCServiceConnection this$0, CompletableFuture $result, Mapper $mapper, ID arg0, ID arg1) {
        this$0.withPool(() -> XPCServiceConnection.getValue$lambda$3$0($result, $mapper, arg0, arg1));
    }

    private static final boolean getValue$lambda$3$0(CompletableFuture $result, Mapper $mapper, ID $arg0, ID $arg1) {
        Intrinsics.checkNotNull((Object)$mapper, (String)"null cannot be cast to non-null type com.jetbrains.cidr.xcode.ObjMapper2<T of com.jetbrains.cidr.xcode.XPCServiceConnection.getValue>");
        ObjMapper2 objMapper2 = (ObjMapper2)$mapper;
        Intrinsics.checkNotNull((Object)$arg0);
        Intrinsics.checkNotNull((Object)$arg1);
        return $result.complete(objMapper2.map($arg0, $arg1));
    }

    private static final void getValue$lambda$4(XPCServiceConnection this$0, CompletableFuture $result, Mapper $mapper, ID arg0, ID arg1, ID arg2) {
        this$0.withPool(() -> XPCServiceConnection.getValue$lambda$4$0($result, $mapper, arg0, arg1, arg2));
    }

    private static final boolean getValue$lambda$4$0(CompletableFuture $result, Mapper $mapper, ID $arg0, ID $arg1, ID $arg2) {
        Intrinsics.checkNotNull((Object)$mapper, (String)"null cannot be cast to non-null type com.jetbrains.cidr.xcode.ObjMapper3<T of com.jetbrains.cidr.xcode.XPCServiceConnection.getValue>");
        ObjMapper3 objMapper3 = (ObjMapper3)$mapper;
        Intrinsics.checkNotNull((Object)$arg0);
        Intrinsics.checkNotNull((Object)$arg1);
        Intrinsics.checkNotNull((Object)$arg2);
        return $result.complete(objMapper3.map($arg0, $arg1, $arg2));
    }

    private static final ID getValue$lambda$5(Function1 $tmp0, Pointer p0) {
        return (ID)$tmp0.invoke((Object)p0);
    }

    private static final ID getValue$lambda$6(XPCServiceConnection this$0, String $selector, Function0 $args, Pointer callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread($args.invoke());
        spreadBuilder.add((Object)callback);
        return this$0.invokeServiceWithAvailableConnection($selector, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    public static final /* synthetic */ void access$setService$p(XPCServiceConnection $this, ID iD) {
        $this.service = iD;
    }

    public static final /* synthetic */ ID access$getConnection$p(XPCServiceConnection $this) {
        return $this.connection;
    }

    public static final /* synthetic */ void access$setConnection$p(XPCServiceConnection $this, ID iD) {
        $this.connection = iD;
    }

    public static final /* synthetic */ XPCServiceConnectionDelegate access$getDelegate$p(XPCServiceConnection $this) {
        return $this.delegate;
    }

    public static final /* synthetic */ void access$setServiceProcessHandler$p(XPCServiceConnection $this, ProcessHandler processHandler) {
        $this.serviceProcessHandler = processHandler;
    }

    public static final /* synthetic */ void access$setConnectLatch$p(XPCServiceConnection $this, MutableSharedFlow mutableSharedFlow) {
        $this.connectLatch = mutableSharedFlow;
    }

    public static final /* synthetic */ int access$getRestartLimit$p(XPCServiceConnection $this) {
        return $this.restartLimit;
    }

    public static final /* synthetic */ AtomicInteger access$getServiceTerminationCount$p(XPCServiceConnection $this) {
        return $this.serviceTerminationCount;
    }

    public static final /* synthetic */ Object access$awaitForConnection(XPCServiceConnection $this, Continuation $completion) {
        return $this.awaitForConnection((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/xcode/XPCServiceConnection$UnavailableException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.cidr.cocoaCommon"})
    public static final class UnavailableException
    extends IllegalStateException {
        public UnavailableException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

