/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/xcode/SwiftToolchain;", "", "bundleId", "", "path", "displayName", "isXcodeDefault", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getBundleId", "()Ljava/lang/String;", "getPath", "getDisplayName", "()Z", "appendEnvironmentVariables", "", "map", "", "type", "Lcom/jetbrains/cidr/xcode/frameworks/ApplePlatform$Type;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.cidr.cocoaCommon"})
@SourceDebugExtension(value={"SMAP\nSwiftToolchain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftToolchain.kt\ncom/jetbrains/cidr/xcode/SwiftToolchain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class SwiftToolchain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String bundleId;
    @NotNull
    private final String path;
    @Nullable
    private final String displayName;
    private final boolean isXcodeDefault;

    public SwiftToolchain(@Nullable String bundleId, @NotNull String path, @Nullable String displayName, boolean isXcodeDefault) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.bundleId = bundleId;
        this.path = path;
        this.displayName = displayName;
        this.isXcodeDefault = isXcodeDefault;
    }

    public /* synthetic */ SwiftToolchain(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl);
    }

    @Nullable
    public final String getBundleId() {
        return this.bundleId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean isXcodeDefault() {
        return this.isXcodeDefault;
    }

    public final void appendEnvironmentVariables(@NotNull Map<String, String> map, @NotNull ApplePlatform.Type type) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.isXcodeDefault) {
            return;
        }
        File p0 = file2 = new File(this.path, "usr/lib/swift/" + type.getPlatformName());
        boolean bl = false;
        File file3 = file = p0.isDirectory() ? file2 : null;
        if (file != null) {
            EnvironmentUtil.appendSearchPath(map, (String)"DYLD_FRAMEWORK_PATH", (String)file.getAbsolutePath());
        }
    }

    @Nullable
    public final String component1() {
        return this.bundleId;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    @Nullable
    public final String component3() {
        return this.displayName;
    }

    public final boolean component4() {
        return this.isXcodeDefault;
    }

    @NotNull
    public final SwiftToolchain copy(@Nullable String bundleId, @NotNull String path, @Nullable String displayName, boolean isXcodeDefault) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SwiftToolchain(bundleId, path, displayName, isXcodeDefault);
    }

    public static /* synthetic */ SwiftToolchain copy$default(SwiftToolchain swiftToolchain, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = swiftToolchain.bundleId;
        }
        if ((n & 2) != 0) {
            string2 = swiftToolchain.path;
        }
        if ((n & 4) != 0) {
            string3 = swiftToolchain.displayName;
        }
        if ((n & 8) != 0) {
            bl = swiftToolchain.isXcodeDefault;
        }
        return swiftToolchain.copy(string, string2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "SwiftToolchain(bundleId=" + this.bundleId + ", path=" + this.path + ", displayName=" + this.displayName + ", isXcodeDefault=" + this.isXcodeDefault + ")";
    }

    public int hashCode() {
        int result = this.bundleId == null ? 0 : this.bundleId.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + Boolean.hashCode(this.isXcodeDefault);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwiftToolchain)) {
            return false;
        }
        SwiftToolchain swiftToolchain = (SwiftToolchain)other;
        if (!Intrinsics.areEqual((Object)this.bundleId, (Object)swiftToolchain.bundleId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)swiftToolchain.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.displayName, (Object)swiftToolchain.displayName)) {
            return false;
        }
        return this.isXcodeDefault == swiftToolchain.isXcodeDefault;
    }

    @JvmStatic
    @NotNull
    public static final SwiftToolchain getXcodeSelectedToolchain(@NotNull XcodeInstallation xcodeInstallation) {
        return Companion.getXcodeSelectedToolchain(xcodeInstallation);
    }

    @JvmStatic
    @Nullable
    public static final SwiftToolchain findInstalledToolchain(@NotNull String bundleIdentifier) {
        return Companion.findInstalledToolchain(bundleIdentifier);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/xcode/SwiftToolchain$Companion;", "", "<init>", "()V", "getXcodeSelectedToolchain", "Lcom/jetbrains/cidr/xcode/SwiftToolchain;", "xcodeInstallation", "Lcom/jetbrains/cidr/xcode/XcodeInstallation;", "getXcodeDefaultToolchain", "findInstalledToolchain", "bundleIdentifier", "", "doFindInstalledToolchain", "bundleId", "intellij.cidr.cocoaCommon"})
    @SourceDebugExtension(value={"SMAP\nSwiftToolchain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftToolchain.kt\ncom/jetbrains/cidr/xcode/SwiftToolchain$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1374#2:72\n1460#2,5:73\n*S KotlinDebug\n*F\n+ 1 SwiftToolchain.kt\ncom/jetbrains/cidr/xcode/SwiftToolchain$Companion\n*L\n53#1:72\n53#1:73,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SwiftToolchain getXcodeSelectedToolchain(@NotNull XcodeInstallation xcodeInstallation) {
            SwiftToolchain swiftToolchain;
            Intrinsics.checkNotNullParameter((Object)xcodeInstallation, (String)"xcodeInstallation");
            String[] stringArray = new String[]{"sh", "-c", "defaults read com.apple.dt.Xcode DVTDefaultToolchainOverrideIdentifer"};
            String xcodeSelectedToolchainIdentifier = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(stringArray));
            SwiftToolchain selectedToolchain = null;
            CharSequence charSequence = xcodeSelectedToolchainIdentifier;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                selectedToolchain = this.findInstalledToolchain(xcodeSelectedToolchainIdentifier);
            }
            if ((swiftToolchain = selectedToolchain) == null) {
                swiftToolchain = this.getXcodeDefaultToolchain(xcodeInstallation);
            }
            return swiftToolchain;
        }

        private final SwiftToolchain getXcodeDefaultToolchain(XcodeInstallation xcodeInstallation) {
            String string = xcodeInstallation.getSubFilePath("Toolchains/XcodeDefault.xctoolchain/");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubFilePath(...)");
            return new SwiftToolchain(null, string, null, true);
        }

        @JvmStatic
        @Nullable
        public final SwiftToolchain findInstalledToolchain(@NotNull String bundleIdentifier) {
            Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
            SwiftToolchain foundToolchain = this.doFindInstalledToolchain(bundleIdentifier);
            if (foundToolchain == null) {
                XCLog.LOG.warn("Failed to find selected swift toolchain with identifier: " + bundleIdentifier);
            }
            return foundToolchain;
        }

        /*
         * WARNING - void declaration
         */
        private final SwiftToolchain doFindInstalledToolchain(String bundleId) {
            void $this$flatMapTo$iv$iv;
            String installationPath = "/Library/Developer/Toolchains/";
            Object[] objectArray = new String[]{installationPath, SystemProperties.getUserHome() + installationPath};
            List toolchainInstallationPaths = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$flatMap$iv = toolchainInstallationPaths;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                String path = (String)element$iv$iv;
                boolean bl = false;
                Object[] objectArray2 = new File(path).listFiles(Companion::doFindInstalledToolchain$lambda$0$0);
                Iterable list$iv$iv = objectArray2 != null && (list = ArraysKt.toList((Object[])objectArray2)) != null ? list : CollectionsKt.emptyList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List possibleToolchainRoots = (List)destination$iv$iv;
            for (File possibleToolchainDir : possibleToolchainRoots) {
                String toolchainDescription;
                Plist plist;
                File infoPlist = new File(possibleToolchainDir, "Info.plist");
                Plist plist2 = plist = PlistDriver.readAnyFormatSafe((File)infoPlist);
                String toolchainBundleIdentifier = plist2 != null ? plist2.getString("CFBundleIdentifier") : null;
                Plist plist3 = plist;
                String string = toolchainDescription = plist3 != null ? plist3.getString("DisplayName") : null;
                if (!Intrinsics.areEqual((Object)toolchainBundleIdentifier, (Object)bundleId)) continue;
                String string2 = possibleToolchainDir.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                return new SwiftToolchain(bundleId, string2, toolchainDescription, false, 8, null);
            }
            return null;
        }

        private static final boolean doFindInstalledToolchain$lambda$0$0(File file) {
            return FileUtilRt.extensionEquals((String)file.getPath(), (String)"xctoolchain");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

