/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.notification.NotificationType;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.xcode.Action;
import com.jetbrains.cidr.xcode.OpenXcodeSettingsAction;
import com.jetbrains.cidr.xcode.SwitchXcodeAction;
import com.jetbrains.cidr.xcode.XCLog;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0005H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/xcode/Message;", "", "type", "Lcom/intellij/notification/NotificationType;", "message", "", "Lorg/jetbrains/annotations/Nls;", "action", "Lcom/jetbrains/cidr/xcode/Action;", "<init>", "(Lcom/intellij/notification/NotificationType;Ljava/lang/String;Lcom/jetbrains/cidr/xcode/Action;)V", "getType", "()Lcom/intellij/notification/NotificationType;", "getMessage", "()Ljava/lang/String;", "getAction", "()Lcom/jetbrains/cidr/xcode/Action;", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "Companion", "intellij.cidr.cocoaCommon"})
public final class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationType type;
    @NotNull
    private final String message;
    @Nullable
    private final Action action;

    public Message(@NotNull NotificationType type, @NotNull String message, @Nullable Action action) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.type = type;
        this.message = message;
        this.action = action;
        if (this.action != null) {
            XCLog.LOG.assertTrue(((CharSequence)this.message).length() > 0);
        }
    }

    @NotNull
    public final NotificationType getType() {
        return this.type;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Action getAction() {
        return this.action;
    }

    @NotNull
    public String toString() {
        return ((CharSequence)this.message).length() == 0 ? "-----" : (this.action != null ? this.type + ":" + this.message + " -> " + this.action : this.type + ":" + this.message);
    }

    @NotNull
    public final NotificationType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @Nullable
    public final Action component3() {
        return this.action;
    }

    @NotNull
    public final Message copy(@NotNull NotificationType type, @NotNull String message, @Nullable Action action) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new Message(type, message, action);
    }

    public static /* synthetic */ Message copy$default(Message message, NotificationType notificationType, String string, Action action, int n, Object object) {
        if ((n & 1) != 0) {
            notificationType = message.type;
        }
        if ((n & 2) != 0) {
            string = message.message;
        }
        if ((n & 4) != 0) {
            action = message.action;
        }
        return message.copy(notificationType, string, action);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.message.hashCode();
        result = result * 31 + (this.action == null ? 0 : this.action.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message message = (Message)other;
        if (this.type != message.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)message.message)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.action, (Object)message.action);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0015\u0010\b\u001a\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u0005J\u001b\u0010\u0013\u001a\u00020\u00052\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00052\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/xcode/Message$Companion;", "", "<init>", "()V", "newBundleMessage", "Lcom/jetbrains/cidr/xcode/Message;", "type", "Lcom/intellij/notification/NotificationType;", "message", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.CocoaCommonBundle", "params", "", "(Lcom/intellij/notification/NotificationType;Ljava/lang/String;[Ljava/lang/Object;)Lcom/jetbrains/cidr/xcode/Message;", "newMessage", "Lorg/jetbrains/annotations/Nls;", "newSeparator", "newSwitchMessage", "switchTo", "Ljava/io/File;", "newSelectXcodeManuallyMessage", "intellij.cidr.cocoaCommon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Message newBundleMessage(@NotNull NotificationType type, @NotNull String message, Object ... params) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String string = CocoaCommonBundle.message(message, Arrays.copyOf(params, params.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.newMessage(type, string);
        }

        @NotNull
        public final Message newMessage(@NotNull NotificationType type, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Message(type, message, null);
        }

        @NotNull
        public final Message newSeparator() {
            return new Message(NotificationType.INFORMATION, "", null);
        }

        @NotNull
        public final Message newSwitchMessage(@NotNull String message, @NotNull File switchTo) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)switchTo, (String)"switchTo");
            return new Message(NotificationType.INFORMATION, message, new SwitchXcodeAction(switchTo));
        }

        @NotNull
        public final Message newSelectXcodeManuallyMessage(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Message(NotificationType.INFORMATION, message, OpenXcodeSettingsAction.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

