/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.xcode.LinkClicker;
import com.jetbrains.cidr.xcode.Message;
import com.jetbrains.cidr.xcode.Result;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.XcodeSettings;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017*\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/xcode/InstallationSelector;", "", "installations", "", "Lcom/jetbrains/cidr/xcode/XcodeInstallation;", "currentInstallation", "currentlyKnownXcodePaths", "", "<init>", "(Ljava/util/List;Lcom/jetbrains/cidr/xcode/XcodeInstallation;Ljava/util/List;)V", "messages", "", "Lcom/jetbrains/cidr/xcode/Message;", "shouldOfferAllInstallations", "", "selectInstallationAndShowCorrespondingNotification", "Lcom/jetbrains/cidr/xcode/Result;", "selectInstallation", "checkInstalledAndSupported", "", "suggestInstallations", "selectedInstallation", "filterNewInstallations", "Lkotlin/sequences/Sequence;", "chooseBetterInstallation", "setupNotification", "Lcom/intellij/notification/Notification;", "intellij.cidr.cocoaCommon"})
@SourceDebugExtension(value={"SMAP\nInstallationSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallationSelector.kt\ncom/jetbrains/cidr/xcode/InstallationSelector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 HtmlChunkUtil.kt\ncom/intellij/openapi/util/text/HtmlChunkUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1#2:185\n52#3:186\n21#4:187\n1878#5,3:188\n*S KotlinDebug\n*F\n+ 1 InstallationSelector.kt\ncom/jetbrains/cidr/xcode/InstallationSelector\n*L\n78#1:186\n148#1:187\n149#1:188,3\n*E\n"})
public final class InstallationSelector {
    @NotNull
    private final List<XcodeInstallation> installations;
    @Nullable
    private final XcodeInstallation currentInstallation;
    @NotNull
    private final List<String> currentlyKnownXcodePaths;
    @NotNull
    private final List<Message> messages;
    private boolean shouldOfferAllInstallations;

    public InstallationSelector(@NotNull List<? extends XcodeInstallation> installations, @Nullable XcodeInstallation currentInstallation, @NotNull List<String> currentlyKnownXcodePaths) {
        Intrinsics.checkNotNullParameter(installations, (String)"installations");
        Intrinsics.checkNotNullParameter(currentlyKnownXcodePaths, (String)"currentlyKnownXcodePaths");
        this.installations = installations;
        this.currentInstallation = currentInstallation;
        this.currentlyKnownXcodePaths = currentlyKnownXcodePaths;
        this.messages = (List)new SmartList();
        XCLog.LOG.assertTrue(!this.installations.isEmpty());
    }

    @NotNull
    public final Result selectInstallationAndShowCorrespondingNotification() {
        XcodeInstallation currentInstallation = this.selectInstallation();
        return new Result(currentInstallation, null, this.messages);
    }

    private final XcodeInstallation selectInstallation() {
        Object object;
        block3: {
            block2: {
                XcodeInstallation xcodeInstallation;
                object = this.currentInstallation;
                if (object == null) break block2;
                XcodeInstallation it = xcodeInstallation = object;
                boolean bl = false;
                object = it.isInstalled() ? xcodeInstallation : null;
                if (object != null) break block3;
            }
            object = this.chooseBetterInstallation();
        }
        XcodeInstallation selectedInstallation = object;
        this.checkInstalledAndSupported(selectedInstallation);
        this.suggestInstallations(selectedInstallation);
        return selectedInstallation;
    }

    private final void checkInstalledAndSupported(XcodeInstallation currentInstallation) {
        if (!currentInstallation.isInstalled()) {
            Collection collection = this.messages;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)currentInstallation.getBasePath(), (String)"getBasePath(...)");
            collection.add(Message.Companion.newBundleMessage(NotificationType.ERROR, "settings.xcode.notFound", objectArray));
            this.shouldOfferAllInstallations = true;
        } else {
            HtmlBuilder error = currentInstallation.isSupportedVersion();
            if (error != null) {
                Collection collection = this.messages;
                String string = error.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(Message.Companion.newMessage(NotificationType.WARNING, string));
                this.shouldOfferAllInstallations = true;
            }
        }
    }

    private final void suggestInstallations(XcodeInstallation selectedInstallation) {
        Object[] objectArray;
        Sequence<XcodeInstallation> sequence;
        Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.installations), arg_0 -> InstallationSelector.suggestInstallations$lambda$0(selectedInstallation, arg_0)), InstallationSelector::suggestInstallations$lambda$1);
        boolean condition$iv = !this.shouldOfferAllInstallations;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$suggestInstallations_u24lambda_u242 = $this$applyIf$iv;
            boolean bl = false;
            sequence = this.filterNewInstallations((Sequence<? extends XcodeInstallation>)$this$suggestInstallations_u24lambda_u242);
        } else {
            sequence = $this$applyIf$iv;
        }
        List toSuggest = SequencesKt.toList((Sequence)sequence);
        boolean hasInstallations = !((Collection)toSuggest).isEmpty();
        boolean suggestSelectXcodeManually = this.shouldOfferAllInstallations;
        if (!hasInstallations && !suggestSelectXcodeManually) {
            return;
        }
        if (this.messages.isEmpty()) {
            Collection collection = this.messages;
            objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)selectedInstallation.getDisplayVersion(), (String)"getDisplayVersion(...)");
            Intrinsics.checkNotNullExpressionValue((Object)selectedInstallation.getBasePath(), (String)"getBasePath(...)");
            collection.add(Message.Companion.newBundleMessage(NotificationType.INFORMATION, "settings.xcode.using.version.at.path", objectArray));
        }
        if (hasInstallations) {
            ((Collection)this.messages).add(Message.Companion.newSeparator());
            Collection collection = this.messages;
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.pluralize((String)"version", (int)toSuggest.size()), (String)"pluralize(...)");
            collection.add(Message.Companion.newBundleMessage(NotificationType.INFORMATION, "settings.xcode.alternative.version.available", objectArray));
            CollectionsKt.addAll((Collection)this.messages, (Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)toSuggest), InstallationSelector::suggestInstallations$lambda$3));
        }
        if (suggestSelectXcodeManually) {
            if (!hasInstallations) {
                ((Collection)this.messages).add(Message.Companion.newSeparator());
            }
            Collection collection = this.messages;
            String string = CocoaCommonBundle.message("settings.xcode.select.xcode.manually", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            collection.add(Message.Companion.newSelectXcodeManuallyMessage(string));
        }
        ((Collection)this.messages).add(Message.Companion.newSeparator());
        ((Collection)this.messages).add(Message.Companion.newBundleMessage(NotificationType.INFORMATION, "settings.xcode.restart.required", new Object[0]));
    }

    private final Sequence<XcodeInstallation> filterNewInstallations(Sequence<? extends XcodeInstallation> $this$filterNewInstallations) {
        Set set = CollectionFactory.createFilePathSet((Collection)this.currentlyKnownXcodePaths);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createFilePathSet(...)");
        Set previouslyFound = set;
        return SequencesKt.filterNot($this$filterNewInstallations, arg_0 -> InstallationSelector.filterNewInstallations$lambda$0(previouslyFound, arg_0));
    }

    private final XcodeInstallation chooseBetterInstallation() {
        XcodeInstallation xcodeInstallation;
        XcodeInstallation xcodeInstallation2;
        Object v0;
        block6: {
            this.shouldOfferAllInstallations = true;
            Iterable iterable = this.installations;
            for (Object t : iterable) {
                XcodeInstallation it = (XcodeInstallation)t;
                boolean bl = false;
                if (!it.isValid()) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        if ((xcodeInstallation2 = (XcodeInstallation)v0) == null) {
            xcodeInstallation2 = this.installations.get(0);
        }
        XcodeInstallation defaultInstallation = xcodeInstallation2;
        if (this.currentInstallation == null) {
            xcodeInstallation = defaultInstallation;
        } else if (defaultInstallation.isValid()) {
            Collection collection = this.messages;
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)defaultInstallation.getDisplayVersion(), (String)"getDisplayVersion(...)");
            Intrinsics.checkNotNullExpressionValue((Object)defaultInstallation.getBasePath(), (String)"getBasePath(...)");
            collection.add(Message.Companion.newBundleMessage(NotificationType.INFORMATION, "settings.xcode.switching.to.version.at.path", objectArray));
            xcodeInstallation = defaultInstallation;
        } else {
            xcodeInstallation = this.currentInstallation;
        }
        return xcodeInstallation;
    }

    /*
     * WARNING - void declaration
     */
    private final Notification setupNotification() {
        HtmlBuilder htmlBuilder;
        if (this.messages.isEmpty()) {
            return null;
        }
        boolean $i$f$buildHtml = false;
        HtmlBuilder $this$setupNotification_u24lambda_u240 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = this.messages;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void message;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Message message2 = (Message)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i > 0) {
                $this$setupNotification_u24lambda_u240.br();
            }
            HtmlBuilder htmlBuilder2 = message.getAction() != null ? $this$setupNotification_u24lambda_u240.appendLink(String.valueOf(i), message.getMessage()) : $this$setupNotification_u24lambda_u240.appendRaw(message.getMessage());
        }
        String string = htmlBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String text = string;
        Iterator iterator = ((Iterable)this.messages).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Message it = (Message)iterator.next();
        boolean bl3 = false;
        Comparable comparable = (Comparable)it.getType();
        while (iterator.hasNext()) {
            Message it2 = (Message)iterator.next();
            $i$a$-maxOf-InstallationSelector$setupNotification$type$1 = false;
            Comparable comparable2 = (Comparable)it2.getType();
            if (comparable.compareTo(comparable2) >= 0) continue;
            comparable = comparable2;
        }
        NotificationType type = (NotificationType)comparable;
        return XcodeSettings.getNotificationGroup().createNotification("", text, type).setListener((NotificationListener)new LinkClicker(this.messages));
    }

    private static final boolean suggestInstallations$lambda$0(XcodeInstallation $selectedInstallation, XcodeInstallation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$selectedInstallation);
    }

    private static final boolean suggestInstallations$lambda$1(XcodeInstallation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final Message suggestInstallations$lambda$3(XcodeInstallation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.getDisplayVersion()};
        String string = CocoaCommonBundle.message("settings.xcode.switch.to.version", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        File file = it.getBaseFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBaseFile(...)");
        return Message.Companion.newSwitchMessage(string, file);
    }

    private static final boolean filterNewInstallations$lambda$0(Set $previouslyFound, XcodeInstallation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $previouslyFound.contains(it.getBasePath());
    }
}

