/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.xcode.Xcode;
import com.jetbrains.cidr.xcode.XcodeDiscoverer;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.XcodeSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XcodeConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private boolean isInitializationReset = true;
    private ComboboxWithBrowseButton myCombo;
    private JBLabel myInfoLabel;
    private JBCheckBox myDownloadCachesCheckBox;
    public static final String AUTOMATICALLY_DOWNLOAD_KEY = "com.jetbrains.cidr.ZipCacheDownloader.shouldDownload";

    @NotNull
    public String getId() {
        return "XcodeSettings";
    }

    @Nls
    public String getDisplayName() {
        return CocoaCommonBundle.message("xcode", new Object[0]);
    }

    public String getHelpTopic() {
        return "Settings_Xcode";
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultPaddingX(0, 8).setDefaultPaddingY(0, 8).setDefaultAnchor(0, 13).setDefaultAnchor(1, 17).setDefaultWeightX(1, 1.0).setDefaultFill(2);
        this.myDownloadCachesCheckBox = new JBCheckBox(CocoaCommonBundle.message("settings.xcode.download.caches.automatically.title", new Object[0]));
        JPanel cachesPanel = UI.PanelFactory.panel((JComponent)this.myDownloadCachesCheckBox).withComment(CocoaCommonBundle.message("settings.xcode.download.caches.automatically.hint", new Object[0])).createPanel();
        panel.add((Component)cachesPanel, bag.nextLine().coverLine().insets(-1, -1, 8, -1));
        this.myInfoLabel = new JBLabel(UIUtil.ComponentStyle.SMALL);
        this.myCombo = new ComboboxWithBrowseButton();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(this, true, true, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && file.isDirectory() && FileUtil.namesEqual((String)"app", (String)file.getExtension());
            }
        }.withTitle(CocoaCommonBundle.message("select.xcode.application", new Object[0]));
        this.myCombo.addBrowseFolderListener(null, descriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                XcodeInstallation xcode = XcodeConfigurable.this.getSelectedXcode();
                return xcode != null ? xcode.getApplicationFilePath() : null;
            }

            public void setText(JComboBox component, @NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                XcodeConfigurable.this.updateComboBox(XcodeDiscoverer.getInstance().getXcodeAppBaseFile(new File(text)).getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/XcodeConfigurable$2", "setText"));
            }
        });
        this.myCombo.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(value instanceof XcodeInstallation)) {
                    return;
                }
                XcodeInstallation xcode = (XcodeInstallation)value;
                boolean installed = xcode.isInstalled();
                boolean supported = xcode.isSupportedVersion() == null;
                SimpleTextAttributes attributes = installed && supported ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                this.append(xcode.getDisplayVersion(), attributes);
                if (!installed) {
                    this.append(" ");
                    this.append(CocoaCommonBundle.message("settings.xcode.version.not.found", new Object[0]), attributes);
                } else if (!supported) {
                    this.append(" ");
                    this.append(CocoaCommonBundle.message("settings.xcode.version.not.supported", new Object[0]), attributes);
                }
                this.append(" ");
                this.append(xcode.getBasePath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/cidr/XcodeConfigurable$3", "customizeCellRenderer"));
            }
        });
        panel.add((Component)new JLabel(CocoaCommonBundle.message("settings.selected.xcode", new Object[0])), bag.nextLine().next());
        panel.add((Component)this.myCombo, bag.next());
        String toolchainDisplayName = Xcode.getInstance().getToolchainDisplayName();
        if (!StringUtil.isEmptyOrSpaces((String)toolchainDisplayName)) {
            JBLabel toolchainLabel = new JBLabel(UIUtil.ComponentStyle.SMALL);
            toolchainLabel.setText(CocoaCommonBundle.message("settings.selected.toolchain", toolchainDisplayName));
            panel.add((Component)toolchainLabel, bag.nextLine().coverLine());
        }
        panel.add((Component)this.myInfoLabel, bag.nextLine().coverLine().insets(16, -1, -1, -1));
        this.myCombo.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XcodeConfigurable.this.updateMessages();
            }
        });
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel, "North");
        return wrapper;
    }

    public boolean isModified() {
        return this.isXcodeModified() || this.myDownloadCachesCheckBox != null && PropertiesComponent.getInstance().isTrueValue(AUTOMATICALLY_DOWNLOAD_KEY) != this.myDownloadCachesCheckBox.isSelected();
    }

    private boolean isXcodeModified() {
        XcodeInstallation selectedXcode = this.getSelectedXcode();
        return selectedXcode != null && !Xcode.getInstance().getInstallation().equals((Object)selectedXcode);
    }

    private void updateMessages() {
        HtmlBuilder error;
        XcodeInstallation xcode;
        HtmlBuilder message = new HtmlBuilder();
        if (this.isXcodeModified()) {
            message.append(CocoaCommonBundle.message("settings.xcode.restart.required", new Object[0]));
        }
        if ((xcode = this.getSelectedXcode()) != null && (error = xcode.isSupportedVersion()) != null) {
            if (!message.isEmpty()) {
                message.br().br();
            }
            message.append(error);
        }
        if (message.isEmpty()) {
            this.myInfoLabel.setVisible(false);
        } else {
            this.myInfoLabel.setText(message.wrapWithHtmlBody().toString());
            this.myInfoLabel.setIcon(AllIcons.General.BalloonWarning);
            this.myInfoLabel.setVerticalTextPosition(1);
            this.myInfoLabel.setVisible(true);
        }
    }

    public void apply() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (this.myDownloadCachesCheckBox.isSelected()) {
            propertiesComponent.setValue(AUTOMATICALLY_DOWNLOAD_KEY, true);
        } else {
            propertiesComponent.unsetValue(AUTOMATICALLY_DOWNLOAD_KEY);
        }
        String path = this.getSelectedPath();
        if (path == null) {
            return;
        }
        XcodeSettings.getInstance().setSelectedXcodeBasePath(path);
        if (this.isXcodeModified()) {
            this.suggestRestart();
        }
    }

    private void suggestRestart() {
        int result = Messages.showYesNoDialog((String)CocoaCommonBundle.message("settings.xcode.restart.required", new Object[0]), (String)"", (String)CocoaCommonBundle.message("xcode.configurable.restart", new Object[0]), (String)CocoaCommonBundle.message("xcode.configurable.later", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (result == 0) {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            app.invokeLater(() -> app.restart(true), ModalityState.nonModal());
            Container window = this.myInfoLabel.getRootPane().getParent();
            if (window instanceof DialogWrapperDialog) {
                ((DialogWrapperDialog)window).getDialogWrapper().close(0);
            }
        }
    }

    @Nullable
    private String getSelectedPath() {
        XcodeInstallation xcode = this.getSelectedXcode();
        return xcode == null ? null : xcode.getBasePath();
    }

    @Nullable
    private XcodeInstallation getSelectedXcode() {
        if (this.myCombo == null) {
            return null;
        }
        Object item = this.myCombo.getComboBox().getSelectedItem();
        if (!(item instanceof XcodeInstallation)) {
            return null;
        }
        return (XcodeInstallation)item;
    }

    public void reset() {
        XcodeSettings xcodeSettings = XcodeSettings.getInstance();
        String pathToReset = this.isInitializationReset ? xcodeSettings.getSelectedXcodeBasePath() : Xcode.getInstance().getInstallation().getBasePath();
        this.isInitializationReset = false;
        this.updateComboBox(pathToReset);
        this.myDownloadCachesCheckBox.setSelected(PropertiesComponent.getInstance().isTrueValue(AUTOMATICALLY_DOWNLOAD_KEY));
    }

    private void updateComboBox(@Nullable String selectedPath) {
        XcodeInstallation selectedInstallation;
        ArrayList<XcodeInstallation> installations = new ArrayList<XcodeInstallation>();
        for (String each : XcodeSettings.getInstance().getDetectedXcodePaths()) {
            installations.add(new XcodeInstallation(new File(each)));
        }
        installations.sort(XcodeSettings.XCODE_COMPARATOR);
        XcodeInstallation xcodeInstallation = selectedInstallation = selectedPath == null ? null : new XcodeInstallation(new File(selectedPath));
        if (selectedInstallation != null && !installations.contains(selectedInstallation)) {
            installations.add(0, selectedInstallation);
        }
        CollectionComboBoxModel collection = new CollectionComboBoxModel(installations, (Object)selectedInstallation);
        this.myCombo.getComboBox().setModel(collection);
        this.updateMessages();
    }
}

