/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.jetbrains.cidr.xcode.Xcode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppleScript {
    @NonNls
    private static final String SPLIT_SCRIPT = "to splitString(aString, delimiter)\n set retVal to {}\n set prevDelimiter to AppleScript's text item delimiters\n set AppleScript's text item delimiters to {delimiter}\n set retVal to every text item of aString\n set AppleScript's text item delimiters to prevDelimiter\n return retVal\nend splitString\n";

    private AppleScript() {
    }

    public static void execute(@NonNls String script, boolean inProcess) throws IdeScriptException {
        if (inProcess) {
            IdeScriptEngine engine = IdeScriptEngineManager.getInstance().getEngineByName("AppleScript", null);
            if (engine == null) {
                throw new IdeScriptException("Cannot find AppleScript engine");
            }
            engine.eval(script);
        } else {
            try {
                Runtime runtime = Runtime.getRuntime();
                @NonNls String[] args = new String[]{ExecUtil.getOsascriptPath(), "-e", script};
                runtime.exec(args);
            }
            catch (IOException e) {
                throw new IdeScriptException((Throwable)e);
            }
        }
    }

    public static void tell(@NonNls String app, @NonNls String action, boolean inProcess) throws IdeScriptException {
        AppleScript.execute("tell application \"" + app + "\"\n " + action + "\nend tell", inProcess);
    }

    public static void tellWhenRunning(@NonNls String action, @NonNls String app, boolean inProcess) throws IdeScriptException {
        AppleScript.execute("set i to 0\nrepeat\n if isRunning(\"" + app + "\") then\n  tell application \"" + app + "\"\n   " + action + "\n  end tell\n  exit repeat\n end if\n set i to (i + 1)\n if i = 200 then exit repeat\n delay 0.1\nend repeat\n" + AppleScript.isRunningScript(), inProcess);
    }

    private static String isRunningScript() {
        return "on isRunning(appName)\n  tell application \"System Events\" to set appNameIsRunning to exists (processes where name is appName)\n  return appNameIsRunning\nend ApplicationIsRunning\n";
    }

    public static void kill(@NonNls String appNamePattern, boolean inProcess) throws IdeScriptException {
        AppleScript.kill(appNamePattern, inProcess, false);
    }

    public static void kill(@NonNls String appNamePattern, boolean inProcess, boolean dashNine) throws IdeScriptException {
        AppleScript.execute("to splitString(aString, delimiter)\n set retVal to {}\n set prevDelimiter to AppleScript's text item delimiters\n set AppleScript's text item delimiters to {delimiter}\n set retVal to every text item of aString\n set AppleScript's text item delimiters to prevDelimiter\n return retVal\nend splitString\nset appName to \"" + appNamePattern + "\"\nset pidsString to (do shell script \"ps ax | awk '{print $1, $5}' | grep \" & (quoted form of appName) & \" | awk '{print $1}'\")\nset pids to splitString(pidsString, \"\\r\")\n" + AppleScript.forEach("pids", "each", "if each is not \"\" then \ntry\ndo shell script (\"kill " + (dashNine ? "-9" : "") + " \" & each)\nend try\nend if"), inProcess);
    }

    public static void openFileInXcode(@NotNull String filePathToOpen, @Nullable File projectFile) throws IdeScriptException, IOException {
        if (filePathToOpen == null) {
            AppleScript.$$$reportNull$$$0(0);
        }
        String xcodePath = Xcode.getInstance().getApplicationFilePath();
        String safeProjectFilePath = projectFile == null ? "missing value" : "\"" + projectFile.getPath() + "\"";
        String safeProjectFileName = projectFile == null ? "missing value" : "\"" + projectFile.getName() + "\"";
        Object delayIfRunningString = "";
        double MIN_MILLIS_SINCE_CREATION = 3000.0;
        if (projectFile != null) {
            FileTime creationTime = Files.readAttributes(projectFile.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
            long millisSinceCreation = Math.max(System.currentTimeMillis() - creationTime.toMillis(), 0L);
            if ((double)millisSinceCreation < MIN_MILLIS_SINCE_CREATION) {
                double delayMillis = MIN_MILLIS_SINCE_CREATION - (double)millisSinceCreation;
                delayIfRunningString = "  if my isRunning(\"Xcode\")\n    delay " + Math.ceil(delayMillis / 100.0) / 10.0 + "\n  end if\n";
            }
        }
        AppleScript.execute("on hasDocument(filePath)\n  tell application \"" + xcodePath + "\"\n    repeat with openedDocument in documents\n      set openedFilePath to path of openedDocument\n      if filePath is equal to openedFilePath then\n        return true\n      end if\n    end repeat\n  end tell\n  \n  return false\nend hasDocument\n\n" + AppleScript.isRunningScript() + "\nset projFilePath to " + safeProjectFilePath + "\nset projFileName to " + safeProjectFileName + "\nset filePath to \"" + filePathToOpen + "\"\nset isProjFileDefined to (projFilePath is not missing value)\n\ntell application \"" + xcodePath + "\"\n" + (String)delayIfRunningString + "\n  if isProjFileDefined then\n    if not my hasDocument(projFilePath) then\n      open projFilePath\n        activate\n        \n        set workspaceDocument to workspace document projFileName\n        repeat 40 times\n          if loaded of workspaceDocument is true then\n            exit repeat\n          end if\n          delay 0.5\n        end repeat\n    end if\n    \n    activate\n  end if\n  \n  open filePath\n  \n  if not isProjFileDefined then\n    activate\n  end if\nend tell", false);
    }

    public static void main(String[] args) throws IdeScriptException {
        AppleScript.kill("iPhone Simulator", false);
    }

    @NonNls
    private static String forEach(@NonNls String listVar, @NonNls String itVar, @NonNls String closure) {
        return "repeat with " + itVar + " in " + listVar + "\n " + closure + "\nend repeat\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePathToOpen", "com/jetbrains/cidr/AppleScript", "openFileInXcode"));
    }
}

