/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.customization;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.ide.impl.customization.BaseJetBrainsExternalProductResourceUrls;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010&\u001a\u00020\u0012H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR1\u0010\u001f\u001a\u001f\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001eR\u0016\u0010$\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\b\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/customization/RiderExternalResourceUrlsBase;", "Lcom/intellij/platform/ide/impl/customization/BaseJetBrainsExternalProductResourceUrls;", "<init>", "()V", "productPageUrl", "Lcom/intellij/util/Url;", "Lorg/jetbrains/annotations/NotNull;", "getProductPageUrl", "()Lcom/intellij/util/Url;", "basePatchDownloadUrl", "getBasePatchDownloadUrl", "baseWebHelpUrl", "getBaseWebHelpUrl", "youTubeChannelUrl", "getYouTubeChannelUrl", "keyboardShortcutsPdfUrl", "getKeyboardShortcutsPdfUrl", "youtrackProjectId", "", "getYoutrackProjectId", "()Ljava/lang/String;", "shortProductNameUsedInForms", "getShortProductNameUsedInForms", "intellijSupportFormId", "", "getIntellijSupportFormId", "()I", "bugReportUrl", "Lkotlin/Function1;", "getBugReportUrl", "()Lkotlin/jvm/functions/Function1;", "technicalSupportUrl", "Lkotlin/ParameterName;", "name", "description", "getTechnicalSupportUrl", "whatIsNewPageUrl", "getWhatIsNewPageUrl", "getOsWithDistro", "getLinuxDistroId", "intellij.rider.customization"})
public class RiderExternalResourceUrlsBase
extends BaseJetBrainsExternalProductResourceUrls {
    @NotNull
    private final Url productPageUrl;
    @NotNull
    private final Url basePatchDownloadUrl;
    @NotNull
    private final Url baseWebHelpUrl;
    @NotNull
    private final Url youTubeChannelUrl;
    @NotNull
    private final Url keyboardShortcutsPdfUrl;
    @NotNull
    private final String youtrackProjectId;
    @NotNull
    private final String shortProductNameUsedInForms;
    private final int intellijSupportFormId;
    @Nullable
    private final Url whatIsNewPageUrl;

    public RiderExternalResourceUrlsBase() {
        Url url = this.getBaseWebSiteUrl().resolve("rider/");
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
        this.productPageUrl = url;
        this.basePatchDownloadUrl = Urls.newFromEncoded((String)"https://download.jetbrains.com/rider/");
        Url url2 = this.getBaseWebSiteUrl().resolve("help/rider");
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"resolve(...)");
        this.baseWebHelpUrl = url2;
        this.youTubeChannelUrl = Urls.newFromEncoded((String)"https://www.youtube.com/playlist?list=PLQ176FUIyIUY8gxZkEYRa0SM8JyFsUT1v");
        Url url3 = this.getBaseWebSiteUrl().resolve("rider/documentation/#keyboardShortcuts");
        Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"resolve(...)");
        this.keyboardShortcutsPdfUrl = url3;
        this.youtrackProjectId = "RIDER";
        this.shortProductNameUsedInForms = "RIDER";
        this.intellijSupportFormId = 97145;
    }

    @NotNull
    public Url getProductPageUrl() {
        return this.productPageUrl;
    }

    @NotNull
    public Url getBasePatchDownloadUrl() {
        return this.basePatchDownloadUrl;
    }

    @NotNull
    public Url getBaseWebHelpUrl() {
        return this.baseWebHelpUrl;
    }

    @NotNull
    public Url getYouTubeChannelUrl() {
        return this.youTubeChannelUrl;
    }

    @NotNull
    public Url getKeyboardShortcutsPdfUrl() {
        return this.keyboardShortcutsPdfUrl;
    }

    @NotNull
    public String getYoutrackProjectId() {
        return this.youtrackProjectId;
    }

    @NotNull
    public String getShortProductNameUsedInForms() {
        return this.shortProductNameUsedInForms;
    }

    public int getIntellijSupportFormId() {
        return this.intellijSupportFormId;
    }

    @Nullable
    public Function1<String, Url> getBugReportUrl() {
        return arg_0 -> RiderExternalResourceUrlsBase._get_bugReportUrl_$lambda$0(this, arg_0);
    }

    @Nullable
    public Function1<String, Url> getTechnicalSupportUrl() {
        return arg_0 -> RiderExternalResourceUrlsBase._get_technicalSupportUrl_$lambda$0(this, arg_0);
    }

    @Nullable
    public Url getWhatIsNewPageUrl() {
        return this.whatIsNewPageUrl;
    }

    private final String getOsWithDistro() {
        return SystemInfo.isWindows ? "ij_win" : (SystemInfo.isLinux ? this.getLinuxDistroId() : (SystemInfo.isMac ? "ij_mac" : "ij_other-os"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getLinuxDistroId() {
        try {
            AutoCloseable autoCloseable = Files.lines(Path.of("/etc/os-release", new String[0]));
            Throwable throwable = null;
            try {
                Stream lines = (Stream)autoCloseable;
                boolean bl = false;
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    String line = (String)iterator.next();
                    Intrinsics.checkNotNull((Object)line);
                    char[] cArray = new char[]{'='};
                    List parts = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    if (parts.size() != 2 || !StringsKt.equals((String)((String)parts.get(0)), (String)"id", (boolean)true)) continue;
                    String id = ((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
                    String string = StringsKt.equals((String)id, (String)"ubuntu", (boolean)true) ? "ij_ubuntu" : (StringsKt.equals((String)id, (String)"fedora", (boolean)true) ? "ij_fedora" : "ij_linux");
                    return string;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "ij_linux";
    }

    private static final Url _get_bugReportUrl_$lambda$0(RiderExternalResourceUrlsBase this$0, String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"project", (Object)this$0.getYoutrackProjectId()), TuplesKt.to((Object)"clearDraft", (Object)"true"), TuplesKt.to((Object)"description", (Object)description)};
        return Urls.newFromEncoded((String)"https://youtrack.jetbrains.com/newissue").addParameters(MapsKt.mapOf((Pair[])pairArray));
    }

    private static final Url _get_technicalSupportUrl_$lambda$0(RiderExternalResourceUrlsBase this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ticket_form_id", (Object)String.valueOf(this$0.getIntellijSupportFormId())), TuplesKt.to((Object)"product", (Object)this$0.getShortProductNameUsedInForms()), TuplesKt.to((Object)"build", (Object)appInfo.getBuild().asStringWithoutProductCode()), TuplesKt.to((Object)"os", (Object)this$0.getOsWithDistro()), TuplesKt.to((Object)"timezone", (Object)System.getProperty("user.timezone")), TuplesKt.to((Object)"version", (Object)appInfo.getFullVersion())};
        return Urls.newFromEncoded((String)"https://rider-support.jetbrains.com/hc/en-us/requests/new").addParameters(MapsKt.mapOf((Pair[])pairArray));
    }
}

