/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003!\"#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J.\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J0\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\f\u001a\u00020\nH\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u001e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u000e\u0010 \u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "countTags", "", "", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "text", "tagsToCount", "", "switchTag", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$FixTagsResult;", "tagInfo", "tagName", "fixTagPair", "tagsToProcess", "fixTagMix", "tag1Name", "tagInfo1", "tag2Name", "tagInfo2", "getEditTags", "updateMainTagsState", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$MainTagsState;", "mainTags", "fixSubTags", "innerContent", "fixXMLTags", "TagInfo", "MainTagsState", "FixTagsResult", "core"})
@SourceDebugExtension(value={"SMAP\nTagParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagParsingUtils.kt\ncom/intellij/ml/llm/matterhorn/utils/TagParsingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,281:1\n1279#2,2:282\n1293#2,4:284\n774#2:296\n865#2,2:297\n1#3:288\n535#4:289\n520#4,6:290\n*S KotlinDebug\n*F\n+ 1 TagParsingUtils.kt\ncom/intellij/ml/llm/matterhorn/utils/TagParsingUtils\n*L\n38#1:282,2\n38#1:284,4\n179#1:296\n179#1:297,2\n144#1:289\n144#1:290,6\n*E\n"})
public final class TagParsingUtils {
    @NotNull
    public static final TagParsingUtils INSTANCE = new TagParsingUtils();
    @NotNull
    private static final Logger logger;

    private TagParsingUtils() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, TagInfo> countTags(String text, List<String> tagsToCount) {
        Iterable $this$associateWith$iv = tagsToCount;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void tag;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Regex openTagRegex = new Regex("(?<!`)<" + (String)tag + ">");
            Regex closeTagRegex = new Regex("(?<!`)</" + (String)tag + ">");
            List openIndices = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)openTagRegex, (CharSequence)text, (int)0, (int)2, null), TagParsingUtils::countTags$lambda$2$lambda$0));
            List closeIndices = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)closeTagRegex, (CharSequence)text, (int)0, (int)2, null), TagParsingUtils::countTags$lambda$2$lambda$1));
            TagInfo tagInfo = new TagInfo(tag.length(), openIndices, closeIndices);
            map.put(t, tagInfo);
        }
        return result$iv;
    }

    private final FixTagsResult switchTag(TagInfo tagInfo, String text, String tagName) {
        FixTagsResult fixTagsResult;
        int closeTagPos;
        int openTagPos = ((Number)CollectionsKt.first(tagInfo.getOpenIndices())).intValue();
        if (openTagPos > (closeTagPos = ((Number)CollectionsKt.first(tagInfo.getCloseIndices())).intValue()) && tagInfo.getOpenCount() == 1) {
            int openTagLen = ("<" + tagName + ">").length();
            String string = text.substring(0, closeTagPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = text.substring(closeTagPos + openTagLen + 1, openTagPos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = text.substring(openTagPos + openTagLen);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            fixTagsResult = new FixTagsResult(string + "<" + tagName + ">" + string2 + "</" + tagName + ">" + string3, true);
        } else {
            fixTagsResult = new FixTagsResult(text, false);
        }
        return fixTagsResult;
    }

    private final FixTagsResult fixTagPair(String text, String tagName, TagInfo tagInfo, List<String> tagsToProcess) {
        FixTagsResult fixTagsResult;
        int tagLength = tagInfo.component1();
        List<Integer> openIndices = tagInfo.component2();
        List<Integer> closeIndices = tagInfo.component3();
        if (tagInfo.getOpenCount() == 2 && tagInfo.getCloseCount() == 0) {
            String string = text;
            int n = ((Number)openIndices.get(1)).intValue();
            int n2 = ((Number)openIndices.get(1)).intValue() + tagLength + 2;
            CharSequence charSequence = "</" + tagName + ">";
            FixTagsResult fixTagsResult2 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult2;
        } else if (tagInfo.getOpenCount() == 0 && tagInfo.getCloseCount() == 2) {
            String string = text;
            int n = ((Number)closeIndices.get(0)).intValue();
            int n3 = ((Number)closeIndices.get(0)).intValue() + tagLength + 3;
            CharSequence charSequence = "<" + tagName + ">";
            FixTagsResult fixTagsResult3 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n3, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult3;
        } else if (tagInfo.getOpenCount() == 1 && tagInfo.getCloseCount() == 0) {
            int n;
            Object nextTag;
            int tagIndex = tagsToProcess.indexOf(tagName);
            if (tagIndex < CollectionsKt.getLastIndex(tagsToProcess)) {
                nextTag = "<" + tagsToProcess.get(tagIndex + 1) + ">";
                Integer n4 = StringsKt.indexOf$default((CharSequence)text, (String)nextTag, (int)(((Number)openIndices.get(0)).intValue() + 1), (boolean)false, (int)4, null);
                int it = ((Number)n4).intValue();
                boolean bl = false;
                Integer n5 = it != -1 ? n4 : null;
                n = n5 != null ? n5.intValue() : text.length();
            } else {
                n = text.length();
            }
            int nextTagPos = n;
            nextTag = text;
            CharSequence charSequence = "</" + tagName + ">\n";
            FixTagsResult fixTagsResult4 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)((CharSequence)nextTag), (int)nextTagPos, (int)nextTagPos, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult4;
        } else if (tagInfo.getOpenCount() == 0 && tagInfo.getCloseCount() == 1) {
            int n;
            int tagIndex = tagsToProcess.indexOf(tagName);
            if (tagIndex > 0) {
                String prevTag = "</" + tagsToProcess.get(tagIndex - 1) + ">";
                Integer n6 = StringsKt.lastIndexOf$default((CharSequence)text, (String)prevTag, (int)((Number)closeIndices.get(0)).intValue(), (boolean)false, (int)4, null);
                int it = ((Number)n6).intValue();
                boolean bl = false;
                Integer n7 = it != -1 ? n6 : null;
                n = n7 != null ? n7 + prevTag.length() : 0;
            } else {
                n = 0;
            }
            int prevTagEndPos = n;
            String string = text;
            CharSequence charSequence = "\n<" + tagName + ">";
            FixTagsResult fixTagsResult5 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)prevTagEndPos, (int)prevTagEndPos, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult5;
        } else {
            fixTagsResult = tagInfo.getOpenCount() == 1 && tagInfo.getCloseCount() == 1 ? this.switchTag(tagInfo, text, tagName) : new FixTagsResult(text, false);
        }
        return fixTagsResult;
    }

    private final FixTagsResult fixTagMix(String text, String tag1Name, TagInfo tagInfo1, String tag2Name, TagInfo tagInfo2) {
        FixTagsResult fixTagsResult;
        int tagLength2 = tagInfo2.component1();
        List<Integer> openIndices2 = tagInfo2.component2();
        List<Integer> closeIndices2 = tagInfo2.component3();
        List<Integer> openIndices1 = tagInfo1.component2();
        if (((Number)openIndices2.get(0)).intValue() > ((Number)closeIndices2.get(0)).intValue() && ((Number)openIndices1.get(0)).intValue() < ((Number)closeIndices2.get(0)).intValue()) {
            String string = text;
            int n = ((Number)closeIndices2.get(0)).intValue();
            int n2 = ((Number)closeIndices2.get(0)).intValue() + tagLength2 + 3;
            CharSequence charSequence = "</" + tag1Name + ">";
            FixTagsResult fixTagsResult2 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult2;
        } else if (((Number)openIndices2.get(0)).intValue() < ((Number)closeIndices2.get(1)).intValue() && ((Number)openIndices1.get(0)).intValue() < ((Number)closeIndices2.get(1)).intValue()) {
            String string = text;
            int n = ((Number)closeIndices2.get(1)).intValue();
            int n3 = ((Number)closeIndices2.get(1)).intValue() + tagLength2 + 3;
            CharSequence charSequence = "</" + tag1Name + ">";
            FixTagsResult fixTagsResult3 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n3, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult3;
        } else {
            fixTagsResult = new FixTagsResult(text, false);
        }
        return fixTagsResult;
    }

    private final List<String> getEditTags(String text) {
        Regex editTagPattern = new Regex("</?EDIT(\\d{0,2})>");
        return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)editTagPattern, (CharSequence)text, (int)0, (int)2, null), TagParsingUtils::getEditTags$lambda$5))));
    }

    private final MainTagsState updateMainTagsState(String text, List<String> mainTags) {
        Map<String, TagInfo> tagInfos = this.countTags(text, mainTags);
        return new MainTagsState(tagInfos, tagInfos.get("UPDATE"), tagInfos.get("COMMAND"));
    }

    /*
     * WARNING - void declaration
     */
    private final FixTagsResult fixSubTags(String innerContent, List<String> tagsToProcess) {
        void $this$filterTo$iv$iv;
        Map<String, TagInfo> tagInfos;
        Map<String, TagInfo> $this$filter$iv = tagInfos = this.countTags(innerContent, tagsToProcess);
        boolean $i$f$filter = false;
        Map<String, TagInfo> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((TagInfo)it.getValue()).getOpenCount() != ((TagInfo)it.getValue()).getCloseCount() || ((TagInfo)it.getValue()).getOpenCount() == 1 && ((Number)CollectionsKt.first(((TagInfo)it.getValue()).getOpenIndices())).intValue() > ((Number)CollectionsKt.first(((TagInfo)it.getValue()).getCloseIndices())).intValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map tagsToFix = destination$iv$iv;
        if (tagsToFix.isEmpty() || tagsToFix.size() > 2) {
            return new FixTagsResult(innerContent, false);
        }
        if (tagsToFix.size() == 2) {
            Map.Entry firstTag = (Map.Entry)CollectionsKt.first((Iterable)tagsToFix.entrySet());
            Map.Entry secondTag = (Map.Entry)CollectionsKt.last((Iterable)tagsToFix.entrySet());
            return ((TagInfo)firstTag.getValue()).getOpenCount() == 1 && ((TagInfo)firstTag.getValue()).getCloseCount() == 0 && ((TagInfo)secondTag.getValue()).getOpenCount() == 1 && ((TagInfo)secondTag.getValue()).getCloseCount() == 2 ? this.fixTagMix(innerContent, (String)firstTag.getKey(), (TagInfo)firstTag.getValue(), (String)secondTag.getKey(), (TagInfo)secondTag.getValue()) : (((TagInfo)firstTag.getValue()).getOpenCount() == 1 && ((TagInfo)firstTag.getValue()).getCloseCount() == 2 && ((TagInfo)secondTag.getValue()).getOpenCount() == 1 && ((TagInfo)secondTag.getValue()).getCloseCount() == 0 ? this.fixTagMix(innerContent, (String)secondTag.getKey(), (TagInfo)secondTag.getValue(), (String)firstTag.getKey(), (TagInfo)firstTag.getValue()) : new FixTagsResult(innerContent, false));
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)tagsToFix.entrySet());
        String tagName = (String)entry.getKey();
        TagInfo tagInfo = (TagInfo)entry.getValue();
        return this.fixTagPair(innerContent, tagName, tagInfo, tagsToProcess);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String fixXMLTags(@NotNull String text) {
        FixTagsResult result2;
        Object trimmedText;
        FixTagsResult result3;
        Object object;
        int $i$f$filter;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object[] objectArray = new String[]{"UPDATE", "COMMAND"};
        List mainTags = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"PREVIOUS_STEP", "PLAN", "NEXT_STEP"};
        List thoughtSubTags = CollectionsKt.listOf((Object[])objectArray2);
        Object[] objectArray3 = new String[]{"FILE_PATH", "SEARCH", "REPLACE"};
        List editSubTags = CollectionsKt.listOf((Object[])objectArray3);
        Object newText = text;
        MainTagsState state = this.updateMainTagsState((String)newText, mainTags);
        if (state.getCommandInfo() != null && state.getCommandInfo().getOpenCount() > 0) {
            Iterable iterable;
            int firstCommandPos = ((Number)CollectionsKt.first(state.getCommandInfo().getOpenIndices())).intValue();
            Collection collection = CollectionsKt.drop((Iterable)state.getCommandInfo().getOpenIndices(), (int)1);
            Object object2 = state.getThoughtInfo();
            if (object2 != null && (object2 = ((TagInfo)object2).getOpenIndices()) != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable2 = (Iterable)object2;
                Collection collection2 = collection;
                $i$f$filter = 0;
                object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(it > firstCommandPos)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = collection2;
                iterable = (List)destination$iv$iv;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            Integer secondCommandPos = (Integer)CollectionsKt.minOrNull((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)iterable));
            if (secondCommandPos != null) {
                int n = secondCommandPos;
                String string = ((String)newText).substring(0, n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                newText = ((Object)StringsKt.trim((CharSequence)string)).toString();
                state = this.updateMainTagsState((String)newText, mainTags);
                logger.warn("TAGS FIXED: removed second commands");
            }
        }
        if (state.getThoughtInfo() != null && state.getThoughtInfo().getOpenCount() == 2 && state.getThoughtInfo().getCloseCount() == 0 && (result3 = this.fixTagPair((String)newText, "UPDATE", state.getThoughtInfo(), mainTags)).getChanged()) {
            newText = result3.getContent();
            state = this.updateMainTagsState((String)newText, mainTags);
            logger.warn("TAGS FIXED: closing THOUGHT_TAG");
        }
        if (state.getCommandInfo() != null && state.getCommandInfo().getOpenCount() > 0 && state.getCommandInfo().getCloseCount() == 0) {
            Object object3;
            boolean commandCloseBad = StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString(), (String)"</COMMAND", (boolean)false, (int)2, null);
            if (commandCloseBad) {
                object3 = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString() + ">";
            } else {
                boolean commandCloseBySearch = StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString(), (String)"</SEARCH>", (boolean)false, (int)2, null);
                boolean commandCloseByReplace = StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString(), (String)"</REPLACE>", (boolean)false, (int)2, null);
                if (commandCloseBySearch) {
                    trimmedText = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString();
                    String string = trimmedText;
                    int $this$filter$iv = ((String)trimmedText).length() - 9;
                    $i$f$filter = ((String)trimmedText).length();
                    object = "</COMMAND>";
                    object3 = ((Object)StringsKt.replaceRange((CharSequence)string, (int)$this$filter$iv, (int)$i$f$filter, (CharSequence)object)).toString();
                } else if (commandCloseByReplace) {
                    trimmedText = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString();
                    String string = trimmedText;
                    int $this$filter$iv = ((String)trimmedText).length() - 10;
                    $i$f$filter = ((String)trimmedText).length();
                    object = "</COMMAND>";
                    object3 = ((Object)StringsKt.replaceRange((CharSequence)string, (int)$this$filter$iv, (int)$i$f$filter, (CharSequence)object)).toString();
                } else {
                    object3 = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString() + "\n</COMMAND>";
                }
            }
            newText = object3;
            state = this.updateMainTagsState((String)newText, mainTags);
            logger.warn("TAGS FIXED: closing COMMAND_TAG");
        }
        if (state.getThoughtInfo() != null && state.getThoughtInfo().getOpenCount() == 1 && state.getThoughtInfo().getCloseCount() == 1 && (result2 = this.switchTag(state.getThoughtInfo(), (String)newText, "UPDATE")).getChanged()) {
            newText = result2.getContent();
            state = this.updateMainTagsState((String)newText, mainTags);
            logger.warn("TAGS FIXED: switched THOUGHT_TAGs");
        }
        if (state.getThoughtInfo() != null && state.getThoughtInfo().getOpenCount() > 0 && state.getThoughtInfo().getCloseCount() > 0) {
            int thoughtStartContent = ((Number)CollectionsKt.first(state.getThoughtInfo().getOpenIndices())).intValue() + 6 + 2;
            int thoughtEndContent = ((Number)CollectionsKt.first(state.getThoughtInfo().getCloseIndices())).intValue();
            if (thoughtEndContent > thoughtStartContent) {
                String string = ((String)newText).substring(thoughtStartContent, thoughtEndContent);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                FixTagsResult fixResult = this.fixSubTags(string, thoughtSubTags);
                if (fixResult.getChanged()) {
                    trimmedText = newText;
                    CharSequence charSequence = fixResult.getContent();
                    newText = ((Object)StringsKt.replaceRange((CharSequence)((CharSequence)trimmedText), (int)thoughtStartContent, (int)thoughtEndContent, (CharSequence)charSequence)).toString();
                    state = this.updateMainTagsState((String)newText, mainTags);
                    logger.warn("TAGS FIXED: THOUGHT SUB_TAGs");
                }
            }
        }
        boolean commandContentChanged = false;
        if (state.getCommandInfo() != null && state.getCommandInfo().getOpenCount() > 0 && state.getCommandInfo().getCloseCount() > 0) {
            int commandStartContent = ((Number)CollectionsKt.first(state.getCommandInfo().getOpenIndices())).intValue() + 7 + 2;
            int commandEndContent = ((Number)CollectionsKt.first(state.getCommandInfo().getCloseIndices())).intValue();
            if (commandEndContent > commandStartContent) {
                String string = ((String)newText).substring(commandStartContent, commandEndContent);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String commandContent = string;
                List<String> editTags = this.getEditTags(commandContent);
                if (!((Collection)editTags).isEmpty()) {
                    FixTagsResult fixResult = this.fixSubTags(commandContent, editTags);
                    if (fixResult.getChanged()) {
                        commandContent = fixResult.getContent();
                        commandContentChanged = true;
                    }
                    Map<String, TagInfo> editTagsInfos = this.countTags(commandContent, editTags);
                    for (String editTag : editTags) {
                        String editContent;
                        TagInfo tagInfo;
                        if (editTagsInfos.get(editTag) == null || tagInfo.getOpenCount() <= 0 || tagInfo.getCloseCount() <= 0) continue;
                        int editStartContent = ((Number)CollectionsKt.first(tagInfo.getOpenIndices())).intValue() + editTag.length() + 2;
                        int editEndContent = ((Number)CollectionsKt.first(tagInfo.getCloseIndices())).intValue();
                        Intrinsics.checkNotNullExpressionValue((Object)commandContent.substring(editStartContent, editEndContent), (String)"substring(...)");
                        FixTagsResult fixResult2 = this.fixSubTags(editContent, editSubTags);
                        if (!fixResult2.getChanged()) continue;
                        String string2 = commandContent;
                        CharSequence charSequence = fixResult2.getContent();
                        commandContent = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)editStartContent, (int)editEndContent, (CharSequence)charSequence)).toString();
                        editTagsInfos = this.countTags(commandContent, editTags);
                        commandContentChanged = true;
                    }
                }
                if (commandContentChanged) {
                    newText = ((Object)StringsKt.replaceRange((CharSequence)((CharSequence)newText), (int)commandStartContent, (int)commandEndContent, (CharSequence)commandContent)).toString();
                    logger.warn("TAGS FIXED: EDIT");
                }
            }
        }
        return newText;
    }

    private static final int countTags$lambda$2$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange().getFirst();
    }

    private static final int countTags$lambda$2$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange().getFirst();
    }

    private static final String getEditTags$lambda$5(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return "EDIT" + matchResult.getGroupValues().get(1);
    }

    static {
        Logger logger = LoggerFactory.getLogger(TagParsingUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        TagParsingUtils.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$FixTagsResult;", "", "content", "", "changed", "", "<init>", "(Ljava/lang/String;Z)V", "getContent", "()Ljava/lang/String;", "getChanged", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "core"})
    private static final class FixTagsResult {
        @NotNull
        private final String content;
        private final boolean changed;

        public FixTagsResult(@NotNull String content, boolean changed) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.changed = changed;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final boolean getChanged() {
            return this.changed;
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        public final boolean component2() {
            return this.changed;
        }

        @NotNull
        public final FixTagsResult copy(@NotNull String content, boolean changed) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new FixTagsResult(content, changed);
        }

        public static /* synthetic */ FixTagsResult copy$default(FixTagsResult fixTagsResult, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = fixTagsResult.content;
            }
            if ((n & 2) != 0) {
                bl = fixTagsResult.changed;
            }
            return fixTagsResult.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "FixTagsResult(content=" + this.content + ", changed=" + this.changed + ")";
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.changed);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixTagsResult)) {
                return false;
            }
            FixTagsResult fixTagsResult = (FixTagsResult)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)fixTagsResult.content)) {
                return false;
            }
            return this.changed == fixTagsResult.changed;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$MainTagsState;", "", "tagInfos", "", "", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "thoughtInfo", "commandInfo", "<init>", "(Ljava/util/Map;Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;)V", "getTagInfos", "()Ljava/util/Map;", "getThoughtInfo", "()Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "getCommandInfo", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class MainTagsState {
        @NotNull
        private final Map<String, TagInfo> tagInfos;
        @Nullable
        private final TagInfo thoughtInfo;
        @Nullable
        private final TagInfo commandInfo;

        public MainTagsState(@NotNull Map<String, TagInfo> tagInfos, @Nullable TagInfo thoughtInfo, @Nullable TagInfo commandInfo) {
            Intrinsics.checkNotNullParameter(tagInfos, (String)"tagInfos");
            this.tagInfos = tagInfos;
            this.thoughtInfo = thoughtInfo;
            this.commandInfo = commandInfo;
        }

        @NotNull
        public final Map<String, TagInfo> getTagInfos() {
            return this.tagInfos;
        }

        @Nullable
        public final TagInfo getThoughtInfo() {
            return this.thoughtInfo;
        }

        @Nullable
        public final TagInfo getCommandInfo() {
            return this.commandInfo;
        }

        @NotNull
        public final Map<String, TagInfo> component1() {
            return this.tagInfos;
        }

        @Nullable
        public final TagInfo component2() {
            return this.thoughtInfo;
        }

        @Nullable
        public final TagInfo component3() {
            return this.commandInfo;
        }

        @NotNull
        public final MainTagsState copy(@NotNull Map<String, TagInfo> tagInfos, @Nullable TagInfo thoughtInfo, @Nullable TagInfo commandInfo) {
            Intrinsics.checkNotNullParameter(tagInfos, (String)"tagInfos");
            return new MainTagsState(tagInfos, thoughtInfo, commandInfo);
        }

        public static /* synthetic */ MainTagsState copy$default(MainTagsState mainTagsState, Map map, TagInfo tagInfo, TagInfo tagInfo2, int n, Object object) {
            if ((n & 1) != 0) {
                map = mainTagsState.tagInfos;
            }
            if ((n & 2) != 0) {
                tagInfo = mainTagsState.thoughtInfo;
            }
            if ((n & 4) != 0) {
                tagInfo2 = mainTagsState.commandInfo;
            }
            return mainTagsState.copy(map, tagInfo, tagInfo2);
        }

        @NotNull
        public String toString() {
            return "MainTagsState(tagInfos=" + this.tagInfos + ", thoughtInfo=" + this.thoughtInfo + ", commandInfo=" + this.commandInfo + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.tagInfos).hashCode();
            result2 = result2 * 31 + (this.thoughtInfo == null ? 0 : this.thoughtInfo.hashCode());
            result2 = result2 * 31 + (this.commandInfo == null ? 0 : this.commandInfo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MainTagsState)) {
                return false;
            }
            MainTagsState mainTagsState = (MainTagsState)other;
            if (!Intrinsics.areEqual(this.tagInfos, mainTagsState.tagInfos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.thoughtInfo, (Object)mainTagsState.thoughtInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.commandInfo, (Object)mainTagsState.commandInfo);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "", "tagLength", "", "openIndices", "", "closeIndices", "<init>", "(ILjava/util/List;Ljava/util/List;)V", "getTagLength", "()I", "getOpenIndices", "()Ljava/util/List;", "getCloseIndices", "openCount", "getOpenCount", "closeCount", "getCloseCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class TagInfo {
        private final int tagLength;
        @NotNull
        private final List<Integer> openIndices;
        @NotNull
        private final List<Integer> closeIndices;

        public TagInfo(int tagLength, @NotNull List<Integer> openIndices, @NotNull List<Integer> closeIndices) {
            Intrinsics.checkNotNullParameter(openIndices, (String)"openIndices");
            Intrinsics.checkNotNullParameter(closeIndices, (String)"closeIndices");
            this.tagLength = tagLength;
            this.openIndices = openIndices;
            this.closeIndices = closeIndices;
        }

        public final int getTagLength() {
            return this.tagLength;
        }

        @NotNull
        public final List<Integer> getOpenIndices() {
            return this.openIndices;
        }

        @NotNull
        public final List<Integer> getCloseIndices() {
            return this.closeIndices;
        }

        public final int getOpenCount() {
            return this.openIndices.size();
        }

        public final int getCloseCount() {
            return this.closeIndices.size();
        }

        public final int component1() {
            return this.tagLength;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.openIndices;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.closeIndices;
        }

        @NotNull
        public final TagInfo copy(int tagLength, @NotNull List<Integer> openIndices, @NotNull List<Integer> closeIndices) {
            Intrinsics.checkNotNullParameter(openIndices, (String)"openIndices");
            Intrinsics.checkNotNullParameter(closeIndices, (String)"closeIndices");
            return new TagInfo(tagLength, openIndices, closeIndices);
        }

        public static /* synthetic */ TagInfo copy$default(TagInfo tagInfo, int n, List list, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = tagInfo.tagLength;
            }
            if ((n2 & 2) != 0) {
                list = tagInfo.openIndices;
            }
            if ((n2 & 4) != 0) {
                list2 = tagInfo.closeIndices;
            }
            return tagInfo.copy(n, list, list2);
        }

        @NotNull
        public String toString() {
            return "TagInfo(tagLength=" + this.tagLength + ", openIndices=" + this.openIndices + ", closeIndices=" + this.closeIndices + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.tagLength);
            result2 = result2 * 31 + ((Object)this.openIndices).hashCode();
            result2 = result2 * 31 + ((Object)this.closeIndices).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TagInfo)) {
                return false;
            }
            TagInfo tagInfo = (TagInfo)other;
            if (this.tagLength != tagInfo.tagLength) {
                return false;
            }
            if (!Intrinsics.areEqual(this.openIndices, tagInfo.openIndices)) {
                return false;
            }
            return Intrinsics.areEqual(this.closeIndices, tagInfo.closeIndices);
        }
    }
}

