/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import com.intellij.ml.llm.matterhorn.utils.StringUtilsKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/SystemUtils;", "", "<init>", "()V", "OS_NAME", "", "OS_VERSION", "_OS_NAME", "isWindows", "", "()Z", "isMac", "isLinux", "isFreeBSD", "isSolaris", "isUnix", "isXWindow", "isFileSystemCaseSensitive", "isOsVersionAtLeast", "version", "isWin8OrNewer", "isWin10OrNewer", "isWin11OrNewer", "core"})
public final class SystemUtils {
    @NotNull
    public static final SystemUtils INSTANCE;
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;
    @NotNull
    private static final String _OS_NAME;
    private static final boolean isWindows;
    private static final boolean isMac;
    private static final boolean isLinux;
    private static final boolean isFreeBSD;
    private static final boolean isSolaris;
    private static final boolean isUnix;
    private static final boolean isXWindow;
    private static final boolean isFileSystemCaseSensitive;
    private static final boolean isWin8OrNewer;
    private static final boolean isWin10OrNewer;
    private static final boolean isWin11OrNewer;

    private SystemUtils() {
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isMac() {
        return isMac;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isFreeBSD() {
        return isFreeBSD;
    }

    public final boolean isSolaris() {
        return isSolaris;
    }

    public final boolean isUnix() {
        return isUnix;
    }

    public final boolean isXWindow() {
        return isXWindow;
    }

    public final boolean isFileSystemCaseSensitive() {
        return isFileSystemCaseSensitive;
    }

    public final boolean isOsVersionAtLeast(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return StringUtilsKt.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public final boolean isWin8OrNewer() {
        return isWin8OrNewer;
    }

    public final boolean isWin10OrNewer() {
        return isWin10OrNewer;
    }

    public final boolean isWin11OrNewer() {
        return isWin11OrNewer;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static {
        block9: {
            SystemUtils.INSTANCE = new SystemUtils();
            name = System.getProperty("os.name");
            v0 = System.getProperty("os.version");
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProperty(...)");
            v1 = v0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            version = v1;
            var2_2 /* !! */  = name;
            Intrinsics.checkNotNull((Object)var2_2 /* !! */ );
            if (StringsKt.startsWith$default((String)var2_2 /* !! */ , (String)"Windows", (boolean)false, (int)2, null)) {
                var2_2 /* !! */  = name;
                Intrinsics.checkNotNull((Object)var2_2 /* !! */ );
                var2_2 /* !! */  = var2_2 /* !! */ ;
                if (new Regex("Windows \\d+").matches((CharSequence)var2_2 /* !! */ )) {
                    try {
                        var3_4 = name;
                        Intrinsics.checkNotNull((Object)var3_4);
                        var4_5 = 8;
                        v2 = var3_4.substring(var4_5);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                        version2 = v2 + ".0";
                        if (Float.parseFloat(version2) > Float.parseFloat((String)version)) {
                            version = version2;
                        }
                    }
                    catch (NumberFormatException var2_3) {
                        // empty catch block
                    }
                    name = "Windows";
                }
            }
            SystemUtils.OS_NAME = name;
            SystemUtils.OS_VERSION = version;
            v3 = SystemUtils.OS_NAME.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
            SystemUtils._OS_NAME = v3;
            SystemUtils.isWindows = StringsKt.startsWith$default((String)SystemUtils._OS_NAME, (String)"windows", (boolean)false, (int)2, null);
            SystemUtils.isMac = StringsKt.startsWith$default((String)SystemUtils._OS_NAME, (String)"mac", (boolean)false, (int)2, null);
            SystemUtils.isLinux = StringsKt.startsWith$default((String)SystemUtils._OS_NAME, (String)"linux", (boolean)false, (int)2, null);
            SystemUtils.isFreeBSD = StringsKt.startsWith$default((String)SystemUtils._OS_NAME, (String)"freebsd", (boolean)false, (int)2, null);
            SystemUtils.isSolaris = StringsKt.startsWith$default((String)SystemUtils._OS_NAME, (String)"sunos", (boolean)false, (int)2, null);
            SystemUtils.isUnix = SystemUtils.isWindows == false;
            if (!SystemUtils.isUnix) ** GOTO lbl-1000
            if (!SystemUtils.isMac) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            SystemUtils.isXWindow = v4;
            if (!SystemUtils.isUnix) break block9;
            if (!SystemUtils.isMac) ** GOTO lbl-1000
        }
        if (StringsKt.equals((String)"true", (String)System.getProperty("idea.case.sensitive.fs"), (boolean)true)) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = false;
        }
        SystemUtils.isFileSystemCaseSensitive = v5;
        SystemUtils.isWin8OrNewer = SystemUtils.isWindows != false && SystemUtils.INSTANCE.isOsVersionAtLeast("6.2") != false;
        SystemUtils.isWin10OrNewer = SystemUtils.isWindows != false && SystemUtils.INSTANCE.isOsVersionAtLeast("10.0") != false;
        SystemUtils.isWin11OrNewer = SystemUtils.isWindows != false && SystemUtils.INSTANCE.isOsVersionAtLeast("11.0") != false;
    }
}

