/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\u001c\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001\u001a\"\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ELLIPSIS", "", "normalizeLineEndings", "trimMiddle", "maxLength", "", "useEllipsisSymbol", "", "shortenTextWithEllipsis", "suffixLength", "symbol", "shortenPathWithEllipsis", "compareVersionNumbers", "v1", "v2", "core"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\ncom/intellij/ml/llm/matterhorn/utils/StringUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n739#2,9:100\n739#2,9:113\n37#3:109\n36#3,3:110\n37#3:122\n36#3,3:123\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\ncom/intellij/ml/llm/matterhorn/utils/StringUtilsKt\n*L\n64#1:100,9\n65#1:113,9\n64#1:109\n64#1:110,3\n65#1:122\n65#1:123,3\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    public static final String ELLIPSIS = "\u2026";

    @NotNull
    public static final String normalizeLineEndings(@NotNull String $this$normalizeLineEndings) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeLineEndings, (String)"<this>");
        return StringsKt.replace$default((String)$this$normalizeLineEndings, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String trimMiddle(@NotNull String $this$trimMiddle, int maxLength, boolean useEllipsisSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMiddle, (String)"<this>");
        return StringUtilsKt.shortenTextWithEllipsis($this$trimMiddle, maxLength, maxLength >> 1, useEllipsisSymbol);
    }

    public static /* synthetic */ String trimMiddle$default(String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return StringUtilsKt.trimMiddle(string, n, bl);
    }

    @NotNull
    public static final String shortenTextWithEllipsis(@NotNull String $this$shortenTextWithEllipsis, int maxLength, int suffixLength) {
        Intrinsics.checkNotNullParameter((Object)$this$shortenTextWithEllipsis, (String)"<this>");
        return StringUtilsKt.shortenTextWithEllipsis($this$shortenTextWithEllipsis, maxLength, suffixLength, false);
    }

    @NotNull
    public static final String trimMiddle(@NotNull String $this$trimMiddle, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMiddle, (String)"<this>");
        return StringUtilsKt.shortenTextWithEllipsis($this$trimMiddle, maxLength, maxLength >> 1, true);
    }

    @NotNull
    public static final String shortenTextWithEllipsis(@NotNull String $this$shortenTextWithEllipsis, int maxLength, int suffixLength, @NotNull String symbol) {
        Intrinsics.checkNotNullParameter((Object)$this$shortenTextWithEllipsis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        int textLength = $this$shortenTextWithEllipsis.length();
        if (textLength > maxLength) {
            boolean bl;
            int prefixLength = maxLength - suffixLength - symbol.length();
            boolean bl2 = bl = prefixLength >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = $this$shortenTextWithEllipsis.substring(0, prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = $this$shortenTextWithEllipsis.substring(textLength - suffixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + symbol + string2;
        }
        return $this$shortenTextWithEllipsis;
    }

    @NotNull
    public static final String shortenTextWithEllipsis(@NotNull String $this$shortenTextWithEllipsis, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$shortenTextWithEllipsis, (String)"<this>");
        String symbol = useEllipsisSymbol ? ELLIPSIS : "...";
        return StringUtilsKt.shortenTextWithEllipsis($this$shortenTextWithEllipsis, maxLength, suffixLength, symbol);
    }

    @NotNull
    public static final String shortenPathWithEllipsis(@NotNull String $this$shortenPathWithEllipsis, int maxLength, boolean useEllipsisSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$shortenPathWithEllipsis, (String)"<this>");
        return StringUtilsKt.shortenTextWithEllipsis($this$shortenPathWithEllipsis, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    public static final int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        List list2;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        CharSequence charSequence = v1;
        Regex regex = new Regex("[._\\-]");
        int n = 0;
        List $this$dropLastWhile$iv2 = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv2.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv2 = list2;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv2;
        String[] part1 = thisCollection$iv.toArray(new String[0]);
        Object $i$f$toTypedArray22 = v2;
        thisCollection$iv = new Regex("[._\\-]");
        int it = 0;
        $i$f$toTypedArray22 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray22, it);
        boolean $i$f$dropLastWhile2 = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it2 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it2).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        String[] part2 = thisCollection$iv2.toArray(new String[0]);
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = 0;
            CharSequence bl = p1;
            cmp = new Regex("\\d+").matches(bl) && new Regex("\\d+").matches(bl = (CharSequence)p2) ? Intrinsics.compare((int)Integer.parseInt(p1), (int)Integer.parseInt(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = 0;
                CharSequence charSequence2 = p;
                cmp = new Regex("\\d+").matches(charSequence2) ? Intrinsics.compare((int)Integer.parseInt(p), (int)0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }
}

