/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import com.intellij.ml.llm.matterhorn.utils.JsonSchemaBuilder;
import com.intellij.ml.llm.matterhorn.utils.JsonSchemaElement;
import com.networknt.schema.JsonSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\u001a\u001f\u0010\u0004\u001a\u00020\u0005\"\u0006\b\u0000\u0010\u0006\u0018\u0001*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u001a0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000fH\u0002\u001a\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"schemaCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement;", "jsonSchemaOf", "Lcom/networknt/schema/JsonSchema;", "T", "Lkotlinx/serialization/json/Json;", "schemaUri", "Ljava/net/URI;", "buildJsonSchema", "Lkotlin/Pair;", "", "descriptor", "pendingSchemas", "", "jsonSchemaElementOf", "core"})
@SourceDebugExtension(value={"SMAP\nJsonSchemaElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaElement.kt\ncom/intellij/ml/llm/matterhorn/utils/JsonSchemaElementKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
public final class JsonSchemaElementKt {
    @NotNull
    private static final ConcurrentHashMap<SerialDescriptor, JsonSchemaElement> schemaCache = new ConcurrentHashMap();

    @ApiStatus.Experimental
    public static final /* synthetic */ <T> JsonSchema jsonSchemaOf(Json $this$jsonSchemaOf, URI schemaUri) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonSchemaOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schemaUri, (String)"schemaUri");
        boolean $i$f$jsonSchemaOf = false;
        SerializersModule serializersModule = $this$jsonSchemaOf.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return JsonSchemaElementKt.jsonSchemaOf($this$jsonSchemaOf, schemaUri, SerializersKt.serializer((SerializersModule)serializersModule, null).getDescriptor());
    }

    public static /* synthetic */ JsonSchema jsonSchemaOf$default(Json $this$jsonSchemaOf_u24default, URI schemaUri, int n, Object object) {
        if ((n & 1) != 0) {
            String string;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string2 = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            schemaUri = new URI("https://matterhorn.ai/" + string);
        }
        Intrinsics.checkNotNullParameter((Object)$this$jsonSchemaOf_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schemaUri, (String)"schemaUri");
        boolean $i$f$jsonSchemaOf = false;
        object = $this$jsonSchemaOf_u24default.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return JsonSchemaElementKt.jsonSchemaOf($this$jsonSchemaOf_u24default, schemaUri, SerializersKt.serializer((SerializersModule)object, null).getDescriptor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Pair<JsonSchemaElement, Boolean> buildJsonSchema(SerialDescriptor descriptor, Map<SerialDescriptor, JsonSchemaElement> pendingSchemas) {
        JsonSchemaElement jsonSchemaElement;
        JsonSchemaElement jsonSchemaElement2 = schemaCache.get(descriptor);
        if (jsonSchemaElement2 != null) {
            JsonSchemaElement it = jsonSchemaElement2;
            return TuplesKt.to((Object)it, (Object)false);
        }
        jsonSchemaElement2 = pendingSchemas.get(descriptor);
        if (jsonSchemaElement2 != null) {
            JsonSchemaElement it = jsonSchemaElement2;
            return TuplesKt.to((Object)it, (Object)true);
        }
        boolean isPending = false;
        SerialKind it = descriptor.getKind();
        if (Intrinsics.areEqual((Object)it, (Object)StructureKind.MAP.INSTANCE)) {
            throw new IllegalArgumentException("Map types are not supported");
        }
        if (Intrinsics.areEqual((Object)it, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)StructureKind.OBJECT.INSTANCE)) {
            List props = new ArrayList();
            String it2 = descriptor.getSerialName();
            boolean bl = false;
            String name = StringsKt.substringAfterLast((String)it2, (char)'.', (String)it2);
            JsonSchemaElement.Object schema = new JsonSchemaElement.Object(name, props);
            pendingSchemas.put(descriptor, schema);
            int n = descriptor.getElementsCount();
            for (int i = 0; i < n; ++i) {
                String elementName = descriptor.getElementName(i);
                SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(i);
                Pair<JsonSchemaElement, Boolean> pair = JsonSchemaElementKt.buildJsonSchema(elementDescriptor, pendingSchemas);
                JsonSchemaElement elementSchema = (JsonSchemaElement)pair.component1();
                boolean elementPending = (Boolean)pair.component2();
                if (elementPending) {
                    isPending = true;
                }
                props.add(new JsonSchemaElement.Object.Property(elementName, elementSchema, descriptor.isElementOptional(i)));
            }
            boolean bl2 = isPending;
            if (bl2) {
                jsonSchemaElement = schema;
            } else {
                if (bl2) throw new NoWhenBranchMatchedException();
                pendingSchemas.remove(descriptor);
                jsonSchemaElement = schemaCache.putIfAbsent(descriptor, schema);
                if (jsonSchemaElement == null) {
                    jsonSchemaElement = schema;
                }
            }
        } else if (Intrinsics.areEqual((Object)it, (Object)StructureKind.LIST.INSTANCE)) {
            boolean itemPending;
            Pair<JsonSchemaElement, Boolean> pair = JsonSchemaElementKt.buildJsonSchema(descriptor.getElementDescriptor(0), pendingSchemas);
            JsonSchemaElement itemsSchema = (JsonSchemaElement)pair.component1();
            isPending = itemPending = ((Boolean)pair.component2()).booleanValue();
            jsonSchemaElement = new JsonSchemaElement.Array(itemsSchema);
        } else if (Intrinsics.areEqual((Object)it, (Object)SerialKind.ENUM.INSTANCE)) {
            jsonSchemaElement = new JsonSchemaElement.Enum(CollectionsKt.toList((Iterable)SerialDescriptorKt.getElementNames((SerialDescriptor)descriptor)));
        } else if (Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.BOOLEAN.INSTANCE)) {
            jsonSchemaElement = JsonSchemaElement.Boolean.INSTANCE;
        } else if (Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.BYTE.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.SHORT.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.INT.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.LONG.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.FLOAT.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.DOUBLE.INSTANCE)) {
            jsonSchemaElement = JsonSchemaElement.Number.INSTANCE;
        } else {
            if (!Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.CHAR.INSTANCE) && !Intrinsics.areEqual((Object)it, (Object)PrimitiveKind.STRING.INSTANCE)) throw new IllegalArgumentException("Unsupported descriptor kind: " + descriptor.getKind());
            jsonSchemaElement = JsonSchemaElement.String.INSTANCE;
        }
        JsonSchemaElement schema = jsonSchemaElement;
        JsonSchemaElement schemaWithNullability = descriptor.isNullable() ? (JsonSchemaElement)new JsonSchemaElement.Nullable(schema) : schema;
        return TuplesKt.to((Object)schemaWithNullability, (Object)isPending);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final JsonSchema jsonSchemaOf(@NotNull Json $this$jsonSchemaOf, @NotNull URI schemaUri, @NotNull SerialDescriptor descriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$jsonSchemaOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schemaUri, (String)"schemaUri");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        boolean bl2 = bl = !$this$jsonSchemaOf.getConfiguration().getIgnoreUnknownKeys();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsonSchemaElementKt$jsonSchemaOf$32 = false;
            String $i$a$-assert-JsonSchemaElementKt$jsonSchemaOf$32 = "ignoreUnknownKeys not supported";
            throw new AssertionError((Object)$i$a$-assert-JsonSchemaElementKt$jsonSchemaOf$32);
        }
        boolean bl3 = bl = $this$jsonSchemaOf.getConfiguration().getNamingStrategy() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsonSchemaElementKt$jsonSchemaOf$42 = false;
            String $i$a$-assert-JsonSchemaElementKt$jsonSchemaOf$42 = "namingStrategy not supported";
            throw new AssertionError((Object)$i$a$-assert-JsonSchemaElementKt$jsonSchemaOf$42);
        }
        JsonSchemaElement it = JsonSchemaElementKt.jsonSchemaElementOf(descriptor);
        boolean bl4 = false;
        return JsonSchemaBuilder.INSTANCE.build(schemaUri, it);
    }

    private static final JsonSchemaElement jsonSchemaElementOf(SerialDescriptor descriptor) {
        JsonSchemaElement jsonSchemaElement = schemaCache.get(descriptor);
        if (jsonSchemaElement != null) {
            JsonSchemaElement it = jsonSchemaElement;
            boolean bl = false;
            return it;
        }
        Map pendingSchemas = new LinkedHashMap();
        Pair<JsonSchemaElement, Boolean> pair = JsonSchemaElementKt.buildJsonSchema(descriptor, pendingSchemas);
        JsonSchemaElement schema = (JsonSchemaElement)pair.component1();
        boolean isPending = (Boolean)pair.component2();
        if (!isPending) {
            boolean bl = pendingSchemas.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JsonSchemaElementKt$jsonSchemaElementOf$32 = false;
                String $i$a$-assert-JsonSchemaElementKt$jsonSchemaElementOf$32 = "Unprocessed descriptors: " + CollectionsKt.joinToString$default((Iterable)pendingSchemas.keySet(), (CharSequence)", ", null, null, (int)0, null, JsonSchemaElementKt::jsonSchemaElementOf$lambda$8$lambda$7, (int)30, null);
                throw new AssertionError((Object)$i$a$-assert-JsonSchemaElementKt$jsonSchemaElementOf$32);
            }
            return schema;
        }
        for (Map.Entry schema2 : pendingSchemas.entrySet()) {
            schemaCache.putIfAbsent((SerialDescriptor)schema2.getKey(), (JsonSchemaElement)schema2.getValue());
        }
        return (JsonSchemaElement)MapsKt.getValue((Map)schemaCache, (Object)descriptor);
    }

    private static final CharSequence jsonSchemaElementOf$lambda$8$lambda$7(SerialDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSerialName();
    }
}

