/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ml.llm.matterhorn.utils.JsonSchemaElement;
import com.intellij.ml.llm.matterhorn.utils.ObjectMappers;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaBuilder;", "", "<init>", "()V", "factory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "DEFS", "", "REF_KEY", "build", "Lcom/networknt/schema/JsonSchema;", "schemaUri", "Ljava/net/URI;", "element", "Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement;", "buildNodeRef", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "node", "Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement$Object;", "context", "Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaBuilder$BuildContext;", "buildNode", "BuildContext", "core"})
@SourceDebugExtension(value={"SMAP\nJsonSchemaElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaElement.kt\ncom/intellij/ml/llm/matterhorn/utils/JsonSchemaBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
final class JsonSchemaBuilder {
    @NotNull
    public static final JsonSchemaBuilder INSTANCE = new JsonSchemaBuilder();
    private static final JsonNodeFactory factory = ObjectMappers.INSTANCE.getJSON().getNodeFactory();
    @NotNull
    public static final String DEFS = "$defs";
    @NotNull
    public static final String REF_KEY = "$ref";

    private JsonSchemaBuilder() {
    }

    @NotNull
    public final JsonSchema build(@NotNull URI schemaUri, @NotNull JsonSchemaElement element) {
        Intrinsics.checkNotNullParameter((Object)schemaUri, (String)"schemaUri");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ObjectNode rootNode = factory.objectNode().put("$schema", "https://json-schema.org/draft/2020-12/schema");
        ObjectNode defsNode = factory.objectNode();
        Intrinsics.checkNotNull((Object)rootNode);
        Intrinsics.checkNotNull((Object)defsNode);
        ObjectNode node = this.buildNode(rootNode, element, new BuildContext(element, rootNode, defsNode));
        if (!defsNode.isEmpty()) {
            node.replace(DEFS, (JsonNode)defsNode);
        }
        JsonSchema jsonSchema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(schemaUri, (JsonNode)node);
        Intrinsics.checkNotNullExpressionValue((Object)jsonSchema, (String)"getSchema(...)");
        return jsonSchema;
    }

    private final ObjectNode buildNodeRef(ObjectNode node, JsonSchemaElement.Object element, BuildContext context) {
        String ref = context.getRootElement() != element ? "#/$defs/" + element.getName() : "#";
        ObjectNode objectNode = node.put(REF_KEY, ref);
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"put(...)");
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectNode buildNode(ObjectNode node, JsonSchemaElement element, BuildContext context) {
        if (element instanceof JsonSchemaElement.Object && context.getJsonObjects().contains(element)) {
            return this.buildNodeRef(node, (JsonSchemaElement.Object)element, context);
        }
        JsonSchemaElement jsonSchemaElement = element;
        if (jsonSchemaElement instanceof JsonSchemaElement.Object) {
            if (!((Collection)((JsonSchemaElement.Object)element).getProperties()).isEmpty()) {
                ObjectNode objectNode;
                context.getJsonObjects().add((JsonSchemaElement.Object)element);
                ObjectNode it = objectNode = node;
                boolean bl = false;
                Object object = it == context.getRootNode() ? objectNode : null;
                if (object == null) {
                    object = factory.objectNode();
                }
                ObjectNode objectNode2 = object;
                objectNode2.put("type", "object");
                objectNode2.put("additionalProperties", false);
                ObjectNode props = objectNode2.putObject("properties");
                ArrayNode required = objectNode2.putArray("required");
                for (JsonSchemaElement.Object.Property prop : ((JsonSchemaElement.Object)element).getProperties()) {
                    void it2;
                    ObjectNode objectNode3;
                    ObjectNode objectNode4 = objectNode3 = factory.objectNode();
                    String string = prop.getName();
                    ObjectNode objectNode5 = props;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    INSTANCE.buildNode((ObjectNode)it2, prop.getSchema(), context);
                    Unit unit = Unit.INSTANCE;
                    objectNode5.replace(string, (JsonNode)objectNode3);
                    if (prop.getOptional()) continue;
                    required.add(prop.getName());
                }
                if (required.isEmpty()) {
                    objectNode2.remove("required");
                }
                if (!Intrinsics.areEqual((Object)objectNode2, (Object)node)) {
                    context.getDefsNode().replace(((JsonSchemaElement.Object)element).getName(), (JsonNode)objectNode2);
                    this.buildNodeRef(node, (JsonSchemaElement.Object)element, context);
                }
            }
            v1 = Unit.INSTANCE;
        } else if (jsonSchemaElement instanceof JsonSchemaElement.Array) {
            void it;
            ObjectNode objectNode2;
            node.put("type", ((JsonSchemaElement.Array)element).getType());
            ObjectNode props = objectNode2 = factory.objectNode();
            String string = "items";
            ObjectNode objectNode = node;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.buildNode((ObjectNode)it, ((JsonSchemaElement.Array)element).getItems(), context);
            Unit unit = Unit.INSTANCE;
            v1 = objectNode.replace(string, (JsonNode)objectNode2);
        } else if (jsonSchemaElement instanceof JsonSchemaElement.Enum) {
            ArrayNode objectNode2;
            node.put("type", ((JsonSchemaElement.Enum)element).getType());
            ArrayNode it = objectNode2 = node.putArray("enum");
            boolean bl = false;
            for (String value : ((JsonSchemaElement.Enum)element).getValues()) {
                it.add(value);
            }
            v1 = objectNode2;
        } else if (jsonSchemaElement instanceof JsonSchemaElement.Nullable) {
            if (((JsonSchemaElement.Nullable)element).getSchema() instanceof JsonSchemaElement.Object) {
                ArrayNode arrayNode = node.putArray("oneOf");
                ObjectNode objectNode = factory.objectNode();
                Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"objectNode(...)");
                v1 = arrayNode.add((JsonNode)this.buildNode(objectNode, ((JsonSchemaElement.Nullable)element).getSchema(), context)).add((JsonNode)factory.objectNode().put("type", "null"));
            } else {
                this.buildNode(node, ((JsonSchemaElement.Nullable)element).getSchema(), context);
                JsonNode existingType = node.get("type");
                node.replace("type", (JsonNode)factory.arrayNode().add(existingType).add("null"));
                ArrayNode arrayNode = (ArrayNode)node.get("enum");
                v1 = arrayNode != null ? arrayNode.addNull() : null;
            }
        } else {
            v1 = node.put("type", element.getType());
        }
        return node;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaBuilder$BuildContext;", "", "rootElement", "Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement;", "rootNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "defsNode", "<init>", "(Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement;Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "getRootElement", "()Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement;", "getRootNode", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getDefsNode", "jsonObjects", "", "Lcom/intellij/ml/llm/matterhorn/utils/JsonSchemaElement$Object;", "getJsonObjects", "()Ljava/util/Set;", "core"})
    private static final class BuildContext {
        @NotNull
        private final JsonSchemaElement rootElement;
        @NotNull
        private final ObjectNode rootNode;
        @NotNull
        private final ObjectNode defsNode;
        @NotNull
        private final Set<JsonSchemaElement.Object> jsonObjects;

        public BuildContext(@NotNull JsonSchemaElement rootElement, @NotNull ObjectNode rootNode, @NotNull ObjectNode defsNode) {
            Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
            Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
            Intrinsics.checkNotNullParameter((Object)defsNode, (String)"defsNode");
            this.rootElement = rootElement;
            this.rootNode = rootNode;
            this.defsNode = defsNode;
            this.jsonObjects = new LinkedHashSet();
        }

        @NotNull
        public final JsonSchemaElement getRootElement() {
            return this.rootElement;
        }

        @NotNull
        public final ObjectNode getRootNode() {
            return this.rootNode;
        }

        @NotNull
        public final ObjectNode getDefsNode() {
            return this.defsNode;
        }

        @NotNull
        public final Set<JsonSchemaElement.Object> getJsonObjects() {
            return this.jsonObjects;
        }
    }
}

