/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0006\"4\u0010\u0000\u001a&\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002 \u0003*\u0012\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0004\u00a8\u0006\b"}, d2={"SHA_256", "Ljava/lang/ThreadLocal;", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "Ljava/lang/ThreadLocal;", "hash256", "", "", "core"})
public final class HashUtilsKt {
    private static final ThreadLocal<MessageDigest> SHA_256 = ThreadLocal.withInitial(HashUtilsKt::SHA_256$lambda$0);

    @NotNull
    public static final String hash256(@NotNull byte[] $this$hash256) {
        Intrinsics.checkNotNullParameter((Object)$this$hash256, (String)"<this>");
        byte[] byArray = SHA_256.get().digest($this$hash256);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, HashUtilsKt::hash256$lambda$1, (int)30, null);
    }

    @NotNull
    public static final String hash256(@NotNull String $this$hash256) {
        Intrinsics.checkNotNullParameter((Object)$this$hash256, (String)"<this>");
        String string = $this$hash256;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return HashUtilsKt.hash256(byArray);
    }

    private static final MessageDigest SHA_256$lambda$0() {
        return MessageDigest.getInstance("SHA-256");
    }

    private static final CharSequence hash256$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

