/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"sanitizeFileName", "", "name", "strict", "", "replacement", "toSystemDependentName", "path", "separatorChar", "", "toSystemIndependentName", "core"})
public final class FileUtilsKt {
    @NotNull
    public static final String sanitizeFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FileUtilsKt.sanitizeFileName(name, true);
    }

    @NotNull
    public static final String sanitizeFileName(@NotNull String name, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FileUtilsKt.sanitizeFileName(name, strict, "_");
    }

    @NotNull
    public static final String sanitizeFileName(@NotNull String name, boolean strict, @Nullable String replacement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringBuilder result2 = null;
        int last = 0;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            boolean appendReplacement = true;
            if (c > '\u0000' && c < '\u00ff') {
                boolean bl = strict ? Character.isLetterOrDigit(c) || c == '_' : Character.isJavaIdentifierPart(c) || c == ' ' || c == '@' || c == '-';
                if (bl) {
                    continue;
                }
            } else {
                appendReplacement = false;
            }
            if (result2 == null) {
                result2 = new StringBuilder();
            }
            if (last < i) {
                result2.append(name, last, i);
            }
            if (appendReplacement) {
                result2.append(replacement);
            }
            last = i + 1;
        }
        if (result2 == null) {
            return name;
        }
        if (last < length) {
            result2.append(name, last, length);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String toSystemDependentName(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileUtilsKt.toSystemDependentName(path, File.separatorChar);
    }

    @NotNull
    public static final String toSystemDependentName(@NotNull String path, char separatorChar) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)path, (char)'/', (char)separatorChar, (boolean)false, (int)4, null), (char)'\\', (char)separatorChar, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toSystemIndependentName(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }
}

