/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.requests.builder;

import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.helpers.ImageContentHelper;
import com.intellij.ml.llm.matterhorn.http.ContentType;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageImagePart;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessagePart;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.requests.GrazieRequest;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/matterhorn/requests/builder/ImageContent;", "Lcom/intellij/ml/llm/matterhorn/requests/GrazieRequest$Content;", "contentType", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "imageData", "", "<init>", "(Lcom/intellij/ml/llm/matterhorn/http/ContentType;[B)V", "getContentType", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getImageData", "()[B", "toChatMessagePart", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatMessagePart;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "(Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
public final class ImageContent
implements GrazieRequest.Content {
    @NotNull
    private final ContentType contentType;
    @NotNull
    private final byte[] imageData;

    public ImageContent(@NotNull ContentType contentType, @NotNull byte[] imageData) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        this.contentType = contentType;
        this.imageData = imageData;
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    @NotNull
    public final byte[] getImageData() {
        return this.imageData;
    }

    @Override
    @Nullable
    public Object toChatMessagePart(@NotNull ExecutionContext context, @NotNull ModelParameters modelParameters, @NotNull Continuation<? super MatterhornChatMessagePart> $completion) {
        byte[] byArray = ImageContentHelper.INSTANCE.adjustImageData(this.contentType, this.imageData, modelParameters);
        if (byArray == null) {
            return null;
        }
        byte[] adjustedData = byArray;
        return MatterhornChatMessageImagePart.Companion.fromBytes("image/png", adjustedData);
    }
}

