/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.http;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u00152\u00020\u0001:\b\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0013\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "", "contentType", "", "contentSubtype", "parameters", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getContentType", "()Ljava/lang/String;", "getContentSubtype", "getParameters", "()Ljava/util/Map;", "match", "", "other", "toString", "equals", "hashCode", "", "Companion", "Image", "Video", "Audio", "Text", "Application", "Multipart", "Font", "core"})
public final class ContentType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentSubtype;
    @NotNull
    private final Map<String, String> parameters;

    private ContentType(String contentType, String contentSubtype, Map<String, String> parameters) {
        this.contentType = contentType;
        this.contentSubtype = contentSubtype;
        this.parameters = parameters;
    }

    /* synthetic */ ContentType(String string, String string2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, string2, map);
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContentSubtype() {
        return this.contentSubtype;
    }

    @NotNull
    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    public final boolean match(@NotNull ContentType other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.contentType, (Object)other.contentType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)other.contentSubtype, (Object)"*") || Intrinsics.areEqual((Object)this.contentSubtype, (Object)other.contentSubtype);
    }

    @NotNull
    public String toString() {
        String baseType = this.contentType + "/" + this.contentSubtype;
        if (this.parameters.isEmpty()) {
            return baseType;
        }
        String params = CollectionsKt.joinToString$default((Iterable)this.parameters.entrySet(), (CharSequence)"; ", null, null, (int)0, null, ContentType::toString$lambda$0, (int)30, null);
        return baseType + "; " + params;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentType, (Object)((ContentType)other).contentType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentSubtype, (Object)((ContentType)other).contentSubtype)) {
            return false;
        }
        return Intrinsics.areEqual(this.parameters, ((ContentType)other).parameters);
    }

    public int hashCode() {
        int result2 = this.contentType.hashCode();
        result2 = 31 * result2 + this.contentSubtype.hashCode();
        result2 = 31 * result2 + ((Object)this.parameters).hashCode();
        return result2;
    }

    private static final CharSequence toString$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        return StringsKt.contains$default((CharSequence)value, (CharSequence)";", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)value, (CharSequence)" ", (boolean)false, (int)2, null) ? (CharSequence)(key + "=\"" + value + "\"") : (CharSequence)(key + "=" + value);
    }

    public /* synthetic */ ContentType(String contentType, String contentSubtype, Map parameters, DefaultConstructorMarker $constructor_marker) {
        this(contentType, contentSubtype, parameters);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b9\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0007R\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0007R\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0007R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0007R\u0011\u00106\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0007R\u0011\u00108\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0007R\u0011\u0010:\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0007R\u0011\u0010<\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0007\u00a8\u0006>"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Application;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "JSON", "getJSON", "XML", "getXML", "XHTML", "getXHTML", "PDF", "getPDF", "Zip", "getZip", "GZip", "getGZip", "OctetStream", "getOctetStream", "JavaScript", "getJavaScript", "JAR", "getJAR", "RAR", "getRAR", "SevenZ", "getSevenZ", "MSWORD", "getMSWORD", "DOCX", "getDOCX", "XLS", "getXLS", "XLSX", "getXLSX", "PPT", "getPPT", "PPTX", "getPPTX", "TAR", "getTAR", "BZ", "getBZ", "BZ2", "getBZ2", "SQLite", "getSQLite", "WASM", "getWASM", "FontWOFF", "getFontWOFF", "FontWOFF2", "getFontWOFF2", "RSS", "getRSS", "ATOM", "getATOM", "YAML", "getYAML", "core"})
    public static final class Application {
        @NotNull
        public static final Application INSTANCE = new Application();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "*", null, 4, null);
        @NotNull
        private static final ContentType JSON = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "json", null, 4, null);
        @NotNull
        private static final ContentType XML = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "xml", null, 4, null);
        @NotNull
        private static final ContentType XHTML = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "xhtml+xml", null, 4, null);
        @NotNull
        private static final ContentType PDF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "pdf", null, 4, null);
        @NotNull
        private static final ContentType Zip = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "zip", null, 4, null);
        @NotNull
        private static final ContentType GZip = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "gzip", null, 4, null);
        @NotNull
        private static final ContentType OctetStream = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "octet-stream", null, 4, null);
        @NotNull
        private static final ContentType JavaScript = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "javascript", null, 4, null);
        @NotNull
        private static final ContentType JAR = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "java-archive", null, 4, null);
        @NotNull
        private static final ContentType RAR = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.rar", null, 4, null);
        @NotNull
        private static final ContentType SevenZ = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "x-7z-compressed", null, 4, null);
        @NotNull
        private static final ContentType MSWORD = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "msword", null, 4, null);
        @NotNull
        private static final ContentType DOCX = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.openxmlformats-officedocument.wordprocessingml.document", null, 4, null);
        @NotNull
        private static final ContentType XLS = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.ms-excel", null, 4, null);
        @NotNull
        private static final ContentType XLSX = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet", null, 4, null);
        @NotNull
        private static final ContentType PPT = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.ms-powerpoint", null, 4, null);
        @NotNull
        private static final ContentType PPTX = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.openxmlformats-officedocument.presentationml.presentation", null, 4, null);
        @NotNull
        private static final ContentType TAR = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "x-tar", null, 4, null);
        @NotNull
        private static final ContentType BZ = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "x-bzip", null, 4, null);
        @NotNull
        private static final ContentType BZ2 = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "x-bzip2", null, 4, null);
        @NotNull
        private static final ContentType SQLite = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "vnd.sqlite3", null, 4, null);
        @NotNull
        private static final ContentType WASM = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "wasm", null, 4, null);
        @NotNull
        private static final ContentType FontWOFF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "font-woff", null, 4, null);
        @NotNull
        private static final ContentType FontWOFF2 = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "font-woff2", null, 4, null);
        @NotNull
        private static final ContentType RSS = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "rss+xml", null, 4, null);
        @NotNull
        private static final ContentType ATOM = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "atom+xml", null, 4, null);
        @NotNull
        private static final ContentType YAML = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "application", "yaml", null, 4, null);

        private Application() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getJSON() {
            return JSON;
        }

        @NotNull
        public final ContentType getXML() {
            return XML;
        }

        @NotNull
        public final ContentType getXHTML() {
            return XHTML;
        }

        @NotNull
        public final ContentType getPDF() {
            return PDF;
        }

        @NotNull
        public final ContentType getZip() {
            return Zip;
        }

        @NotNull
        public final ContentType getGZip() {
            return GZip;
        }

        @NotNull
        public final ContentType getOctetStream() {
            return OctetStream;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getJAR() {
            return JAR;
        }

        @NotNull
        public final ContentType getRAR() {
            return RAR;
        }

        @NotNull
        public final ContentType getSevenZ() {
            return SevenZ;
        }

        @NotNull
        public final ContentType getMSWORD() {
            return MSWORD;
        }

        @NotNull
        public final ContentType getDOCX() {
            return DOCX;
        }

        @NotNull
        public final ContentType getXLS() {
            return XLS;
        }

        @NotNull
        public final ContentType getXLSX() {
            return XLSX;
        }

        @NotNull
        public final ContentType getPPT() {
            return PPT;
        }

        @NotNull
        public final ContentType getPPTX() {
            return PPTX;
        }

        @NotNull
        public final ContentType getTAR() {
            return TAR;
        }

        @NotNull
        public final ContentType getBZ() {
            return BZ;
        }

        @NotNull
        public final ContentType getBZ2() {
            return BZ2;
        }

        @NotNull
        public final ContentType getSQLite() {
            return SQLite;
        }

        @NotNull
        public final ContentType getWASM() {
            return WASM;
        }

        @NotNull
        public final ContentType getFontWOFF() {
            return FontWOFF;
        }

        @NotNull
        public final ContentType getFontWOFF2() {
            return FontWOFF2;
        }

        @NotNull
        public final ContentType getRSS() {
            return RSS;
        }

        @NotNull
        public final ContentType getATOM() {
            return ATOM;
        }

        @NotNull
        public final ContentType getYAML() {
            return YAML;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Audio;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "MP3", "getMP3", "OGG", "getOGG", "WAV", "getWAV", "AAC", "getAAC", "MIDI", "getMIDI", "WEBM", "getWEBM", "FLAC", "getFLAC", "M4A", "getM4A", "AMR", "getAMR", "WMA", "getWMA", "core"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE = new Audio();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "*", null, 4, null);
        @NotNull
        private static final ContentType MP3 = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "mpeg", null, 4, null);
        @NotNull
        private static final ContentType OGG = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "ogg", null, 4, null);
        @NotNull
        private static final ContentType WAV = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "wav", null, 4, null);
        @NotNull
        private static final ContentType AAC = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "aac", null, 4, null);
        @NotNull
        private static final ContentType MIDI = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "midi", null, 4, null);
        @NotNull
        private static final ContentType WEBM = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "webm", null, 4, null);
        @NotNull
        private static final ContentType FLAC = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "flac", null, 4, null);
        @NotNull
        private static final ContentType M4A = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "mp4", null, 4, null);
        @NotNull
        private static final ContentType AMR = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "amr", null, 4, null);
        @NotNull
        private static final ContentType WMA = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "audio", "x-ms-wma", null, 4, null);

        private Audio() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMP3() {
            return MP3;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        @NotNull
        public final ContentType getWAV() {
            return WAV;
        }

        @NotNull
        public final ContentType getAAC() {
            return AAC;
        }

        @NotNull
        public final ContentType getMIDI() {
            return MIDI;
        }

        @NotNull
        public final ContentType getWEBM() {
            return WEBM;
        }

        @NotNull
        public final ContentType getFLAC() {
            return FLAC;
        }

        @NotNull
        public final ContentType getM4A() {
            return M4A;
        }

        @NotNull
        public final ContentType getAMR() {
            return AMR;
        }

        @NotNull
        public final ContentType getWMA() {
            return WMA;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J,\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Companion;", "", "<init>", "()V", "parse", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "contentTypeString", "", "create", "contentType", "contentSubtype", "parameters", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContentType parse(@NotNull String contentTypeString) {
            Intrinsics.checkNotNullParameter((Object)contentTypeString, (String)"contentTypeString");
            String[] stringArray = new String[]{";"};
            List parts = StringsKt.split$default((CharSequence)contentTypeString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String mainPart = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
            Map parameters = new LinkedHashMap();
            int n = parts.size();
            for (int i = 1; i < n; ++i) {
                String paramPart = ((Object)StringsKt.trim((CharSequence)((String)parts.get(i)))).toString();
                int eqIndex = StringsKt.indexOf$default((CharSequence)paramPart, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (eqIndex <= 0) continue;
                String string = paramPart.substring(0, eqIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String key = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string2 = paramPart.substring(eqIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String value = StringsKt.removeSurrounding((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (CharSequence)"\"");
                parameters.put(key, value);
            }
            String[] stringArray2 = new String[]{"/"};
            List typeParts = StringsKt.split$default((CharSequence)mainPart, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (typeParts.size() != 2) {
                throw new IllegalArgumentException("Invalid content type format: " + contentTypeString);
            }
            return new ContentType(((Object)StringsKt.trim((CharSequence)((String)typeParts.get(0)))).toString(), ((Object)StringsKt.trim((CharSequence)((String)typeParts.get(1)))).toString(), parameters, null);
        }

        @NotNull
        public final ContentType create(@NotNull String contentType, @NotNull String contentSubtype, @NotNull Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)contentSubtype, (String)"contentSubtype");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            return new ContentType(contentType, contentSubtype, parameters, null);
        }

        public static /* synthetic */ ContentType create$default(Companion companion, String string, String string2, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return companion.create(string, string2, map);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Font;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "WOFF", "getWOFF", "WOFF2", "getWOFF2", "TTF", "getTTF", "OTF", "getOTF", "Collection", "getCollection", "core"})
    public static final class Font {
        @NotNull
        public static final Font INSTANCE = new Font();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "font", "*", null, 4, null);
        @NotNull
        private static final ContentType WOFF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "font", "woff", null, 4, null);
        @NotNull
        private static final ContentType WOFF2 = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "font", "woff2", null, 4, null);
        @NotNull
        private static final ContentType TTF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "font", "ttf", null, 4, null);
        @NotNull
        private static final ContentType OTF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "font", "otf", null, 4, null);
        @NotNull
        private static final ContentType Collection = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "font", "collection", null, 4, null);

        private Font() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getWOFF() {
            return WOFF;
        }

        @NotNull
        public final ContentType getWOFF2() {
            return WOFF2;
        }

        @NotNull
        public final ContentType getTTF() {
            return TTF;
        }

        @NotNull
        public final ContentType getOTF() {
            return OTF;
        }

        @NotNull
        public final ContentType getCollection() {
            return Collection;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Image;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "JPEG", "getJPEG", "JPG", "getJPG", "PNG", "getPNG", "GIF", "getGIF", "SVG", "getSVG", "WEBP", "getWEBP", "BMP", "getBMP", "TIFF", "getTIFF", "ICO", "getICO", "HEIC", "getHEIC", "HEIF", "getHEIF", "AVIF", "getAVIF", "core"})
    public static final class Image {
        @NotNull
        public static final Image INSTANCE = new Image();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "*", null, 4, null);
        @NotNull
        private static final ContentType JPEG = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "jpeg", null, 4, null);
        @NotNull
        private static final ContentType JPG = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "jpg", null, 4, null);
        @NotNull
        private static final ContentType PNG = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "png", null, 4, null);
        @NotNull
        private static final ContentType GIF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "gif", null, 4, null);
        @NotNull
        private static final ContentType SVG = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "svg+xml", null, 4, null);
        @NotNull
        private static final ContentType WEBP = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "webp", null, 4, null);
        @NotNull
        private static final ContentType BMP = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "bmp", null, 4, null);
        @NotNull
        private static final ContentType TIFF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "tiff", null, 4, null);
        @NotNull
        private static final ContentType ICO = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "x-icon", null, 4, null);
        @NotNull
        private static final ContentType HEIC = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "heic", null, 4, null);
        @NotNull
        private static final ContentType HEIF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "heif", null, 4, null);
        @NotNull
        private static final ContentType AVIF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "image", "avif", null, 4, null);

        private Image() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final ContentType getJPG() {
            return JPG;
        }

        @NotNull
        public final ContentType getPNG() {
            return PNG;
        }

        @NotNull
        public final ContentType getGIF() {
            return GIF;
        }

        @NotNull
        public final ContentType getSVG() {
            return SVG;
        }

        @NotNull
        public final ContentType getWEBP() {
            return WEBP;
        }

        @NotNull
        public final ContentType getBMP() {
            return BMP;
        }

        @NotNull
        public final ContentType getTIFF() {
            return TIFF;
        }

        @NotNull
        public final ContentType getICO() {
            return ICO;
        }

        @NotNull
        public final ContentType getHEIC() {
            return HEIC;
        }

        @NotNull
        public final ContentType getHEIF() {
            return HEIF;
        }

        @NotNull
        public final ContentType getAVIF() {
            return AVIF;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Multipart;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "FormData", "getFormData", "Mixed", "getMixed", "Alternative", "getAlternative", "Related", "getRelated", "Report", "getReport", "Signed", "getSigned", "Encrypted", "getEncrypted", "core"})
    public static final class Multipart {
        @NotNull
        public static final Multipart INSTANCE = new Multipart();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "*", null, 4, null);
        @NotNull
        private static final ContentType FormData = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "form-data", null, 4, null);
        @NotNull
        private static final ContentType Mixed = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "mixed", null, 4, null);
        @NotNull
        private static final ContentType Alternative = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "alternative", null, 4, null);
        @NotNull
        private static final ContentType Related = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "related", null, 4, null);
        @NotNull
        private static final ContentType Report = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "report", null, 4, null);
        @NotNull
        private static final ContentType Signed = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "signed", null, 4, null);
        @NotNull
        private static final ContentType Encrypted = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "multipart", "encrypted", null, 4, null);

        private Multipart() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getFormData() {
            return FormData;
        }

        @NotNull
        public final ContentType getMixed() {
            return Mixed;
        }

        @NotNull
        public final ContentType getAlternative() {
            return Alternative;
        }

        @NotNull
        public final ContentType getRelated() {
            return Related;
        }

        @NotNull
        public final ContentType getReport() {
            return Report;
        }

        @NotNull
        public final ContentType getSigned() {
            return Signed;
        }

        @NotNull
        public final ContentType getEncrypted() {
            return Encrypted;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Text;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "Plain", "getPlain", "CSS", "getCSS", "CSV", "getCSV", "HTML", "getHTML", "JavaScript", "getJavaScript", "XML", "getXML", "Markdown", "getMarkdown", "RTF", "getRTF", "YAML", "getYAML", "Calendar", "getCalendar", "VTT", "getVTT", "core"})
    public static final class Text {
        @NotNull
        public static final Text INSTANCE = new Text();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "*", null, 4, null);
        @NotNull
        private static final ContentType Plain = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "plain", null, 4, null);
        @NotNull
        private static final ContentType CSS = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "css", null, 4, null);
        @NotNull
        private static final ContentType CSV = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "csv", null, 4, null);
        @NotNull
        private static final ContentType HTML = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "html", null, 4, null);
        @NotNull
        private static final ContentType JavaScript = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "javascript", null, 4, null);
        @NotNull
        private static final ContentType XML = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "xml", null, 4, null);
        @NotNull
        private static final ContentType Markdown = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "markdown", null, 4, null);
        @NotNull
        private static final ContentType RTF = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "rtf", null, 4, null);
        @NotNull
        private static final ContentType YAML = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "yaml", null, 4, null);
        @NotNull
        private static final ContentType Calendar = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "calendar", null, 4, null);
        @NotNull
        private static final ContentType VTT = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "text", "vtt", null, 4, null);

        private Text() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getPlain() {
            return Plain;
        }

        @NotNull
        public final ContentType getCSS() {
            return CSS;
        }

        @NotNull
        public final ContentType getCSV() {
            return CSV;
        }

        @NotNull
        public final ContentType getHTML() {
            return HTML;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getXML() {
            return XML;
        }

        @NotNull
        public final ContentType getMarkdown() {
            return Markdown;
        }

        @NotNull
        public final ContentType getRTF() {
            return RTF;
        }

        @NotNull
        public final ContentType getYAML() {
            return YAML;
        }

        @NotNull
        public final ContentType getCalendar() {
            return Calendar;
        }

        @NotNull
        public final ContentType getVTT() {
            return VTT;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/matterhorn/http/ContentType$Video;", "", "<init>", "()V", "Any", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "getAny", "()Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "WEBM", "getWEBM", "AVI", "getAVI", "MOV", "getMOV", "FLV", "getFLV", "MKV", "getMKV", "THREEGPP", "getTHREEGPP", "OGV", "getOGV", "TS", "getTS", "core"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE = new Video();
        @NotNull
        private static final ContentType Any = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "*", null, 4, null);
        @NotNull
        private static final ContentType MP4 = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "mp4", null, 4, null);
        @NotNull
        private static final ContentType MPEG = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "mpeg", null, 4, null);
        @NotNull
        private static final ContentType WEBM = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "webm", null, 4, null);
        @NotNull
        private static final ContentType AVI = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "x-msvideo", null, 4, null);
        @NotNull
        private static final ContentType MOV = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "quicktime", null, 4, null);
        @NotNull
        private static final ContentType FLV = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "x-flv", null, 4, null);
        @NotNull
        private static final ContentType MKV = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "x-matroska", null, 4, null);
        @NotNull
        private static final ContentType THREEGPP = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "3gpp", null, 4, null);
        @NotNull
        private static final ContentType OGV = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "ogg", null, 4, null);
        @NotNull
        private static final ContentType TS = com.intellij.ml.llm.matterhorn.http.ContentType$Companion.create$default(Companion, "video", "mp2t", null, 4, null);

        private Video() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getWEBM() {
            return WEBM;
        }

        @NotNull
        public final ContentType getAVI() {
            return AVI;
        }

        @NotNull
        public final ContentType getMOV() {
            return MOV;
        }

        @NotNull
        public final ContentType getFLV() {
            return FLV;
        }

        @NotNull
        public final ContentType getMKV() {
            return MKV;
        }

        @NotNull
        public final ContentType getTHREEGPP() {
            return THREEGPP;
        }

        @NotNull
        public final ContentType getOGV() {
            return OGV;
        }

        @NotNull
        public final ContentType getTS() {
            return TS;
        }
    }
}

