/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u001a;\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"truncateLongOutput", "", "commandOutput", "maxLines", "", "maxLineLength", "keepLinesTop", "keepLinesBottom", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;II)Ljava/lang/String;", "core"})
public final class OutputHelperKt {
    @NotNull
    public static final String truncateLongOutput(@NotNull String commandOutput, @Nullable Integer maxLines, @Nullable Integer maxLineLength, int keepLinesTop, int keepLinesBottom) {
        String res;
        Intrinsics.checkNotNullParameter((Object)commandOutput, (String)"commandOutput");
        List lines = StringsKt.lines((CharSequence)commandOutput);
        if (maxLines != null && lines.size() > maxLines) {
            int top = Math.min(keepLinesTop, lines.size());
            int bottom = Math.min(keepLinesBottom, Math.max(0, lines.size() - top));
            int omittedLinesCount = lines.size() - (top + bottom);
            if (omittedLinesCount < 2) {
                v0 = commandOutput;
            } else {
                String firstSavedLines = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)lines, (int)top), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                String lastSavedLines = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)lines, (int)bottom), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                v0 = firstSavedLines + "\n(" + omittedLinesCount + " lines omitted)\n" + lastSavedLines;
            }
        } else {
            v0 = res = commandOutput;
        }
        if (maxLineLength != null) {
            lines = StringsKt.lines((CharSequence)res);
            res = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> OutputHelperKt.truncateLongOutput$lambda$0(maxLineLength, arg_0), (int)30, null);
        }
        return res;
    }

    public static /* synthetic */ String truncateLongOutput$default(String string, Integer n, Integer n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 10;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 10;
        }
        return OutputHelperKt.truncateLongOutput(string, n, n2, n3, n4);
    }

    private static final CharSequence truncateLongOutput$lambda$0(Integer $maxLineLength, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return (CharSequence)(line.length() > $maxLineLength ? StringsKt.substring((String)line, (IntRange)RangesKt.until((int)0, (int)$maxLineLength)) + " ..." : line);
    }
}

