/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import com.intellij.ml.llm.matterhorn.http.ContentType;
import com.intellij.ml.llm.matterhorn.llm.LLMVision;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/matterhorn/helpers/ImageContentHelper;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "adjustImageData", "", "contentType", "Lcom/intellij/ml/llm/matterhorn/http/ContentType;", "imageData", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "encodeImage", "image", "Ljava/awt/image/BufferedImage;", "core"})
@SourceDebugExtension(value={"SMAP\nImageContentHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageContentHelper.kt\ncom/intellij/ml/llm/matterhorn/helpers/ImageContentHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class ImageContentHelper {
    @NotNull
    public static final ImageContentHelper INSTANCE = new ImageContentHelper();
    @NotNull
    private static final Logger logger;

    private ImageContentHelper() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] adjustImageData(@NotNull ContentType contentType, @NotNull byte[] imageData, @NotNull ModelParameters modelParameters) {
        byte[] adjustedData;
        block10: {
            BufferedImage bufferedImage;
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
            Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
            adjustedData = null;
            adjustedData = imageData;
            LLMVision lLMVision = modelParameters.getModel().getCapabilities().getVision();
            if (lLMVision == null) break block10;
            LLMVision vision = lLMVision;
            boolean bl = false;
            Closeable closeable = new ByteArrayInputStream(imageData);
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)closeable;
                boolean bl2 = false;
                bufferedImage = ImageIO.read(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            BufferedImage bufferedImage2 = bufferedImage;
            Dimension adjustedSize = vision.getMaxSupportedSize(new Dimension(bufferedImage2.getWidth(), bufferedImage2.getHeight()));
            if (adjustedSize.width != bufferedImage2.getWidth() || adjustedSize.height != bufferedImage2.getHeight()) {
                BufferedImage resizedImage = Scalr.resize((BufferedImage)bufferedImage2, (int)adjustedSize.width, (int)adjustedSize.height, (BufferedImageOp[])new BufferedImageOp[0]);
                Intrinsics.checkNotNull((Object)resizedImage);
                byte[] byArray = INSTANCE.encodeImage(resizedImage, contentType);
                if (byArray == null) {
                    return null;
                }
                adjustedData = byArray;
            } else {
                Intrinsics.checkNotNull((Object)bufferedImage2);
                byte[] byArray = INSTANCE.encodeImage(bufferedImage2, contentType);
                if (byArray == null) {
                    return null;
                }
                adjustedData = byArray;
            }
        }
        return adjustedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] encodeImage(@NotNull BufferedImage image, @NotNull ContentType contentType) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        boolean bl = contentType.match(ContentType.Image.INSTANCE.getAny());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            if (!ImageIO.write((RenderedImage)image, "png", bos)) {
                logger.error("Failed to write image to stream. No appropriate writer found.");
                byte[] byArray2 = null;
                return byArray2;
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ImageContentHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ImageContentHelper.logger = logger;
    }
}

