/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.execution;

import com.intellij.ml.llm.matterhorn.utils.FileUtilsKt;
import com.intellij.ml.llm.matterhorn.utils.SystemUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/matterhorn/execution/WslPath;", "", "prefix", "", "distributionId", "linuxPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getDistributionId", "()Ljava/lang/String;", "getLinuxPath", "wslRoot", "getWslRoot", "toWindowsUncPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "core"})
public final class WslPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prefix;
    @NotNull
    private final String distributionId;
    @NotNull
    private final String linuxPath;
    @NotNull
    public static final String DEFAULT_UNC_PREFIX = "\\\\wsl.localhost\\";

    public WslPath(@NotNull String prefix, @NotNull String distributionId, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        this.prefix = prefix;
        this.distributionId = distributionId;
        this.linuxPath = linuxPath;
        if (!StringsKt.endsWith$default((String)this.prefix, (String)"\\", (boolean)false, (int)2, null)) {
            throw new AssertionError((Object)(this.prefix + " should end with \\"));
        }
    }

    public /* synthetic */ WslPath(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\\\\wsl$\\";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getDistributionId() {
        return this.distributionId;
    }

    @NotNull
    public final String getLinuxPath() {
        return this.linuxPath;
    }

    public WslPath(@NotNull String distributionId, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        this("\\\\wsl$\\", distributionId, linuxPath);
    }

    @NotNull
    public final String getWslRoot() {
        return this.prefix + this.distributionId;
    }

    @NotNull
    public final String toWindowsUncPath() {
        return this.prefix + this.distributionId + FileUtilsKt.toSystemDependentName(this.linuxPath);
    }

    private final String component1() {
        return this.prefix;
    }

    @NotNull
    public final String component2() {
        return this.distributionId;
    }

    @NotNull
    public final String component3() {
        return this.linuxPath;
    }

    @NotNull
    public final WslPath copy(@NotNull String prefix, @NotNull String distributionId, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        return new WslPath(prefix, distributionId, linuxPath);
    }

    public static /* synthetic */ WslPath copy$default(WslPath wslPath, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = wslPath.prefix;
        }
        if ((n & 2) != 0) {
            string2 = wslPath.distributionId;
        }
        if ((n & 4) != 0) {
            string3 = wslPath.linuxPath;
        }
        return wslPath.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "WslPath(prefix=" + this.prefix + ", distributionId=" + this.distributionId + ", linuxPath=" + this.linuxPath + ")";
    }

    public int hashCode() {
        int result2 = this.prefix.hashCode();
        result2 = result2 * 31 + this.distributionId.hashCode();
        result2 = result2 * 31 + this.linuxPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WslPath)) {
            return false;
        }
        WslPath wslPath = (WslPath)other;
        if (!Intrinsics.areEqual((Object)this.prefix, (Object)wslPath.prefix)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.distributionId, (Object)wslPath.distributionId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.linuxPath, (Object)wslPath.linuxPath);
    }

    @JvmStatic
    @Nullable
    public static final WslPath parseWindowsUncPath(@NotNull String windowsUncPath) {
        return Companion.parseWindowsUncPath(windowsUncPath);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/matterhorn/execution/WslPath$Companion;", "", "<init>", "()V", "DEFAULT_UNC_PREFIX", "", "parseWindowsUncPath", "Lcom/intellij/ml/llm/matterhorn/execution/WslPath;", "windowsUncPath", "path", "prefix", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final WslPath parseWindowsUncPath(@NotNull String windowsUncPath) {
            Intrinsics.checkNotNullParameter((Object)windowsUncPath, (String)"windowsUncPath");
            if (!SystemUtils.INSTANCE.isWin10OrNewer()) {
                return null;
            }
            String path = FileUtilsKt.toSystemDependentName(windowsUncPath, '\\');
            String legacyWslPrefix = "\\\\wsl$\\";
            String modernWslPrefix = WslPath.DEFAULT_UNC_PREFIX;
            WslPath wslPath = this.parseWindowsUncPath(path, legacyWslPrefix);
            if (wslPath == null) {
                wslPath = this.parseWindowsUncPath(path, modernWslPrefix);
            }
            return wslPath;
        }

        private final WslPath parseWindowsUncPath(String path, String prefix) {
            int slashIndex;
            if (StringsKt.startsWith((String)path, (String)prefix, (boolean)true) && (slashIndex = StringsKt.indexOf$default((CharSequence)path, (char)'\\', (int)prefix.length(), (boolean)false, (int)4, null)) > prefix.length()) {
                String string = path.substring(prefix.length(), slashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = path.substring(slashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return new WslPath(prefix, string, FileUtilsKt.toSystemIndependentName(string2));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

