/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.CacheType;
import com.intellij.ml.llm.matterhorn.MatterhornCaches;
import com.intellij.ml.llm.matterhorn.MediaStorage;
import com.intellij.ml.llm.matterhorn.helpers.ContentTypeHelpers;
import com.intellij.ml.llm.matterhorn.helpers.PathHelpers;
import com.intellij.ml.llm.matterhorn.http.ContentType;
import com.intellij.ml.llm.matterhorn.utils.HashUtilsKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/matterhorn/MatterhornCachesMediaStorage;", "Lcom/intellij/ml/llm/matterhorn/MediaStorage;", "caches", "Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;)V", "store", "", "content", "", "originalFilePath", "get", "mediaContentId", "core"})
@SourceDebugExtension(value={"SMAP\nMatterhornCachesMediaStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatterhornCachesMediaStorage.kt\ncom/intellij/ml/llm/matterhorn/MatterhornCachesMediaStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class MatterhornCachesMediaStorage
implements MediaStorage {
    @NotNull
    private final MatterhornCaches caches;

    public MatterhornCachesMediaStorage(@NotNull MatterhornCaches caches) {
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        this.caches = caches;
    }

    @Override
    @NotNull
    public String store(@NotNull byte[] content, @Nullable String originalFilePath) {
        String string;
        Path originalFilePath2;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String hashCode = HashUtilsKt.hash256(content);
        String string2 = originalFilePath;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            v1 = PathHelpers.INSTANCE.tryGetPathWithSameExtension(originalFilePath);
        } else {
            v1 = originalFilePath2 = null;
        }
        if (originalFilePath2 != null) {
            Object object = ContentTypeHelpers.INSTANCE.getContentTypeByPath(originalFilePath2);
            if (object == null || (object = ((ContentType)object).getContentType()) == null) {
                object = "file";
            }
            Object contentType = object;
            string = (String)contentType + "-" + hashCode + "." + PathsKt.getExtension((Path)originalFilePath2);
        } else {
            string = "image-" + hashCode + ".jpg";
        }
        String fileName = string;
        this.caches.saveBinary(CacheType.Media, fileName, content);
        return fileName;
    }

    @Override
    @Nullable
    public byte[] get(@NotNull String mediaContentId) {
        Intrinsics.checkNotNullParameter((Object)mediaContentId, (String)"mediaContentId");
        return this.caches.loadBinary(CacheType.Media, mediaContentId);
    }
}

