/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.CostLimitExceededException;
import com.intellij.ml.llm.matterhorn.CustomContext;
import com.intellij.ml.llm.matterhorn.ExecutionContextUserDataKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/matterhorn/CostContext;", "Lcom/intellij/ml/llm/matterhorn/CustomContext;", "name", "", "costLimit", "", "<init>", "(Ljava/lang/String;D)V", "value", "totalCost", "getTotalCost", "()D", "updateTotalCostAndCheckLimit", "", "cost", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCostContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CostContext.kt\ncom/intellij/ml/llm/matterhorn/CostContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,19:1\n1#2:20\n*E\n"})
public final class CostContext
implements CustomContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final double costLimit;
    private double totalCost;
    @NotNull
    private static final ExecutionContextUserDataKey<CostContext> COST_CONTEXT_KEY = new ExecutionContextUserDataKey("CostContextKey");

    public CostContext(@NotNull String name, double costLimit) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.costLimit = costLimit;
    }

    public /* synthetic */ CostContext(String string, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = -1.0;
        }
        this(string, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getTotalCost() {
        double d;
        CostContext costContext = this;
        synchronized (costContext) {
            boolean bl = false;
            d = this.totalCost;
        }
        return d;
    }

    public final synchronized void updateTotalCostAndCheckLimit(double cost) {
        this.totalCost = this.getTotalCost() + cost;
        if (this.costLimit > 0.0 && this.getTotalCost() > this.costLimit) {
            throw new CostLimitExceededException(this.name + " cost limit exceeded. Current cost: " + this.getTotalCost() + ", limit: " + this.costLimit);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/matterhorn/CostContext$Companion;", "", "<init>", "()V", "COST_CONTEXT_KEY", "Lcom/intellij/ml/llm/matterhorn/ExecutionContextUserDataKey;", "Lcom/intellij/ml/llm/matterhorn/CostContext;", "getCOST_CONTEXT_KEY", "()Lcom/intellij/ml/llm/matterhorn/ExecutionContextUserDataKey;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutionContextUserDataKey<CostContext> getCOST_CONTEXT_KEY() {
            return COST_CONTEXT_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

