/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.owner;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.ElementOwnerResolveAssistant;
import com.intellij.database.schemaEditor.owner.ElementMatcherImpl;
import com.intellij.openapi.Disposable;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleElementOwner
implements ElementOwner {
    private final ElementMatcherImpl myMatcher;
    private final ElementIdentity<? extends BasicElement> myIdentity;
    private final BasicElement myElement;
    private final BasicResolveAssistant myResolveAssistant;

    public <T extends BasicElement> SingleElementOwner(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<T> identity, @Nullable T element) {
        if (matcher == null) {
            SingleElementOwner.$$$reportNull$$$0(0);
        }
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(1);
        }
        this.myResolveAssistant = new ElementOwnerResolveAssistant(this);
        this.myMatcher = (ElementMatcherImpl)matcher;
        this.myIdentity = identity;
        this.myElement = element;
    }

    public Iterable<? extends ElementIdentity<?>> getCached() {
        return JBIterable.of(this.myIdentity);
    }

    public void addListener(@NotNull ElementOwner.ElementListener listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            SingleElementOwner.$$$reportNull$$$0(2);
        }
        if (parent2 == null) {
            SingleElementOwner.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    public BasicResolveAssistant getResolveAssistant() {
        BasicResolveAssistant basicResolveAssistant = this.myResolveAssistant;
        if (basicResolveAssistant == null) {
            SingleElementOwner.$$$reportNull$$$0(4);
        }
        return basicResolveAssistant;
    }

    @NotNull
    public <E extends BasicElement> ElementIdentity<E> identify(@NotNull E e) {
        if (e == null) {
            SingleElementOwner.$$$reportNull$$$0(5);
        }
        BasicMetaObject meta = BasicMetaUtils.getMetaObject(e);
        ElementIdentity elementIdentity = e == this.myElement ? Objects.requireNonNull(ElementIdentity.tryCast(this.myIdentity, (BasicMetaObject)meta)) : this.create(null, meta);
        if (elementIdentity == null) {
            SingleElementOwner.$$$reportNull$$$0(6);
        }
        return elementIdentity;
    }

    @Nullable
    public <E extends BasicElement> ElementIdentity<E> findIdentity(@Nullable E e) {
        if (e == null) {
            return null;
        }
        BasicMetaObject meta = BasicMetaUtils.getMetaObject(e);
        return e == this.myElement ? ElementIdentity.tryCast(this.myIdentity, (BasicMetaObject)meta) : null;
    }

    @Nullable
    public <E extends BasicElement> E findElement(@Nullable ElementIdentity<E> e) {
        return this.find(e);
    }

    @Nullable
    public ElementIdentity<?> getParent(@NotNull ElementIdentity<?> identity) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(7);
        }
        return this.myMatcher.getParent(identity);
    }

    public <E extends BasicElement> void addMatch(@NotNull ElementIdentity<E> identity, @NotNull E element) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(8);
        }
        if (element == null) {
            SingleElementOwner.$$$reportNull$$$0(9);
        }
    }

    public <E extends BasicElement> void addMatchAndPull(@NotNull ElementIdentity<E> identity, @NotNull E element) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(10);
        }
        if (element == null) {
            SingleElementOwner.$$$reportNull$$$0(11);
        }
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> ElementIdentity<T> identifyInlineRef(@NotNull S owner, @NotNull BasicMetaReference<S, T> ref, @NotNull T e) {
        if (owner == null) {
            SingleElementOwner.$$$reportNull$$$0(12);
        }
        if (ref == null) {
            SingleElementOwner.$$$reportNull$$$0(13);
        }
        if (e == null) {
            SingleElementOwner.$$$reportNull$$$0(14);
        }
        if (e == this.myElement) {
            ElementIdentity<T> elementIdentity = this.identify(e);
            if (elementIdentity == null) {
                SingleElementOwner.$$$reportNull$$$0(15);
            }
            return elementIdentity;
        }
        ElementIdentity elementIdentity = this.myMatcher.createInlineRef((ElementIdentity)this.identify(owner), (BasicMetaReference)ref, BasicMetaUtils.getMetaObject(e));
        if (elementIdentity == null) {
            SingleElementOwner.$$$reportNull$$$0(16);
        }
        return elementIdentity;
    }

    @NotNull
    public <E extends BasicElement> JBIterable<ElementIdentity<E>> getChildren(@NotNull ElementIdentity<?> identity, @NotNull BasicMetaObject<E> childMeta) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(17);
        }
        if (childMeta == null) {
            SingleElementOwner.$$$reportNull$$$0(18);
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SingleElementOwner.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @Nullable
    public <E extends BasicElement> E findOrCreate(@NotNull ElementIdentity<E> identity) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(20);
        }
        return this.find(identity);
    }

    public boolean isDropped(@NotNull ElementIdentity<?> identity) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(21);
        }
        return false;
    }

    public <E extends BasicElement> void drop(@NotNull ElementIdentity<E> identity) {
        if (identity == null) {
            SingleElementOwner.$$$reportNull$$$0(22);
        }
    }

    @NotNull
    public <E extends BasicElement> ElementIdentity<E> create(@Nullable ElementIdentity<?> parent2, @NotNull BasicMetaObject<E> meta) {
        if (meta == null) {
            SingleElementOwner.$$$reportNull$$$0(23);
        }
        ElementIdentity elementIdentity = this.myMatcher.create((ElementIdentity)parent2, (BasicMetaObject)meta);
        if (elementIdentity == null) {
            SingleElementOwner.$$$reportNull$$$0(24);
        }
        return elementIdentity;
    }

    @NotNull
    public ElementMatcher getMatcher() {
        ElementMatcherImpl elementMatcherImpl = this.myMatcher;
        if (elementMatcherImpl == null) {
            SingleElementOwner.$$$reportNull$$$0(25);
        }
        return elementMatcherImpl;
    }

    @Nullable
    public ElementOwner getOriginal() {
        return null;
    }

    @NotNull
    public <E extends BasicElement> ElementIdentity<E> register(@Nullable ElementIdentity<?> parent2, @NotNull E object) {
        if (object == null) {
            SingleElementOwner.$$$reportNull$$$0(26);
        }
        ElementIdentity<E> elementIdentity = this.identify(object);
        if (elementIdentity == null) {
            SingleElementOwner.$$$reportNull$$$0(27);
        }
        return elementIdentity;
    }

    @Nullable
    public <E extends BasicElement> E find(@Nullable ElementIdentity<E> identity) {
        return (E)(identity == this.myIdentity ? identity.getMetaObject().tryCast(this.myElement) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 15, 16, 19, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: 
            case 15: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/owner/SingleElementOwner";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childMeta";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/owner/SingleElementOwner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveAssistant";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "identify";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyInlineRef";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcher";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "register";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: 
            case 6: 
            case 15: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "identify";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addMatch";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMatchAndPull";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "identifyInlineRef";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDropped";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 15, 16, 19, 24, 25, 27 -> new IllegalStateException(string);
        };
    }
}

