/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00042\u00020\u0001:\u0003\u0004\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/GlobalSessionStateListener;", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$Adapter;", "<init>", "()V", "Companion", "SavedSession", "SessionSearchStrategy", "intellij.database.impl"})
public final class GlobalSessionStateListener
extends DatabaseSessionStateListener.Adapter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final SavedSession getSessionInfo(@NotNull Project project, @NotNull VirtualFile file) {
        return Companion.getSessionInfo(project, file);
    }

    @JvmStatic
    private static final SessionSearchStrategy strategyFor(VirtualFile file) {
        return GlobalSessionStateListener.Companion.strategyFor(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0003\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/GlobalSessionStateListener$Companion;", "", "<init>", "()V", "getSessionInfo", "Lcom/intellij/database/console/GlobalSessionStateListener$SavedSession;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "strategyFor", "Lcom/intellij/database/console/GlobalSessionStateListener$SessionSearchStrategy;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SavedSession getSessionInfo(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            SessionSearchStrategy strategy = this.strategyFor(file);
            return strategy.lookForNewSession(project, file);
        }

        @JvmStatic
        private final SessionSearchStrategy strategyFor(VirtualFile file) {
            return DbVFSUtils.isConsoleFile((VirtualFile)file) ? SessionSearchStrategy.CONSOLE : SessionSearchStrategy.REGULAR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/GlobalSessionStateListener$SavedSession;", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "sessionName", "", "strict", "", "<init>", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Z)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getSessionName", "()Ljava/lang/String;", "getStrict", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.impl"})
    public static final class SavedSession {
        @NotNull
        private final LocalDataSource dataSource;
        @NotNull
        private final String sessionName;
        private final boolean strict;

        public SavedSession(@NotNull LocalDataSource dataSource, @NotNull String sessionName, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
            this.dataSource = dataSource;
            this.sessionName = sessionName;
            this.strict = strict;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nls
        @NotNull
        public final String getSessionName() {
            return this.sessionName;
        }

        public final boolean getStrict() {
            return this.strict;
        }

        @NotNull
        public final LocalDataSource component1() {
            return this.dataSource;
        }

        @NotNull
        public final String component2() {
            return this.sessionName;
        }

        public final boolean component3() {
            return this.strict;
        }

        @NotNull
        public final SavedSession copy(@NotNull LocalDataSource dataSource, @NotNull String sessionName, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
            return new SavedSession(dataSource, sessionName, strict);
        }

        public static /* synthetic */ SavedSession copy$default(SavedSession savedSession, LocalDataSource localDataSource, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                localDataSource = savedSession.dataSource;
            }
            if ((n & 2) != 0) {
                string = savedSession.sessionName;
            }
            if ((n & 4) != 0) {
                bl = savedSession.strict;
            }
            return savedSession.copy(localDataSource, string, bl);
        }

        @NotNull
        public String toString() {
            return "SavedSession(dataSource=" + this.dataSource + ", sessionName=" + this.sessionName + ", strict=" + this.strict + ")";
        }

        public int hashCode() {
            int result2 = this.dataSource.hashCode();
            result2 = result2 * 31 + this.sessionName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.strict);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedSession)) {
                return false;
            }
            SavedSession savedSession = (SavedSession)other;
            if (!Intrinsics.areEqual((Object)this.dataSource, (Object)savedSession.dataSource)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sessionName, (Object)savedSession.sessionName)) {
                return false;
            }
            return this.strict == savedSession.strict;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/GlobalSessionStateListener$SessionSearchStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "CONSOLE", "REGULAR", "lookForNewSession", "Lcom/intellij/database/console/GlobalSessionStateListener$SavedSession;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
    private static final abstract class SessionSearchStrategy
    extends Enum<SessionSearchStrategy> {
        public static final /* enum */ SessionSearchStrategy CONSOLE = new CONSOLE("CONSOLE", 0);
        public static final /* enum */ SessionSearchStrategy REGULAR = new REGULAR("REGULAR", 1);
        private static final /* synthetic */ SessionSearchStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SessionSearchStrategy() {
        }

        @Nullable
        public abstract SavedSession lookForNewSession(@NotNull Project var1, @NotNull VirtualFile var2);

        public static SessionSearchStrategy[] values() {
            return (SessionSearchStrategy[])$VALUES.clone();
        }

        public static SessionSearchStrategy valueOf(String value) {
            return Enum.valueOf(SessionSearchStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<SessionSearchStrategy> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ SessionSearchStrategy(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = sessionSearchStrategyArray = new SessionSearchStrategy[]{SessionSearchStrategy.CONSOLE, SessionSearchStrategy.REGULAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/intellij/database/console/GlobalSessionStateListener.SessionSearchStrategy.CONSOLE", "Lcom/intellij/database/console/GlobalSessionStateListener$SessionSearchStrategy;", "lookForNewSession", "Lcom/intellij/database/console/GlobalSessionStateListener$SavedSession;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
        static final class CONSOLE
        extends SessionSearchStrategy {
            /*
             * WARNING - void declaration
             */
            CONSOLE() {
                void var1_1;
            }

            @Override
            @Nullable
            public SavedSession lookForNewSession(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)DbVFSUtils.getDataSource((Project)project, (VirtualFile)file)));
                if (localDataSource == null) {
                    return null;
                }
                LocalDataSource dataSource = localDataSource;
                return new SavedSession(dataSource, SessionsUtil.getSessionTitle((VirtualFile)file), false);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/intellij/database/console/GlobalSessionStateListener.SessionSearchStrategy.REGULAR", "Lcom/intellij/database/console/GlobalSessionStateListener$SessionSearchStrategy;", "lookForNewSession", "Lcom/intellij/database/console/GlobalSessionStateListener$SavedSession;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
        static final class REGULAR
        extends SessionSearchStrategy {
            /*
             * WARNING - void declaration
             */
            REGULAR() {
                void var1_1;
            }

            @Override
            @Nullable
            public SavedSession lookForNewSession(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                LocalDataSource localDataSource = (LocalDataSource)ReadAction.compute(() -> REGULAR.lookForNewSession$lambda$0(project, file));
                if (localDataSource == null) {
                    return null;
                }
                LocalDataSource dataSource = localDataSource;
                return new SavedSession(dataSource, SessionsUtil.getSessionTitle((VirtualFile)file), false);
            }

            private static final LocalDataSource lookForNewSession$lambda$0(Project $project, VirtualFile $file) {
                return DataSourcePerFileMappingsImpl.Companion.getDataSourcePerFileMapping($project, $file);
            }
        }
    }
}

