/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.ddl;

import com.intellij.database.Dbms;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceList;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.schemaEditor.DbmsObjectEditorModelFactoryKt;
import com.intellij.database.schemaEditor.model.applier.DbNameModelApplier;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateObjectActionHelper {
    private static final Comparator<CreateData> COMPARATOR = Comparator.comparing(d -> d.meta, BasicMetaUtils.PRESENTATION_COMPARATOR);

    @Contract(mutates="param1,param5")
    public static <T extends BasicElement> void prepareNewObject(@NotNull Dbms dbms, @NotNull ObjectCursor<T> target, @NotNull ModelHelper.ObjectKindVariant variant, short position, @NotNull Set<ObjectCursor<?>> selection) {
        if (dbms == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(0);
        }
        if (target == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(1);
        }
        if (variant == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(3);
        }
        CreateObjectActionHelper.fillNewObjectWithExamples(dbms, variant, target);
        CreateObjectActionHelper.fillPropertiesFromSelection(target, selection);
        CreateObjectActionHelper.setPositionIfSupported(dbms, target, position);
        CreateObjectActionHelper.resetNameForTemplatable(target);
    }

    private static <T extends BasicElement> void resetNameForTemplatable(@NotNull ObjectCursor<T> target) {
        BasicModNamedElement named;
        if (target == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(4);
        }
        if ((named = (BasicModNamedElement)ObjectUtils.tryCast(target.getProperties(), BasicModNamedElement.class)) != null && DbmsObjectEditorModelFactoryKt.hasNameTemplate(target.getMetaObject().kind)) {
            named.setName("");
        }
    }

    public static <T extends BasicElement> void setPositionIfSupported(@NotNull Dbms dbms, @NotNull ObjectCursor<T> target, short position) {
        BasicModArrangedElement arranged;
        if (dbms == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(5);
        }
        if (target == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(6);
        }
        if ((arranged = (BasicModArrangedElement)ObjectUtils.tryCast(target.getProperties(), BasicModArrangedElement.class)) == null) {
            return;
        }
        if (position != 0 && CreateObjectActionHelper.canBePositioned(dbms, (BasicElement)arranged, target.isExisting())) {
            arranged.setPosition(position);
        } else {
            ObjectCursor<?> parent2 = target.getParent();
            if (parent2 != null) {
                int lastPossible;
                List children = parent2.getChildren(target.getMetaObject().kind).toList();
                int positionIdx = position - 1;
                for (lastPossible = children.size(); lastPossible > positionIdx && lastPossible != 0 && !((ObjectCursor)children.get(lastPossible - 1)).isExisting(); --lastPossible) {
                }
                int lastPossiblePosition = lastPossible + 1;
                arranged.setPosition((short)lastPossiblePosition);
            }
        }
    }

    private static boolean canBePositioned(@NotNull Dbms dbms, BasicElement arranged, boolean isExisting) {
        if (dbms == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(7);
        }
        ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(arranged);
        return (Boolean)(isExisting ? capabilities.canAlter((BasicMetaId)BasicModArrangedElement.POSITION) : capabilities.canCreateWith((BasicMetaId)BasicModArrangedElement.POSITION)).get(Version.INFINITY);
    }

    public static <T extends BasicElement> boolean fillPropertiesFromSelection(@NotNull ObjectCursor<T> o, @NotNull Set<ObjectCursor<?>> selection) {
        if (o == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(9);
        }
        if (selection.isEmpty()) {
            return false;
        }
        BasicMetaObject<T> meta = o.getMetaObject();
        Set properties = (Set)meta.getAllProperties().addAllTo(new LinkedHashSet());
        boolean modified = false;
        while (!properties.isEmpty()) {
            modified |= CreateObjectActionHelper.processProperty(o, selection, properties, (BasicMetaField)ContainerUtil.getFirstItem((Collection)properties));
        }
        return modified;
    }

    private static <T extends BasicElement> boolean processProperty(@NotNull ObjectCursor<T> o, @NotNull Set<ObjectCursor<?>> selection, Set<BasicMetaProperty<T, ?>> properties, BasicMetaField<T> property) {
        if (o == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(10);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(11);
        }
        if (property == null) {
            return false;
        }
        boolean modified = false;
        if (property instanceof BasicMetaReference) {
            modified = CreateObjectActionHelper.fillPropertyFromSelection(o, (BasicMetaReference)property, properties, selection);
        } else if (property instanceof BasicMetaReferenceList) {
            modified = CreateObjectActionHelper.fillPropertyFromSelection(o, (BasicMetaReferenceList)property, properties, selection);
        } else if (property instanceof BasicMetaProperty) {
            modified = CreateObjectActionHelper.fillPropertyFromSelection(o, (BasicMetaProperty)property, properties, selection);
        }
        properties.remove(property);
        return modified;
    }

    private static <T extends BasicElement, V> boolean fillPropertyFromSelection(@NotNull ObjectCursor<T> o, @NotNull BasicMetaProperty<T, V> property, @NotNull Set<BasicMetaProperty<T, ?>> properties, @NotNull Set<? extends ObjectCursor<?>> selection) {
        if (o == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(12);
        }
        if (property == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(14);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(15);
        }
        if (property.id == BasicModColumniation.COL_NAMES) {
            return CreateObjectActionHelper.fillColNames(o, property.asId(BasicModColumniation.COL_NAMES), selection);
        }
        return false;
    }

    private static <T extends BasicElement> boolean fillColNames(@NotNull ObjectCursor<T> o, @NotNull BasicMetaProperty<T, List<String>> property, @NotNull Set<? extends ObjectCursor<?>> selection) {
        if (o == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(16);
        }
        if (property == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(17);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(18);
        }
        ArrayList colNames = new ArrayList();
        ObjectCursor<?> parent2 = o.getParent();
        selection.removeIf(cur -> {
            BasicMetaObject meta = cur.getMetaObject();
            if (meta.kind == ObjectKind.COLUMN && Objects.equals(parent2, cur.getParent())) {
                colNames.add(cur.getProperties().getName());
                return true;
            }
            return false;
        });
        if (colNames.isEmpty()) {
            return false;
        }
        T target = o.getProperties();
        property.set(target, colNames);
        BasicMetaProperty rev = BasicMetaUtils.getMetaObject(target).getObjectProperty(BasicModIndex.REVERSE_COL_NAMES);
        if (rev != null) {
            rev.set(target, Collections.emptySet());
        }
        return true;
    }

    private static <T extends BasicElement, E extends BasicElement> boolean fillPropertyFromSelection(@NotNull ObjectCursor<T> o, @NotNull BasicMetaReference<T, E> reference, @NotNull Set<BasicMetaProperty<T, ?>> properties, @NotNull Set<ObjectCursor<?>> selection) {
        if (o == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(19);
        }
        if (reference == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(20);
        }
        if (properties == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(21);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(22);
        }
        BasicMetaObject[] targets = reference.getReferenceDesc().targets;
        Iterator<ObjectCursor<?>> it = selection.iterator();
        while (it.hasNext()) {
            BasicReference ref = CreateObjectActionHelper.removeNextTarget(targets, it);
            if (ref == null) continue;
            reference.set(o.getProperties(), (Object)ref);
            return true;
        }
        return false;
    }

    @Nullable
    private static <E extends BasicElement> BasicReference removeNextTarget(BasicMetaObject<? extends E>[] targets, Iterator<? extends ObjectCursor<?>> it) {
        ObjectCursor<?> cur = it.next();
        if (ArrayUtil.indexOf((Object[])targets, cur.getMetaObject()) == -1) {
            return null;
        }
        it.remove();
        return BasicNameReference.create((String)cur.getProperties().getName());
    }

    private static <T extends BasicElement, E extends BasicElement> boolean fillPropertyFromSelection(@NotNull ObjectCursor<T> o, @NotNull BasicMetaReferenceList<T, E> referenceList, @NotNull Set<BasicMetaProperty<T, ?>> properties, @NotNull Set<ObjectCursor<?>> selection) {
        if (o == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(23);
        }
        if (referenceList == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(24);
        }
        if (properties == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(25);
        }
        if (selection == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(26);
        }
        BasicMetaObject[] targets = referenceList.getReferenceDesc().targets;
        ArrayList res2 = new ArrayList();
        Iterator<ObjectCursor<?>> it = selection.iterator();
        while (it.hasNext()) {
            BasicReference ref = CreateObjectActionHelper.removeNextTarget(targets, it);
            ContainerUtil.addIfNotNull(res2, (Object)ref);
        }
        if (!res2.isEmpty()) {
            referenceList.set(o.getProperties(), res2);
            return true;
        }
        return false;
    }

    private static <T extends BasicElement> void fillNewObjectWithExamples(Dbms dbms, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull ObjectCursor<T> target) {
        if (variant == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(27);
        }
        if (target == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(28);
        }
        ModelHelper helper = ModelFacade.forDbms((Dbms)dbms).getModelHelper();
        T properties = target.getProperties();
        helper.fillPropertiesWithExamples((BasicModElement)properties, variant, new HashMap(), false);
        CreateObjectActionHelper.ensureObjectIsUnique(target);
    }

    public static <T extends BasicElement> void ensureObjectIsUnique(@NotNull ObjectCursor<T> target) {
        ObjectCursor<?> parent2;
        T properties;
        if (target == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(29);
        }
        if ((properties = target.getProperties()) instanceof BasicModNamedElement && (parent2 = target.getParent()) != null) {
            String name = DbNameModelApplier.generateUniqueName(DbNameModelApplier.extractBase(properties.getName()), ContainerUtil.map(parent2.getChildren(properties.getKind()), c2 -> c2.getProperties().getName()));
            ((BasicModNamedElement)properties).setName(name);
        }
        if (properties instanceof BasicModIdentifiedElement) {
            ((BasicModIdentifiedElement)properties).setObjectId(new Random().nextLong());
        }
    }

    public static @NotNull JBIterable<@Nullable Pair<ObjectCursor<?>, CreateData>> getCreateTargets(@NotNull Dbms dbms, @NotNull ObjectCursor<?> cursor, @Nullable BasicMetaObject<?> prioritize) {
        if (dbms == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(30);
        }
        if (cursor == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(31);
        }
        return CreateObjectActionHelper.getCreateTargets(ModelFacade.forDbms((Dbms)dbms).getModelHelper(), cursor, prioritize);
    }

    @NotNull
    public static JBIterable<Pair<ObjectCursor<?>, CreateData>> getObjectCreateTargets(@NotNull Dbms dbms, @NotNull ObjectCursor<?> cursor, @Nullable BasicMetaObject<?> prioritize) {
        if (dbms == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(32);
        }
        if (cursor == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(33);
        }
        return CreateObjectActionHelper.getObjectCreateTargets(ModelFacade.forDbms((Dbms)dbms).getModelHelper(), cursor, prioritize);
    }

    @NotNull
    public static JBIterable<Pair<ObjectCursor<?>, CreateData>> getFamilyCreateTargets(@NotNull Dbms dbms, @NotNull ObjectCursor<?> cursor, @Nullable BasicMetaObject<?> family) {
        if (dbms == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(34);
        }
        if (cursor == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(35);
        }
        JBIterable jBIterable = CreateObjectActionHelper.getObjectCreateTargets(dbms, cursor, family).takeWhile(p -> ((CreateData)p.second).meta == family);
        if (jBIterable == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    private static @NotNull JBIterable<@Nullable Pair<ObjectCursor<?>, CreateData>> getCreateTargets(@NotNull ModelHelper helper, @Nullable ObjectCursor<?> cursor, @Nullable BasicMetaObject<?> prioritize) {
        if (helper == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(37);
        }
        JBIterable targets = JBIterable.generate(cursor, ObjectCursor::getParent).flatten((Function)DbSqlUtilCore.track(prioritize, (tracker, o) -> CreateObjectActionHelper.getObjectCreateTargets(helper, o, (BasicMetaObject)tracker.fun(o.getMetaObject())))).unique(p -> ((CreateData)p.second).variant.getText(((CreateData)p.second).meta));
        ArrayList allTargets = ContainerUtil.newArrayList((Iterable)targets);
        boolean prioritizeVirtual = CreateObjectActionHelper.isVirtualElement(prioritize == null ? (cursor == null ? null : cursor.getMetaObject()) : prioritize);
        allTargets.sort(Comparator.comparing(c2 -> CreateObjectActionHelper.isVirtualElement(((CreateData)c2.second).meta) == prioritizeVirtual ? 0 : 1));
        int idx = ContainerUtil.indexOf((List)allTargets, c2 -> CreateObjectActionHelper.isVirtualElement(((CreateData)c2.second).meta) != prioritizeVirtual);
        if (idx != -1) {
            allTargets.add(idx, null);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)allTargets);
        if (jBIterable == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(38);
        }
        return jBIterable;
    }

    private static boolean isVirtualElement(@Nullable BasicMetaObject<?> meta) {
        return meta != null && meta.kindOf(VmElement.class);
    }

    @NotNull
    private static JBIterable<Pair<ObjectCursor<?>, CreateData>> getObjectCreateTargets(@NotNull ModelHelper helper, @Nullable ObjectCursor<?> e, @Nullable BasicMetaObject<?> prioritize) {
        if (helper == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(39);
        }
        return CreateObjectActionHelper.getObjectCreateTargets(helper, e, prioritize == null ? null : Comparator.comparingInt(c2 -> c2.meta == prioritize ? 0 : 1));
    }

    @NotNull
    private static JBIterable<Pair<ObjectCursor<?>, CreateData>> getObjectCreateTargets(@NotNull ModelHelper helper, @Nullable ObjectCursor<?> e, @Nullable Comparator<CreateData> priority) {
        if (helper == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(40);
        }
        JBIterable jBIterable = CreateObjectActionHelper.getObjectCreateData(helper, e, priority).map(c2 -> Pair.create((Object)e, (Object)c2));
        if (jBIterable == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(41);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<CreateData> getObjectCreateData(@NotNull ModelHelper helper, @Nullable ObjectCursor<?> e, @Nullable Comparator<CreateData> priority) {
        if (helper == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(42);
        }
        if (e == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                CreateObjectActionHelper.$$$reportNull$$$0(43);
            }
            return jBIterable;
        }
        Comparator<CreateData> comparator = COMPARATOR;
        if (priority != null) {
            comparator = priority.thenComparing(comparator);
        }
        JBIterable jBIterable = e.getMetaChildren().flatten(m -> CreateObjectActionHelper.getObjectCreateVariants(helper, e, m)).sort(comparator);
        if (jBIterable == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(44);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<CreateData> getObjectCreateVariants(@NotNull ModelHelper helper, @NotNull ObjectCursor<?> e, @NotNull BasicMetaObject<?> m) {
        ObjectCursor pk;
        if (helper == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(45);
        }
        if (e == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(46);
        }
        if (m == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(47);
        }
        JBIterable variants = helper.generationVariants(m);
        if (m.kind == ObjectKind.KEY && (pk = (ObjectCursor)e.getChildren(ObjectKind.KEY).find(o -> {
            BasicKey key = (BasicKey)ObjectUtils.tryCast(o.getProperties(), BasicKey.class);
            return key != null && key.isPrimary();
        })) != null) {
            variants = variants.filter(v -> v != ModelHelper.PRIMARY_KEY);
        }
        JBIterable jBIterable = variants.map(v -> new CreateData(m, (ModelHelper.ObjectKindVariant)v));
        if (jBIterable == null) {
            CreateObjectActionHelper.$$$reportNull$$$0(48);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 36, 38, 41, 43, 44, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cursor";
                break;
            }
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ddl/CreateObjectActionHelper";
                break;
            }
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ddl/CreateObjectActionHelper";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyCreateTargets";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTargets";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectCreateTargets";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectCreateData";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectCreateVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareNewObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetNameForTemplatable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPositionIfSupported";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBePositioned";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillPropertiesFromSelection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fillPropertyFromSelection";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillColNames";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fillNewObjectWithExamples";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureObjectIsUnique";
                break;
            }
            case 30: 
            case 31: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCreateTargets";
                break;
            }
            case 32: 
            case 33: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getObjectCreateTargets";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyCreateTargets";
                break;
            }
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 48: {
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getObjectCreateData";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getObjectCreateVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 36, 38, 41, 43, 44, 48 -> new IllegalStateException(string);
        };
    }

    public static interface ObjectCursor<E extends BasicElement> {
        @NotNull
        public E getProperties();

        @NotNull
        public Dbms getDbms();

        @NotNull
        public BasicMetaObject<E> getMetaObject();

        @NotNull
        public JBIterable<BasicMetaObject<?>> getMetaChildren();

        @Nullable
        public ObjectCursor<?> getParent();

        public boolean isExisting();

        @NotNull
        public JBIterable<ObjectCursor<?>> getChildren(@Nullable ObjectKind var1);
    }

    public static class CreateData {
        public final BasicMetaObject<?> meta;
        public final ModelHelper.ObjectKindVariant variant;

        public CreateData(@NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant) {
            if (meta == null) {
                CreateData.$$$reportNull$$$0(0);
            }
            if (variant == null) {
                CreateData.$$$reportNull$$$0(1);
            }
            this.meta = meta;
            this.variant = variant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variant";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/ddl/CreateObjectActionHelper$CreateData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

