/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.util;

import com.intellij.openapi.project.Project;
import com.intellij.util.Restarter;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.plugins.unity.util.UnityInstallationFinder;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\b\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0010\u0010\u0015\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\u0016"}, d2={"convertPidToDebuggerPort", "", "port", "", "addPlayModeArguments", "", "args", "", "", "getUnityArgs", "project", "Lcom/intellij/openapi/project/Project;", "withRiderPath", "withDebugCodeOptimization", "withProjectPath", "projectPath", "withBatchMode", "withRunTests", "withEditorLog", "withTestResults", "withTestPlatform", "toProgramParameters", "intellij.rider.plugins.unity"})
public final class UnityUtilsKt {
    public static final int convertPidToDebuggerPort(int port) {
        return UnityUtilsKt.convertPidToDebuggerPort((long)port);
    }

    public static final int convertPidToDebuggerPort(long port) {
        return (int)(port % (long)1000) + 56000;
    }

    public static final void addPlayModeArguments(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        args.add("-executeMethod");
        args.add("JetBrains.Rider.Unity.Editor.StartUpMethodExecutor.EnterPlayMode");
    }

    @NotNull
    public static final List<String> getUnityArgs(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String executable = String.valueOf(UnityInstallationFinder.Companion.getInstance(project).getApplicationExecutablePath());
        Object[] objectArray = new String[]{executable};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public static final List<String> withRiderPath(@NotNull List<String> $this$withRiderPath) {
        String riderPath;
        Intrinsics.checkNotNullParameter($this$withRiderPath, (String)"<this>");
        Comparable<Path> comparable = Restarter.getIdeStarter();
        String string = comparable != null && (comparable = comparable.toFile()) != null ? ((File)comparable).getCanonicalPath() : (riderPath = null);
        if (riderPath != null) {
            Object[] objectArray = new String[]{"-riderPath", riderPath};
            $this$withRiderPath.addAll(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        return $this$withRiderPath;
    }

    @NotNull
    public static final List<String> withDebugCodeOptimization(@NotNull List<String> $this$withDebugCodeOptimization) {
        Intrinsics.checkNotNullParameter($this$withDebugCodeOptimization, (String)"<this>");
        $this$withDebugCodeOptimization.add("-debugCodeOptimization");
        return $this$withDebugCodeOptimization;
    }

    @NotNull
    public static final List<String> withProjectPath(@NotNull List<String> $this$withProjectPath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$withProjectPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new String[2];
        objectArray[0] = "-projectPath";
        Intrinsics.checkNotNullExpressionValue((Object)SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getCanonicalPath(), (String)"getCanonicalPath(...)");
        $this$withProjectPath.addAll(CollectionsKt.mutableListOf((Object[])objectArray));
        return $this$withProjectPath;
    }

    @NotNull
    public static final List<String> withProjectPath(@NotNull List<String> $this$withProjectPath, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter($this$withProjectPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Object[] objectArray = new String[]{"-projectPath", projectPath};
        $this$withProjectPath.addAll(CollectionsKt.mutableListOf((Object[])objectArray));
        return $this$withProjectPath;
    }

    @NotNull
    public static final List<String> withBatchMode(@NotNull List<String> $this$withBatchMode) {
        Intrinsics.checkNotNullParameter($this$withBatchMode, (String)"<this>");
        $this$withBatchMode.add("-batchmode");
        return $this$withBatchMode;
    }

    @NotNull
    public static final List<String> withRunTests(@NotNull List<String> $this$withRunTests) {
        Intrinsics.checkNotNullParameter($this$withRunTests, (String)"<this>");
        $this$withRunTests.add("-runTests");
        return $this$withRunTests;
    }

    @NotNull
    public static final List<String> withEditorLog(@NotNull List<String> $this$withEditorLog) {
        Intrinsics.checkNotNullParameter($this$withEditorLog, (String)"<this>");
        Object[] objectArray = new String[]{"-logFile", "Logs/Editor.log"};
        $this$withEditorLog.addAll(CollectionsKt.listOf((Object[])objectArray));
        return $this$withEditorLog;
    }

    @NotNull
    public static final List<String> withTestResults(@NotNull List<String> $this$withTestResults) {
        Intrinsics.checkNotNullParameter($this$withTestResults, (String)"<this>");
        Object[] objectArray = new String[]{"-testResults", "Logs/results.xml"};
        $this$withTestResults.addAll(CollectionsKt.listOf((Object[])objectArray));
        return $this$withTestResults;
    }

    @NotNull
    public static final List<String> withTestPlatform(@NotNull List<String> $this$withTestPlatform) {
        Intrinsics.checkNotNullParameter($this$withTestPlatform, (String)"<this>");
        Object[] objectArray = new String[]{"-testPlatform", "EditMode"};
        $this$withTestPlatform.addAll(CollectionsKt.listOf((Object[])objectArray));
        return $this$withTestPlatform;
    }

    @NotNull
    public static final String toProgramParameters(@NotNull List<String> $this$toProgramParameters) {
        Intrinsics.checkNotNullParameter($this$toProgramParameters, (String)"<this>");
        String string = ParametersListUtil.join($this$toProgramParameters);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }
}

