/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.util;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.plugins.unity.EngineConstants;
import com.jetbrains.rider.plugins.unity.model.UnityApplicationData;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder;", "", "<init>", "()V", "unityApplicationData", "Lcom/jetbrains/rider/plugins/unity/model/UnityApplicationData;", "requiresRiderPackage", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getRequiresRiderPackage", "()Lcom/jetbrains/rd/util/reactive/Property;", "setRequiresRiderPackage", "(Lcom/jetbrains/rd/util/reactive/Property;)V", "isCoreCLR", "setCoreCLR", "getBuiltInPackagesRoot", "Ljava/nio/file/Path;", "getApplicationContentsPath", "getApplicationExecutablePath", "getDefaultPlaybackEnginesRoot", "getAdditionalPlaybackEnginesRoot", "getApplicationContentsPathFromProtocol", "tryGetApplicationPathFromProtocol", "getApplicationVersion", "", "count", "", "tryGetApplicationVersionFromProtocol", "Companion", "ProtocolListener", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityInstallationFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityInstallationFinder.kt\ncom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class UnityInstallationFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UnityApplicationData unityApplicationData;
    @NotNull
    private Property<Boolean> requiresRiderPackage = new Property(null);
    @NotNull
    private Property<Boolean> isCoreCLR = new Property(null);

    @NotNull
    public final Property<Boolean> getRequiresRiderPackage() {
        return this.requiresRiderPackage;
    }

    public final void setRequiresRiderPackage(@NotNull Property<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"<set-?>");
        this.requiresRiderPackage = property;
    }

    @NotNull
    public final Property<Boolean> isCoreCLR() {
        return this.isCoreCLR;
    }

    public final void setCoreCLR(@NotNull Property<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"<set-?>");
        this.isCoreCLR = property;
    }

    @Nullable
    public final Path getBuiltInPackagesRoot() {
        Path path = this.getApplicationContentsPath();
        return path != null ? path.resolve("Resources/PackageManager/BuiltInPackages") : null;
    }

    @Nullable
    public final Path getApplicationContentsPath() {
        Path contentsPath = this.getApplicationContentsPathFromProtocol();
        if (contentsPath != null) {
            return contentsPath;
        }
        Path path = this.tryGetApplicationPathFromProtocol();
        if (path == null) {
            return null;
        }
        Path root = path;
        return SystemInfo.isMac ? root.resolve("Contents") : (SystemInfo.isWindows ? root.getParent().resolve("Data") : (SystemInfo.isLinux ? root.getParent().resolve("Data") : null));
    }

    @Nullable
    public final Path getApplicationExecutablePath() {
        Path path = this.tryGetApplicationPathFromProtocol();
        if (path != null) {
            return Companion.getOsSpecificPath(path);
        }
        return null;
    }

    @Nullable
    public final Path getDefaultPlaybackEnginesRoot() {
        Path path = this.getApplicationContentsPath();
        return path != null ? path.resolve("PlaybackEngines") : null;
    }

    @Nullable
    public final Path getAdditionalPlaybackEnginesRoot() {
        Path path = this.tryGetApplicationPathFromProtocol();
        if (path == null) {
            return null;
        }
        Path applicationPath = path;
        return SystemInfo.isMac ? applicationPath.getParent().resolve("PlaybackEngines") : (SystemInfo.isWindows ? this.getDefaultPlaybackEnginesRoot() : (SystemInfo.isLinux ? this.getDefaultPlaybackEnginesRoot() : null));
    }

    private final Path getApplicationContentsPathFromProtocol() {
        Path path;
        UnityApplicationData unityApplicationData = this.unityApplicationData;
        if (unityApplicationData != null) {
            UnityApplicationData it = unityApplicationData;
            boolean bl = false;
            path = Paths.get(it.getApplicationContentsPath(), new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final Path tryGetApplicationPathFromProtocol() {
        Path path;
        UnityApplicationData unityApplicationData = this.unityApplicationData;
        if (unityApplicationData != null) {
            UnityApplicationData it = unityApplicationData;
            boolean bl = false;
            path = Paths.get(it.getApplicationPath(), new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final String getApplicationVersion() {
        return this.tryGetApplicationVersionFromProtocol();
    }

    @Nullable
    public final String getApplicationVersion(int count) {
        char[] cArray;
        String fullVersion = this.getApplicationVersion();
        Object object = fullVersion;
        return object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) != null && (object = CollectionsKt.take((Iterable)((Iterable)object), (int)count)) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)".", null, null, (int)0, null, null, (int)62, null) : null;
    }

    private final String tryGetApplicationVersionFromProtocol() {
        UnityApplicationData unityApplicationData = this.unityApplicationData;
        return unityApplicationData != null ? unityApplicationData.getApplicationVersion() : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder;", "project", "Lcom/intellij/openapi/project/Project;", "getOsSpecificPath", "Ljava/nio/file/Path;", "path", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityInstallationFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityInstallationFinder.kt\ncom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,123:1\n30#2,2:124\n*S KotlinDebug\n*F\n+ 1 UnityInstallationFinder.kt\ncom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder$Companion\n*L\n22#1:124,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnityInstallationFinder getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UnityInstallationFinder> serviceClass$iv = UnityInstallationFinder.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnityInstallationFinder)object;
        }

        @NotNull
        public final Path getOsSpecificPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (SystemInfo.isMac) {
                if (path.endsWith(EngineConstants.INSTANCE.getTuanjieEngineName() + ".app")) {
                    Path path2 = path.resolve("Contents/MacOS/" + EngineConstants.INSTANCE.getTuanjieEngineName());
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    return path2;
                }
                Path path3 = path.resolve("Contents/MacOS/" + EngineConstants.INSTANCE.getUnityEngineName());
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                return path3;
            }
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/UnityInstallationFinder$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/FrontendBackendModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.unity"})
    public static final class ProtocolListener
    implements SolutionExtListener<FrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.getUnityApplicationData().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$0(session, arg_0));
            SourceExKt.flowInto((ISource)((ISource)model.getRequiresRiderPackage()), (Lifetime)lifetime, (IMutablePropertyBase)((IMutablePropertyBase)Companion.getInstance(session.getProject()).getRequiresRiderPackage()));
            SourceExKt.flowInto((ISource)((ISource)model.isCoreCLR()), (Lifetime)lifetime, (IMutablePropertyBase)((IMutablePropertyBase)Companion.getInstance(session.getProject()).isCoreCLR()));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, UnityApplicationData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.getInstance($session.getProject()).unityApplicationData = it;
            return Unit.INSTANCE;
        }
    }
}

