/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ideaInterop.fileTypes.msbuild.CsprojFileType;
import com.jetbrains.rider.ideaInterop.fileTypes.sln.SolutionFileType;
import com.jetbrains.rider.plugins.unity.css.uss.UssFileType;
import com.jetbrains.rider.plugins.unity.ideaInterop.fileTypes.uxml.UxmlFileType;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"nonEditableExtensions", "", "", "getExtensions", "isNonEditableUnityFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isNonEditableUnityFileExtension", "extension", "isGeneratedUnityFile", "isUxmlFile", "isUssFile", "intellij.rider.plugins.unity"})
public final class FileExtensionsKt {
    @NotNull
    private static final Set<String> nonEditableExtensions = FileExtensionsKt.getExtensions();

    private static final Set<String> getExtensions() {
        Object[] objectArray = new String[]{"asset", "prefab", "unity", "meta", "anim", "brush", "controller", "cubemap", "flare", "fontsettings", "giparams", "guiskin", "mask", "mat", "mixer", "physicMaterial", "physicsMaterial2D", "playable", "overrideController", "renderTexture", "signal", "spriteatlas", "terrainlayer"};
        return SetsKt.setOf((Object[])objectArray);
    }

    public static final boolean isNonEditableUnityFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileExtensionsKt.isNonEditableUnityFileExtension(file.getExtension());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNonEditableUnityFileExtension(@Nullable String extension) {
        if (extension == null) return false;
        String string = extension;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!nonEditableExtensions.contains(string2)) return false;
        return true;
    }

    public static final boolean isGeneratedUnityFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        return fileTypeRegistry.isFileOfType(file, (FileType)CsprojFileType.INSTANCE) || fileTypeRegistry.isFileOfType(file, (FileType)SolutionFileType.INSTANCE);
    }

    public static final boolean isUxmlFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)UxmlFileType.INSTANCE);
    }

    public static final boolean isUssFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)UssFileType.INSTANCE);
    }
}

