/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.toolWindow.log;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.plugins.unity.toolWindow.log.LogPanelItem;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogPanelIconsKt;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogTokenizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J:\u0010\u0016\u001a\u00020\u00172\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelEventRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/LogPanelItem;", "Ljavax/swing/ListCellRenderer;", "<init>", "()V", "countLabel", "Ljavax/swing/JLabel;", "view", "Ljavax/swing/JPanel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "item", "index", "", "selected", "", "hasFocus", "tokenizer", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenizer;", "customizeCellRenderer", "", "event", "intellij.rider.plugins.unity"})
public final class UnityLogPanelEventRenderer
extends ColoredListCellRenderer<LogPanelItem>
implements ListCellRenderer<LogPanelItem> {
    @NotNull
    private final JLabel countLabel = new JLabel();
    @NotNull
    private final JPanel view = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, gap 0, novisualpadding"));
    @NotNull
    private final UnityLogTokenizer tokenizer;

    public UnityLogPanelEventRenderer() {
        this.view.add((Component)((Object)this), "wmin 0, pushx");
        this.countLabel.setForeground(Color.GRAY);
        this.view.add((Component)this.countLabel, "east");
        this.tokenizer = new UnityLogTokenizer();
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends LogPanelItem> list, @NotNull LogPanelItem item, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.clear();
        this.setFont(list.getFont());
        this.mySelected = selected;
        this.myForeground = this.isEnabled() ? list.getForeground() : UIUtil.getLabelDisabledForeground();
        this.mySelectionForeground = list.getSelectionForeground();
        Color bg = UIUtil.isUnderWin10LookAndFeel() ? (selected ? list.getSelectionBackground() : list.getBackground()) : (selected ? list.getSelectionBackground() : null);
        this.setBackground(bg);
        this.countLabel.setBackground(bg);
        this.view.setBackground(bg);
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, item, index, selected, hasFocus);
        if (item.getCount() > 1) {
            this.countLabel.setText(" \u00d7" + item.getCount() + " ");
        } else {
            this.countLabel.setText("");
        }
        return this.view;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends LogPanelItem> list, @Nullable LogPanelItem event, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (event != null) {
            Icon[] iconArray = new Icon[]{UnityLogPanelIconsKt.getIcon(event.getType()), UnityLogPanelIconsKt.getIcon(event.getMode())};
            this.setIcon((Icon)new RowIcon(iconArray));
            List<UnityLogTokenizer.Token> tokens = this.tokenizer.tokenize(event.getShortPresentation());
            for (UnityLogTokenizer.Token token : tokens) {
                if (token.getUsed()) continue;
                SimpleTextAttributes style = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (token.getBold() && token.getItalic()) {
                    style = new SimpleTextAttributes(3, token.getColor());
                } else if (token.getBold()) {
                    style = token.getColor() == null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : new SimpleTextAttributes(1, token.getColor());
                } else if (token.getItalic()) {
                    style = token.getColor() == null ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : new SimpleTextAttributes(1, token.getColor());
                } else if (token.getColor() != null) {
                    style = new SimpleTextAttributes(0, token.getColor());
                }
                this.append(token.getToken(), style);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)true, (boolean)selected);
        }
    }
}

