/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run.configurations.devices;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.rider.debugger.IMixedModeDebugAwareRunProfile;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.run.UnityEditorEntryPoint;
import com.jetbrains.rider.plugins.unity.run.UnityEditorEntryPointAndPlay;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.run.configurations.RunConfigurationUtilKt;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachToEditorRunConfiguration;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachToEditorSettingsEditor;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityEditorDebugConfigurationType;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityRunConfigurationBase;
import com.jetbrains.rider.plugins.unity.run.configurations.devices.UnityDevicePlayerConfiguration;
import com.jetbrains.rider.plugins.unity.run.configurations.devices.UnityDevicePlayerFactory;
import com.jetbrains.rider.plugins.unity.run.devices.UnityDevicesProvider;
import com.jetbrains.rider.run.devices.ActiveDeviceManager;
import com.jetbrains.rider.run.devices.ActiveDeviceView;
import com.jetbrains.rider.run.devices.DevicesConfiguration;
import com.jetbrains.rider.run.devices.DevicesProvider;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001b0\u001aH\u0016J\u0012\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/configurations/devices/UnityDevicePlayerConfiguration;", "Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityRunConfigurationBase;", "Lcom/jetbrains/rider/run/devices/DevicesConfiguration;", "Lcom/jetbrains/rider/debugger/IMixedModeDebugAwareRunProfile;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/jetbrains/rider/plugins/unity/run/configurations/devices/UnityDevicePlayerFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/unity/run/configurations/devices/UnityDevicePlayerFactory;)V", "editorConfigurationType", "Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityEditorDebugConfigurationType;", "editorConfiguration", "Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachToEditorRunConfiguration;", "editorAndPlayConfiguration", "activeRunConfiguration", "getActiveRunConfiguration", "()Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachToEditorRunConfiguration;", "getRunProfileStateAsync", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/execution/Executor;Lcom/intellij/execution/runners/ExecutionEnvironment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "provider", "Lcom/jetbrains/rider/run/devices/DevicesProvider;", "getProvider", "()Lcom/jetbrains/rider/run/devices/DevicesProvider;", "getAdditionalUsageData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "useMixedDebugMode", "", "intellij.rider.plugins.unity"})
public final class UnityDevicePlayerConfiguration
extends UnityRunConfigurationBase
implements DevicesConfiguration,
IMixedModeDebugAwareRunProfile {
    @NotNull
    private final UnityEditorDebugConfigurationType editorConfigurationType;
    @NotNull
    private final UnityAttachToEditorRunConfiguration editorConfiguration;
    @NotNull
    private final UnityAttachToEditorRunConfiguration editorAndPlayConfiguration;
    @Nullable
    private final DevicesProvider provider;

    public UnityDevicePlayerConfiguration(@NotNull Project project, @NotNull UnityDevicePlayerFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)factory), (String)"factory");
        super(project, factory, null, 4, null);
        this.editorConfigurationType = (UnityEditorDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityEditorDebugConfigurationType.class);
        this.editorConfiguration = new UnityAttachToEditorRunConfiguration(project, (ConfigurationFactory)this.editorConfigurationType.getAttachToEditorAndPlayFactory(), false);
        this.editorAndPlayConfiguration = new UnityAttachToEditorRunConfiguration(project, (ConfigurationFactory)this.editorConfigurationType.getAttachToEditorAndPlayFactory(), true);
        this.provider = UnityDevicesProvider.Companion.getService(project);
    }

    private final UnityAttachToEditorRunConfiguration getActiveRunConfiguration() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UnityProcess unityProcess = (UnityProcess)ActiveDeviceManager.Companion.getInstance(project).getDevice();
        return unityProcess instanceof UnityEditorEntryPoint ? this.editorConfiguration : (unityProcess instanceof UnityEditorEntryPointAndPlay ? this.editorAndPlayConfiguration : null);
    }

    @Nullable
    public Object getRunProfileStateAsync(@NotNull Executor executor, @NotNull ExecutionEnvironment environment, @NotNull Continuation<? super RunProfileState> $completion) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ActiveDeviceManager manager = ActiveDeviceManager.Companion.getInstance(project);
        UnityProcess process = (UnityProcess)manager.getDevice();
        UnityAttachToEditorRunConfiguration unityAttachToEditorRunConfiguration = this.getActiveRunConfiguration();
        if (unityAttachToEditorRunConfiguration != null) {
            UnityAttachToEditorRunConfiguration activeConfiguration = unityAttachToEditorRunConfiguration;
            boolean bl = false;
            RunProfileState runProfileState = activeConfiguration.getState(executor, environment);
            if (runProfileState == null) {
                throw new CantRunException(UnityBundle.Companion.message("dialog.message.failed.to.use.attach.to.unity.editor.run.configuration", new Object[0]));
            }
            return runProfileState;
        }
        if (process == null) {
            throw new CantRunException(UnityBundle.Companion.message("failed.to.identify.device", new Object[0]));
        }
        RunConfigurationUtilKt.populateStateFromProcess(this.getState(), process);
        return this.getRunProfileStateAsyncInternal(executor, environment, $completion);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        UnityAttachToEditorRunConfiguration activeRunConfiguration;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ActiveDeviceManager manager = ActiveDeviceManager.Companion.getInstance(project);
        UnityAttachToEditorRunConfiguration unityAttachToEditorRunConfiguration = activeRunConfiguration = this.getActiveRunConfiguration();
        SettingsEditor<? extends RunConfiguration> settingsEditor = unityAttachToEditorRunConfiguration != null ? unityAttachToEditorRunConfiguration.getConfigurationEditor() : null;
        UnityAttachToEditorSettingsEditor editor = settingsEditor instanceof UnityAttachToEditorSettingsEditor ? (UnityAttachToEditorSettingsEditor)settingsEditor : null;
        return (SettingsEditor)new CheckableRunConfigurationEditor<UnityDevicePlayerConfiguration>(manager, editor, activeRunConfiguration){
            private final Lazy<DialogPanel> panel;
            final /* synthetic */ UnityAttachToEditorSettingsEditor $editor;
            final /* synthetic */ UnityAttachToEditorRunConfiguration $activeRunConfiguration;
            {
                this.$editor = $editor;
                this.$activeRunConfiguration = $activeRunConfiguration;
                this.panel = LazyKt.lazy(() -> getConfigurationEditor.1.panel$lambda$0($manager));
            }

            protected void resetEditorFrom(UnityDevicePlayerConfiguration config) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
                    UnityAttachToEditorSettingsEditor unityAttachToEditorSettingsEditor = this.$editor;
                    if (unityAttachToEditorSettingsEditor == null) break block0;
                    unityAttachToEditorSettingsEditor.resetEditorFrom(this.$activeRunConfiguration);
                }
            }

            protected void applyEditorTo(UnityDevicePlayerConfiguration s) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
                    UnityAttachToEditorSettingsEditor unityAttachToEditorSettingsEditor = this.$editor;
                    if (unityAttachToEditorSettingsEditor == null) break block0;
                    unityAttachToEditorSettingsEditor.applyEditorTo(this.$activeRunConfiguration);
                }
            }

            protected JComponent createEditor() {
                Object object = this.$editor;
                return object != null && (object = object.createEditor()) != null ? (JComponent)object : (JComponent)this.panel.getValue();
            }

            protected void disposeEditor() {
                block0: {
                    UnityAttachToEditorSettingsEditor unityAttachToEditorSettingsEditor = this.$editor;
                    if (unityAttachToEditorSettingsEditor == null) break block0;
                    unityAttachToEditorSettingsEditor.disposeEditor();
                }
            }

            public void checkEditorData(UnityDevicePlayerConfiguration s) {
                block0: {
                    UnityAttachToEditorSettingsEditor unityAttachToEditorSettingsEditor = this.$editor;
                    if (unityAttachToEditorSettingsEditor == null) break block0;
                    unityAttachToEditorSettingsEditor.checkEditorData(this.$activeRunConfiguration);
                }
            }

            private static final DialogPanel panel$lambda$0(ActiveDeviceManager $manager) {
                return BuilderKt.panel(arg_0 -> getConfigurationEditor.1.panel$lambda$0$0($manager, arg_0));
            }

            private static final Unit panel$lambda$0$0(ActiveDeviceManager $manager, Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, arg_0 -> getConfigurationEditor.1.panel$lambda$0$0$0($manager, arg_0), (int)1, null);
                return Unit.INSTANCE;
            }

            private static final Unit panel$lambda$0$0$0(ActiveDeviceManager $manager, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Object object = (ActiveDeviceView)$manager.getActiveDeviceView().getValue();
                if (object == null || (object = object.getName()) == null) {
                    object = "";
                }
                $this$row.label((String)object).align((Align)AlignX.FILL.INSTANCE);
                return Unit.INSTANCE;
            }
        };
    }

    @Nullable
    public DevicesProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public List<EventPair<?>> getAdditionalUsageData() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ActiveDeviceManager.Companion.getInstance(project).getStatisticsDeviceData();
    }

    public boolean useMixedDebugMode() {
        UnityAttachToEditorRunConfiguration unityAttachToEditorRunConfiguration = this.getActiveRunConfiguration();
        return unityAttachToEditorRunConfiguration != null ? unityAttachToEditorRunConfiguration.useMixedDebugMode() : false;
    }
}

