/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run.configurations;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rider.plugins.unity.run.UnityLocalProcess;
import com.jetbrains.rider.plugins.unity.run.UnityLocalProcessExtraDetails;
import com.jetbrains.rider.plugins.unity.run.UnityRunUtil;
import com.jetbrains.rider.plugins.unity.run.UnityRunUtilKt;
import com.jetbrains.rider.plugins.unity.util.EditorInstanceJson;
import com.jetbrains.rider.plugins.unity.util.EditorInstanceJsonStatus;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010 \u001a\u00020!J!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachToEditorViewModel;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editorInstanceJsonStatus", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJsonStatus;", "getEditorInstanceJsonStatus", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "editorProcesses", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/rider/plugins/unity/run/UnityLocalProcess;", "getEditorProcesses", "()Lcom/jetbrains/rd/util/reactive/ViewableList;", "pid", "", "getPid", "editorInstanceJson", "Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson;", "useMixedMode", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getUseMixedMode", "()Lcom/jetbrains/rd/util/reactive/Property;", "setUseMixedMode", "(Lcom/jetbrains/rd/util/reactive/Property;)V", "refreshProcessList", "", "getEditorProcessInfos", "", "processList", "", "Lcom/intellij/execution/process/ProcessInfo;", "([Lcom/intellij/execution/process/ProcessInfo;)Ljava/util/List;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityAttachToEditorViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityAttachToEditorViewModel.kt\ncom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachToEditorViewModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n3919#2:63\n4434#2,2:64\n1563#3:66\n1634#3,3:67\n295#3,2:70\n*S KotlinDebug\n*F\n+ 1 UnityAttachToEditorViewModel.kt\ncom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachToEditorViewModel\n*L\n56#1:63\n56#1:64,2\n58#1:66\n58#1:67,3\n49#1:70,2\n*E\n"})
public final class UnityAttachToEditorViewModel {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final IProperty<EditorInstanceJsonStatus> editorInstanceJsonStatus;
    @NotNull
    private final ViewableList<UnityLocalProcess> editorProcesses;
    @NotNull
    private final IProperty<Integer> pid;
    @NotNull
    private final EditorInstanceJson editorInstanceJson;
    @NotNull
    private Property<Boolean> useMixedMode;

    public UnityAttachToEditorViewModel(@NotNull Lifetime lifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lifetime = lifetime;
        this.project = project;
        this.editorInstanceJsonStatus = (IProperty)new Property(null);
        this.editorProcesses = new ViewableList(null, 1, null);
        this.pid = (IProperty)new Property(null);
        this.editorInstanceJson = EditorInstanceJson.Companion.getInstance(this.project);
        this.useMixedMode = new Property((Object)false);
        this.refreshProcessList();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final IProperty<EditorInstanceJsonStatus> getEditorInstanceJsonStatus() {
        return this.editorInstanceJsonStatus;
    }

    @NotNull
    public final ViewableList<UnityLocalProcess> getEditorProcesses() {
        return this.editorProcesses;
    }

    @NotNull
    public final IProperty<Integer> getPid() {
        return this.pid;
    }

    @NotNull
    public final Property<Boolean> getUseMixedMode() {
        return this.useMixedMode;
    }

    public final void setUseMixedMode(@NotNull Property<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"<set-?>");
        this.useMixedMode = property;
    }

    public final void refreshProcessList() {
        this.editorProcesses.clear();
        ApplicationKt.getApplication().executeOnPooledThread(() -> UnityAttachToEditorViewModel.refreshProcessList$lambda$0(this));
    }

    /*
     * WARNING - void declaration
     */
    private final List<UnityLocalProcess> getEditorProcessInfos(ProcessInfo[] processList) {
        void $this$mapTo$iv$iv;
        ProcessInfo it;
        void $this$filterTo$iv$iv;
        ProcessInfo[] $this$filter$iv = processList;
        boolean $i$f$filter = false;
        ProcessInfo[] processInfoArray = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
            if (!UnityRunUtil.INSTANCE.isUnityEditorProcess(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unityProcesses = (List)destination$iv$iv;
        Map<Integer, UnityLocalProcessExtraDetails> unityProcessInfoMap = UnityRunUtil.INSTANCE.getAllUnityProcessInfo(unityProcesses, this.project);
        Iterable $this$map$iv = unityProcesses;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProcessInfo)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(UnityRunUtilKt.toUnityProcess(it, unityProcessInfoMap.get(it.getPid())));
        }
        return (List)destination$iv$iv2;
    }

    private static final void refreshProcessList$lambda$0(UnityAttachToEditorViewModel this$0) {
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        ProcessInfo[] processList = processInfoArray;
        List<UnityLocalProcess> editors = this$0.getEditorProcessInfos(processList);
        ApplicationKt.getApplication().invokeLater(() -> UnityAttachToEditorViewModel.refreshProcessList$lambda$0$0(this$0, editors, processList), ModalityState.any());
    }

    /*
     * WARNING - void declaration
     */
    private static final void refreshProcessList$lambda$0$0(UnityAttachToEditorViewModel this$0, List $editors, ProcessInfo[] $processList) {
        Integer n;
        this$0.editorProcesses.addAll((Collection)$editors);
        this$0.editorInstanceJsonStatus.set((Object)this$0.editorInstanceJson.validateStatus($processList));
        IProperty<Integer> iProperty = this$0.pid;
        if (this$0.editorInstanceJsonStatus.getValue() != EditorInstanceJsonStatus.Valid && ((Collection)$editors).size() == 1) {
            n = ((UnityLocalProcess)((Object)$editors.get(0))).getPid();
        } else if (this$0.editorInstanceJson.getStatus() == EditorInstanceJsonStatus.Valid) {
            EditorInstanceJson.EditorInstanceJsonContents editorInstanceJsonContents = this$0.editorInstanceJson.getContents();
            n = editorInstanceJsonContents != null ? Integer.valueOf(editorInstanceJsonContents.getProcess_id()) : null;
        } else {
            Object v3;
            IProperty<Integer> iProperty2;
            block5: {
                void $this$firstOrNull$iv;
                Iterable iterable = $editors;
                iProperty2 = iProperty;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UnityLocalProcess it = (UnityLocalProcess)((Object)element$iv);
                    boolean bl = false;
                    if (!StringsKt.equals((String)SolutionHostExtensionsKt.getSolutionDirectory((Project)this$0.project).getName(), (String)it.getProjectName(), (boolean)true)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            iProperty = iProperty2;
            UnityLocalProcess unityLocalProcess = v3;
            n = unityLocalProcess != null ? Integer.valueOf(unityLocalProcess.getPid()) : null;
        }
        iProperty.setValue((Object)n);
    }
}

