/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.run.UnityCustomPlayer;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfiguration;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfigurationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bJ$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityRunManagerListener;", "", "<init>", "()V", "startListening", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onProcessAdded", "Lkotlin/Function1;", "Lcom/jetbrains/rider/plugins/unity/run/UnityProcess;", "onProcessRemoved", "enumerateCustomPlayers", "processPlayer", "it", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityRunManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityRunManagerListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityRunManagerListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n23#2:72\n23#2:75\n1869#3,2:73\n*S KotlinDebug\n*F\n+ 1 UnityRunManagerListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityRunManagerListener\n*L\n42#1:72\n53#1:75\n48#1:73,2\n*E\n"})
public final class UnityRunManagerListener {
    public final void startListening(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull Function1<? super UnityProcess, Unit> onProcessAdded, @NotNull Function1<? super UnityProcess, Unit> onProcessRemoved) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onProcessAdded, (String)"onProcessAdded");
        Intrinsics.checkNotNullParameter(onProcessRemoved, (String)"onProcessRemoved");
        this.enumerateCustomPlayers(project, onProcessAdded);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new RunManagerListener(this, onProcessAdded, onProcessRemoved){
            final /* synthetic */ UnityRunManagerListener this$0;
            final /* synthetic */ Function1<UnityProcess, Unit> $onProcessAdded;
            final /* synthetic */ Function1<UnityProcess, Unit> $onProcessRemoved;
            {
                this.this$0 = $receiver;
                this.$onProcessAdded = $onProcessAdded;
                this.$onProcessRemoved = $onProcessRemoved;
            }

            public void runConfigurationAdded(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                super.runConfigurationAdded(settings);
                if (settings.getType() instanceof UnityPlayerDebugConfigurationType) {
                    UnityRunManagerListener.access$processPlayer(this.this$0, settings, this.$onProcessAdded);
                }
            }

            public void runConfigurationRemoved(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                super.runConfigurationRemoved(settings);
                if (settings.getType() instanceof UnityPlayerDebugConfigurationType) {
                    UnityRunManagerListener.access$processPlayer(this.this$0, settings, this.$onProcessRemoved);
                }
            }
        });
    }

    private final void enumerateCustomPlayers(Project project, Function1<? super UnityProcess, Unit> onProcessAdded) {
        UnityRunManagerListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UnityRunManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.trace("Looking for custom players in run configurations");
        try {
            UnityPlayerDebugConfigurationType configurationType = (UnityPlayerDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityPlayerDebugConfigurationType.class);
            List customPlayers = RunManager.Companion.getInstance(project).getConfigurationSettingsList((ConfigurationType)configurationType);
            Iterable $this$forEach$iv = customPlayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                this.processPlayer(it, onProcessAdded);
            }
        }
        catch (Throwable e) {
            UnityRunManagerListener $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(UnityRunManagerListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error(e);
        }
    }

    private final void processPlayer(RunnerAndConfigurationSettings it, Function1<? super UnityProcess, Unit> onProcessAdded) {
        RunConfiguration runConfiguration = it.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfiguration");
        UnityPlayerDebugConfiguration configuration = (UnityPlayerDebugConfiguration)runConfiguration;
        String string = configuration.getState().getPlayerId();
        Intrinsics.checkNotNull((Object)string);
        if (Intrinsics.areEqual((Object)UnityProcess.Companion.typeFromId(string), (Object)"CustomPlayer")) {
            String string2 = configuration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = configuration.getState().getHost();
            if (string3 == null) {
                string3 = "localhost";
            }
            int n = configuration.getState().getPort();
            String string4 = configuration.getState().getProjectName();
            if (string4 == null) {
                string4 = UnityBundle.Companion.message("project.name.custom", new Object[0]);
            }
            UnityCustomPlayer player = new UnityCustomPlayer(string2, string3, n, string4);
            onProcessAdded.invoke((Object)player);
        }
    }

    public static final /* synthetic */ void access$processPlayer(UnityRunManagerListener $this, RunnerAndConfigurationSettings it, Function1 onProcessAdded) {
        $this.processPlayer(it, (Function1<? super UnityProcess, Unit>)onProcessAdded);
    }
}

