/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.AssemblyExecutionContext;
import com.jetbrains.rider.plugins.unity.UnityPluginEnvironment;
import com.jetbrains.rider.plugins.unity.run.UnityIosUsbProcess;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.util.UnityInstallationFinder;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001c\u001a\u00020\tH\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010!\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00110\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/AppleDeviceListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onDeviceAdded", "Lkotlin/Function1;", "Lcom/jetbrains/rider/plugins/unity/run/UnityProcess;", "", "onDeviceRemoved", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "refreshPeriod", "", "devices", "", "", "Lcom/jetbrains/rider/plugins/unity/run/UnityIosUsbProcess;", "usage", "", "thread", "Ljava/lang/Thread;", "processHandler", "Lcom/intellij/execution/process/CapturingProcessHandler;", "descriptions", "", "", "stop", "loadDescriptions", "iosSupportPath", "Ljava/nio/file/Path;", "startListener", "processDevices", "rawDevices", "", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nAppleDeviceListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleDeviceListener.kt\ncom/jetbrains/rider/plugins/unity/run/AppleDeviceListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,253:1\n1869#2,2:254\n1617#2,9:256\n1869#2:265\n1870#2:267\n1626#2:268\n1869#2,2:269\n1869#2:278\n1870#2:280\n1#3:266\n1#3:279\n504#4,7:271\n*S KotlinDebug\n*F\n+ 1 AppleDeviceListener.kt\ncom/jetbrains/rider/plugins/unity/run/AppleDeviceListener\n*L\n219#1:254,2\n221#1:256,9\n221#1:265\n221#1:267\n221#1:268\n246#1:269,2\n247#1:278\n247#1:280\n221#1:266\n247#1:271,7\n*E\n"})
public final class AppleDeviceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<UnityProcess, Unit> onDeviceAdded;
    @NotNull
    private final Function1<UnityProcess, Unit> onDeviceRemoved;
    private final long refreshPeriod;
    @NotNull
    private final Map<String, UnityIosUsbProcess> devices;
    @NotNull
    private final Map<String, Boolean> usage;
    @Nullable
    private final Thread thread;
    @Nullable
    private final CapturingProcessHandler processHandler;
    @NotNull
    private final Map<Integer, String> descriptions;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Regex countRegex;
    private static final Pattern deviceRegex;

    /*
     * Unable to fully structure code
     */
    public AppleDeviceListener(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull Function1<? super UnityProcess, Unit> onDeviceAdded, @NotNull Function1<? super UnityProcess, Unit> onDeviceRemoved) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onDeviceAdded, (String)"onDeviceAdded");
        Intrinsics.checkNotNullParameter(onDeviceRemoved, (String)"onDeviceRemoved");
        super();
        this.onDeviceAdded = onDeviceAdded;
        this.onDeviceRemoved = onDeviceRemoved;
        this.refreshPeriod = 1000L;
        this.devices = new LinkedHashMap<K, V>();
        this.usage = new LinkedHashMap<K, V>();
        varProcessHandler = null;
        varDescriptions = MapsKt.emptyMap();
        try {
            v0 = UnityInstallationFinder.Companion.getInstance(project).getAdditionalPlaybackEnginesRoot();
            v1 = iosSupportPath = v0 != null ? v0.resolve("iOSSupport") : null;
            if (iosSupportPath == null) ** GOTO lbl-1000
            v2 = new LinkOption[]{};
            if (Files.isDirectory(iosSupportPath, Arrays.copyOf(v2, v2.length))) {
                AppleDeviceListener.logger.trace("Using iOSSupportPath: " + iosSupportPath);
                varDescriptions = this.loadDescriptions(iosSupportPath);
                varProcessHandler = this.startListener(iosSupportPath);
            } else lbl-1000:
            // 2 sources

            {
                AppleDeviceListener.logger.warn("Cannot find " + iosSupportPath + " folder");
            }
        }
        catch (Throwable e) {
            AppleDeviceListener.logger.error(e);
        }
        this.descriptions = varDescriptions;
        this.processHandler = varProcessHandler;
        this.thread = this.processHandler != null ? ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, _init_$lambda$0(com.jetbrains.rider.plugins.unity.run.AppleDeviceListener ), ()Lkotlin/Unit;)((AppleDeviceListener)this), (int)31, null) : null;
        lifetime.onTermination((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, _init_$lambda$1(com.jetbrains.rider.plugins.unity.run.AppleDeviceListener ), ()Lkotlin/Unit;)((AppleDeviceListener)this));
    }

    private final void stop() {
        if (this.thread == null || this.processHandler == null) {
            return;
        }
        logger.trace("Telling ListIosUsbDevices helper exe to stop");
        OutputStream it = this.processHandler.getProcessInput();
        boolean bl = false;
        new PrintWriter(it, true).println("stop");
        long threadTimeout = this.refreshPeriod * (long)200;
        try {
            this.thread.join(threadTimeout);
        }
        catch (Throwable e) {
            logger.error(e);
        }
        if (this.thread.isAlive()) {
            logger.warn("ListIosUsbDevices helper exe didn't return in " + threadTimeout + "ms. Killing");
            this.processHandler.destroyProcess();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, String> loadDescriptions(Path iosSupportPath) {
        Map map;
        Path file = iosSupportPath.resolve("Data/iosdevices.csv");
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            void var3_3;
            logger.trace("Loading iOS device descriptions from " + file);
            Map map2 = new LinkedHashMap();
            try {
                File file2 = file.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                FilesKt.forEachLine$default((File)file2, null, arg_0 -> AppleDeviceListener.loadDescriptions$lambda$0(map2, arg_0), (int)1, null);
            }
            catch (Throwable e) {
                logger.error(e);
            }
            map = var3_3;
        } else {
            logger.warn("Cannot find iOS device description at " + file);
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final CapturingProcessHandler startListener(Path iosSupportPath) {
        String[] stringArray = new String[]{"DotFiles"};
        File helperExe = UnityPluginEnvironment.INSTANCE.getBundledFile("JetBrains.Rider.Unity.ListIosUsbDevices.dll", stringArray);
        String[] stringArray2 = new String[]{((Object)iosSupportPath).toString(), String.valueOf(this.refreshPeriod)};
        GeneralCommandLine commandLine = AssemblyExecutionContext.Companion.create(helperExe, stringArray2).fillCommandLine(new GeneralCommandLine());
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        List rawDevices = new ArrayList();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(helperExe, this, rawDevices){
            private int expectedCount;
            private String unexpectedText;
            final /* synthetic */ File $helperExe;
            final /* synthetic */ AppleDeviceListener this$0;
            final /* synthetic */ List<String> $rawDevices;
            {
                this.$helperExe = $helperExe;
                this.this$0 = $receiver;
                this.$rawDevices = $rawDevices;
                this.unexpectedText = "";
            }

            public final int getExpectedCount() {
                return this.expectedCount;
            }

            public final void setExpectedCount(int n) {
                this.expectedCount = n;
            }

            public final String getUnexpectedText() {
                return this.unexpectedText;
            }

            public final void setUnexpectedText(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.unexpectedText = string;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AppleDeviceListener.access$getLogger$cp().trace("Helper process exited. Exit code: " + event.getExitCode());
                if (((CharSequence)this.unexpectedText).length() > 0) {
                    AppleDeviceListener.access$getLogger$cp().error("Error running " + this.$helperExe + ". Output:\n" + this.unexpectedText);
                }
            }

            public void onTextAvailable(ProcessEvent event, Key<?> key) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(key, (String)"key");
                String string = event.getText();
                AppleDeviceListener.access$getLogger$cp().debug("Received text: " + (string != null ? ((Object)StringsKt.trimEnd((CharSequence)string)).toString() : null));
                String string2 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"[usbmuxd", (boolean)false, (int)2, null)) {
                    if (this.expectedCount == 0) {
                        Regex regex = AppleDeviceListener.access$getCountRegex$cp();
                        String string3 = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                        MatchResult match = Regex.find$default((Regex)regex, (CharSequence)string3, (int)0, (int)2, null);
                        if (match != null) {
                            this.unexpectedText = "";
                            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"count");
                            int n = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : (this.expectedCount = 0);
                            if (this.expectedCount == 0 && !AppleDeviceListener.access$getDevices$p(this.this$0).isEmpty()) {
                                AppleDeviceListener.access$processDevices(this.this$0, this.$rawDevices);
                            }
                        } else {
                            this.unexpectedText = this.unexpectedText + event.getText();
                        }
                    } else {
                        String string4 = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        this.$rawDevices.add(string4);
                        this.expectedCount += -1;
                        if (this.expectedCount == 0) {
                            AppleDeviceListener.access$getLogger$cp().trace("Refreshing Apple USB devices: " + this.$rawDevices.size());
                            AppleDeviceListener.access$processDevices(this.this$0, this.$rawDevices);
                            this.$rawDevices.clear();
                        }
                    }
                }
            }
        });
        return processHandler;
    }

    private final void processDevices(List<String> rawDevices) {
        Iterator $this$mapNotNullTo$iv$iv;
        Object element$iv22;
        Iterable $this$forEach$iv = this.usage.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv22 : $this$forEach$iv) {
            String it = (String)element$iv22;
            boolean bl = false;
            this.usage.put(it, false);
        }
        Iterable $this$mapNotNull$iv = rawDevices;
        boolean $i$f$mapNotNull = false;
        element$iv22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnityIosUsbProcess unityIosUsbProcess;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl22 = false;
            Matcher matcher = deviceRegex.matcher(it);
            if (matcher.find()) {
                String displayName;
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)matcher.group("productId"), (String)"group(...)");
                int n = 16;
                int productId = Integer.parseInt(string, CharsKt.checkRadix((int)n));
                String deviceId = matcher.group("deviceId");
                String string2 = this.descriptions.get(productId);
                if (string2 == null) {
                    string2 = displayName = "Apple Device";
                }
                if (!this.devices.containsKey(deviceId)) {
                    Intrinsics.checkNotNull((Object)deviceId);
                    UnityIosUsbProcess process = new UnityIosUsbProcess(displayName, deviceId, displayName);
                    this.devices.put(deviceId, process);
                    this.usage.put(deviceId, true);
                    unityIosUsbProcess = process;
                } else {
                    this.usage.put(deviceId, true);
                    unityIosUsbProcess = null;
                }
            } else {
                logger.warn("Expected device text. Could not match: " + it);
                unityIosUsbProcess = null;
            }
            if (unityIosUsbProcess == null) continue;
            UnityIosUsbProcess it$iv$iv = unityIosUsbProcess;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newProcesses = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = newProcesses;
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            UnityIosUsbProcess unityIosUsbProcess = (UnityIosUsbProcess)((Object)element$iv3);
            boolean bl3 = false;
            this.onDeviceAdded.invoke((Object)unityIosUsbProcess);
        }
        Map<String, Boolean> $this$filterValues$iv = this.usage;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            boolean it = (Boolean)entry.getValue();
            boolean bl4 = false;
            if (!(!it)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Iterable $this$forEach$iv3 = ((Map)result$iv).keySet();
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv3) {
            UnityIosUsbProcess it;
            String string = (String)element$iv;
            boolean bl5 = false;
            this.usage.remove(string);
            if (this.devices.remove(string) == null) continue;
            boolean bl4 = false;
            this.onDeviceRemoved.invoke((Object)it);
        }
    }

    private static final Unit _init_$lambda$0(AppleDeviceListener this$0) {
        this$0.processHandler.runProcess();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(AppleDeviceListener this$0) {
        this$0.stop();
        return Unit.INSTANCE;
    }

    private static final Unit loadDescriptions$lambda$0(Map $map, String it) {
        char[] cArray;
        List columns;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null) && (columns = StringsKt.split$default((CharSequence)it, (char[])(cArray = new char[]{';'}), (boolean)false, (int)0, (int)6, null)).size() >= 4) {
            String v = (String)columns.get(1);
            boolean bl = false;
            int productId = ((CharSequence)v).length() > 0 ? Integer.parseInt(v, CharsKt.checkRadix((int)16)) : 0;
            String type = (String)columns.get(4);
            if (productId != 0) {
                $map.put(productId, type);
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Regex access$getCountRegex$cp() {
        return countRegex;
    }

    public static final /* synthetic */ Map access$getDevices$p(AppleDeviceListener $this) {
        return $this.devices;
    }

    public static final /* synthetic */ void access$processDevices(AppleDeviceListener $this, List rawDevices) {
        $this.processDevices(rawDevices);
    }

    static {
        Logger logger = Logger.getInstance(AppleDeviceListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AppleDeviceListener.logger = logger;
        countRegex = new Regex("^(?<count>\\d+)$");
        deviceRegex = Pattern.compile("(?<productId>\\S*)\\s(?<deviceId>.*)");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/AppleDeviceListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "countRegex", "Lkotlin/text/Regex;", "deviceRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

