/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.notifications;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/unity/notifications/AssetModeForceTextNotification;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "showNotificationIfNeeded", "", "Companion", "ProtocolListener", "intellij.rider.plugins.unity"})
public final class AssetModeForceTextNotification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String settingName = "do_not_show_unity_asset_mode_notification";
    private static final NotificationGroup notificationGroupId = NotificationGroupManager.getInstance().getNotificationGroup("Unity Asset Mode");

    public AssetModeForceTextNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void showNotificationIfNeeded() {
        if (PropertiesComponent.getInstance((Project)this.project).getBoolean(settingName)) {
            return;
        }
        String message = UnityBundle.Companion.message("AssetModeForceTextNotification.notification.message.some.advanced.integration.unavailable", new Object[0]);
        Notification assetModeNotification = new Notification(notificationGroupId.getDisplayId(), UnityBundle.Companion.message("notification.title.recommend.switching.to.text.asset.serialisation.mode", new Object[0]), message, NotificationType.WARNING);
        String string = UnityBundle.Companion.message("read.more", new Object[0]);
        assetModeNotification.addAction((AnAction)new NotificationAction(string){

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                String url = "https://github.com/JetBrains/resharper-unity/wiki/Asset-serialization-mode";
                BrowserUtil.browse((String)url);
            }
        });
        string = UnityBundle.Companion.message("link.label.do.not.show.again", new Object[0]);
        assetModeNotification.addAction((AnAction)new NotificationAction(this, string){
            final /* synthetic */ AssetModeForceTextNotification this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                PropertiesComponent.getInstance((Project)AssetModeForceTextNotification.access$getProject$p(this.this$0)).setValue("do_not_show_unity_asset_mode_notification", true);
            }
        });
        Notifications.Bus.notify((Notification)assetModeNotification, (Project)this.project);
    }

    public static final /* synthetic */ Project access$getProject$p(AssetModeForceTextNotification $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/unity/notifications/AssetModeForceTextNotification$Companion;", "", "<init>", "()V", "settingName", "", "notificationGroupId", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getInstance", "Lcom/jetbrains/rider/plugins/unity/notifications/AssetModeForceTextNotification;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nAssetModeForceTextNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetModeForceTextNotification.kt\ncom/jetbrains/rider/plugins/unity/notifications/AssetModeForceTextNotification$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,57:1\n30#2,2:58\n*S KotlinDebug\n*F\n+ 1 AssetModeForceTextNotification.kt\ncom/jetbrains/rider/plugins/unity/notifications/AssetModeForceTextNotification$Companion\n*L\n23#1:58,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AssetModeForceTextNotification getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AssetModeForceTextNotification> serviceClass$iv = AssetModeForceTextNotification.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AssetModeForceTextNotification)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/notifications/AssetModeForceTextNotification$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/FrontendBackendModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.unity"})
    public static final class ProtocolListener
    implements SolutionExtListener<FrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            SourceExKt.adviseNotNullOnce(model.getNotifyAssetModeForceText(), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$0(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, Unit it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.getInstance($session.getProject()).showNotificationIfNeeded();
            return Unit.INSTANCE;
        }
    }
}

