/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.PackageNodesKt;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewPane;
import icons.UnityIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u000bH\u0014J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0015\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/BuiltinPackageNode;", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "packageEntity", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;)V", "calculateChildren", "", "createNode", "Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "canNavigateToSource", "", "navigate", "", "requestFocus", "getName", "", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "compareTo", "", "other", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nPackageNodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/BuiltinPackageNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,397:1\n1740#2,3:398\n*S KotlinDebug\n*F\n+ 1 PackageNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/BuiltinPackageNode\n*L\n287#1:398,3\n*E\n"})
public final class BuiltinPackageNode
extends UnityExplorerFileSystemNode
implements Comparable<AbstractTreeNode<?>> {
    @NotNull
    private final UnityPackageEntity packageEntity;

    public BuiltinPackageNode(@NotNull Project project, @NotNull UnityPackageEntity packageEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageEntity, (String)"packageEntity");
        VirtualFile virtualFile = packageEntity.getPackageFolder();
        Intrinsics.checkNotNull((Object)virtualFile);
        super(project, virtualFile, CollectionsKt.emptyList(), AncestorNodeType.ReadOnlyPackage);
        this.packageEntity = packageEntity;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        block5: {
            block6: {
                v0 = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"myProject");
                if (SolutionExplorerViewPane.Companion.getInstance(v0).getMyShowAllFiles()) {
                    return super.calculateChildren();
                }
                children = super.calculateChildren();
                $this$all$iv = children;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block6;
                v1 = true;
                break block5;
            }
            for (T element$iv : $this$all$iv) {
                it = (AbstractTreeNode)element$iv;
                $i$a$-all-BuiltinPackageNode$calculateChildren$1 = false;
                v2 = it.getName();
                if (v2 != null ? StringsKt.startsWith$default((String)v2, (String)"package.json", (boolean)false, (int)2, null) : false) ** GOTO lbl-1000
                v3 = it.getName();
                if (v3 != null ? StringsKt.startsWith$default((String)v3, (String)".icon.png", (boolean)false, (int)2, null) : false) ** GOTO lbl-1000
                v4 = it.getName();
                v5 = v4 != null ? StringsKt.startsWith$default((String)v4, (String)"package.ModuleCompilationTrigger", (boolean)false, (int)2, null) : false;
                if (v5) lbl-1000:
                // 3 sources

                {
                    v6 = true;
                } else {
                    v6 = false;
                }
                if (v6) continue;
                v1 = false;
                break block5;
            }
            v1 = true;
        }
        if (v1) {
            return new ArrayList<E>();
        }
        return super.calculateChildren();
    }

    @Override
    @NotNull
    public FileSystemNodeBase createNode(@NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new UnityExplorerFileSystemNode(project, virtualFile, nestedFiles, this.getDescendentOf());
    }

    public boolean canNavigateToSource() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            return super.canNavigateToSource();
        }
        return true;
    }

    public void navigate(boolean requestFocus) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            super.navigate(requestFocus);
            return;
        }
        VirtualFile packageJson = this.getVirtualFile().findChild("package.json");
        if (packageJson != null) {
            new OpenFileDescriptor(this.myProject, packageJson).navigate(requestFocus);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.packageEntity.getDisplayName();
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        String tooltip;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(UnityIcons.Explorer.Companion.getBuiltInPackage());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            SolutionViewUtilsKt.addAdditionalMark$default((PresentationData)presentation, (Project)project2, (VirtualFile)this.getVirtualFile(), (boolean)false, (int)4, null);
        }
        if (!Intrinsics.areEqual((Object)(tooltip = PackageNodesKt.access$getPackageTooltip(this.getName(), this.packageEntity)), (Object)this.getName())) {
            presentation.setTooltip(tooltip);
        }
    }

    @Override
    public int compareTo(@NotNull AbstractTreeNode<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(this.getName(), other.getName());
    }
}

