/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.breakpoints;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointConstants;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointsKt;
import icons.UnityIcons;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J(\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010%\u001a\u0004\u0018\u00010&H\u0016\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/UnityPausepointBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "<init>", "()V", "getDisplayText", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "getDisabledIcon", "Ljavax/swing/Icon;", "getEnabledIcon", "getInactiveDependentIcon", "getInvalidIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getSuspendNoneIcon", "getTemporaryIcon", "getVerifiedIcon", "getVerifiedIconWithNoSuspend", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "getPriority", "getDefaultSuspendPolicy", "Lcom/intellij/xdebugger/breakpoints/SuspendPolicy;", "getVisibleStandardPanels", "Ljava/util/EnumSet;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType$StandardPanels;", "getAdditionalPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "Companion", "intellij.rider.plugins.unity"})
public final class UnityPausepointBreakpointType
extends DotNetLineBreakpointType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String Id = "UnityPausepointType";
    @Nls
    @NotNull
    private static final String Title = UnityBundle.Companion.message("breakpoint.type.unity.pausepoints", new Object[0]);

    public UnityPausepointBreakpointType() {
        super(Id, Title);
    }

    @NotNull
    public String getDisplayText(@Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Object[] objectArray = new Object[]{super.getDisplayText(breakpoint)};
        return UnityBundle.Companion.message("pause.unity.editor.when.debugger.reaches.0", objectArray);
    }

    @NotNull
    public Icon getDisabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_disabled_pausepoint();
    }

    @NotNull
    public Icon getEnabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_set_pausepoint();
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return UnityIcons.Debugger.Companion.getDb_dep_line_pausepoint();
    }

    @NotNull
    public Icon getInvalidIcon() {
        return UnityIcons.Debugger.Companion.getDb_invalid_pausepoint();
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_muted_disabled_pausepoint();
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_muted_pausepoint();
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        return UnityIcons.Debugger.Companion.getDb_no_suspend_pausepoint();
    }

    @NotNull
    public Icon getTemporaryIcon() {
        return UnityIcons.Debugger.Companion.getDb_set_pausepoint();
    }

    @NotNull
    public Icon getVerifiedIcon() {
        return UnityIcons.Debugger.Companion.getDb_verified_pausepoint();
    }

    @NotNull
    public Icon getVerifiedIconWithNoSuspend() {
        return UnityIcons.Debugger.Companion.getDb_verified_no_suspend_pausepoint();
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public int getPriority() {
        return super.getPriority() - 1;
    }

    @NotNull
    public SuspendPolicy getDefaultSuspendPolicy() {
        return SuspendPolicy.NONE;
    }

    @NotNull
    public EnumSet<XBreakpointType.StandardPanels> getVisibleStandardPanels() {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)XBreakpointType.StandardPanels.DEPENDENCY);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return enumSet;
    }

    @NotNull
    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)UnityPausepointConstants.INSTANCE.getConvertToLineBreakpointActionText(), arg_0 -> UnityPausepointBreakpointType.getAdditionalPopupMenuActions$lambda$1(arg_0 -> UnityPausepointBreakpointType.getAdditionalPopupMenuActions$lambda$0(breakpoint, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        DumbAwareAction action = dumbAwareAction;
        Object[] objectArray = new DumbAwareAction[]{action};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private static final Unit getAdditionalPopupMenuActions$lambda$0(XLineBreakpoint $breakpoint, AnActionEvent it) {
        DataContext dataContext = it.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        Project project = editor2.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        Pair pair = XBreakpointUtil.findSelectedBreakpoint((Project)project2, (Editor)editor2);
        if ($breakpoint.getProperties() != null && Intrinsics.areEqual((Object)pair.second, (Object)$breakpoint)) {
            UnityPausepointsKt.convertToLineBreakpoint(project2, (XLineBreakpoint<DotNetLineBreakpointProperties>)$breakpoint, editor2, (GutterIconRenderer)pair.first);
        }
        return Unit.INSTANCE;
    }

    private static final void getAdditionalPopupMenuActions$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/UnityPausepointBreakpointType$Companion;", "", "<init>", "()V", "Id", "", "Title", "getTitle", "()Ljava/lang/String;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

