/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.breakpoints;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.debugger.breakpoint.IDotNetLineBreakpointPopupActionsProvider;
import com.jetbrains.rider.plugins.unity.actions.ActionUtilsKt;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointBreakpointType;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointConstants;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/ConvertToPausepointPopupActionProvider;", "Lcom/jetbrains/rider/debugger/breakpoint/IDotNetLineBreakpointPopupActionsProvider;", "<init>", "()V", "getCustomPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "ConvertToPausepointAction", "intellij.rider.plugins.unity"})
public final class ConvertToPausepointPopupActionProvider
implements IDotNetLineBreakpointPopupActionsProvider {
    @NotNull
    public List<AnAction> getCustomPopupMenuActions(@NotNull XLineBreakpoint<?> breakpoint, @Nullable XDebugSession session) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (breakpoint.getType() instanceof DotNetLineBreakpointType && !(breakpoint.getType() instanceof UnityPausepointBreakpointType)) {
            return CollectionsKt.listOf((Object)((Object)new ConvertToPausepointAction(breakpoint)));
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/ConvertToPausepointPopupActionProvider$ConvertToPausepointAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.rider.plugins.unity"})
    private static final class ConvertToPausepointAction
    extends DumbAwareAction {
        @NotNull
        private final XLineBreakpoint<?> breakpoint;

        public ConvertToPausepointAction(@NotNull XLineBreakpoint<?> breakpoint) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            super(UnityPausepointConstants.INSTANCE.getConvertToPausepointActionText());
            this.breakpoint = breakpoint;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setVisible(ActionUtilsKt.getValueOrDefault(ActionUtilsKt.isUnityProject(e)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            XLineBreakpoint<?> xLineBreakpoint = this.breakpoint;
            Intrinsics.checkNotNull(xLineBreakpoint, (String)"null cannot be cast to non-null type com.intellij.xdebugger.breakpoints.XLineBreakpoint<com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties>");
            UnityPausepointsKt.convertToPausepoint$default(project2, xLineBreakpoint, editor2, null, 8, null);
        }
    }
}

