/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.plugins.unity.actions.RiderUnityLogViewAction;
import com.jetbrains.rider.plugins.unity.actions.UnityPluginActionsBundle;
import com.jetbrains.rider.plugins.unity.model.UnityApplicationData;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/unity/actions/RiderUnityOpenEditorLogAction;", "Lcom/jetbrains/rider/plugins/unity/actions/RiderUnityLogViewAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.rider.plugins.unity"})
public final class RiderUnityOpenEditorLogAction
extends RiderUnityLogViewAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String actionId = "RiderUnityOpenEditorLogAction";
    @NotNull
    private static final Logger logger;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String path;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        UnityApplicationData unityApplicationData = (UnityApplicationData)FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project2)).getUnityApplicationData().getValueOrNull();
        String string = path = unityApplicationData != null ? unityApplicationData.getEditorLogPath() : null;
        if (path != null) {
            VirtualFile vf = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
            if (vf != null) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, vf);
                FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
            } else {
                NotificationGroup groupId = NotificationGroupManager.getInstance().getNotificationGroup("Unity project open");
                String title = UnityPluginActionsBundle.Companion.message("notification.title.could.not.open.unity.editor.log", new Object[0]);
                Object[] objectArray = new Object[]{path};
                String message = UnityPluginActionsBundle.Companion.message("notification.content.not.present", objectArray);
                Notification notification = new Notification(groupId.getDisplayId(), title, message, NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)notification, (Project)project2);
            }
        } else {
            logger.error("Could not open Unity Editor Log, path was null");
        }
    }

    static {
        Logger logger = Logger.getInstance(RiderUnityOpenEditorLogAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderUnityOpenEditorLogAction.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/unity/actions/RiderUnityOpenEditorLogAction$Companion;", "", "<init>", "()V", "actionId", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

